/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.AdvancedDrawableViewCreationDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.FocusDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNodeWithOptionProvider;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.EnumSet;
import java.util.List;

abstract class RepresentationViewShowInViewSupport
extends SupportsShowInView {
    private int m_nextSecondaryId = 0;

    RepresentationViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    @Override
    public boolean isPotentialDoubleClickTarget() {
        return false;
    }

    protected List<Element> getElementsForShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getElementsForShowInView' must not be null";
        return ((IRepresentationProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IRepresentationProvider.class)).filterElementsForShowInView(elements);
    }

    public abstract PresentationMode getDefaultPresentationMode();

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        if (!selectedElements.isEmpty() && WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED) && WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getNumberOfComponents() > 0) {
            List<Element> elementsForShowInView = this.getElementsForShowInView(selectedElements);
            if (elementsForShowInView.isEmpty()) {
                return null;
            }
            if (elementsForShowInView.size() == 1) {
                Element first = elementsForShowInView.get(0);
                if (first instanceof CycleGroup) {
                    ShowInViewNode showInViewMenuEntryModel = new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true, this.getNextOrReusedSecondaryId(secondaryIdForReuse));
                    showInViewMenuEntryModel.addOption((IStandardEnumeration)FocusMode.NO_ADDITIONAL);
                    this.adjustShowInViewOptions(showInViewMenuEntryModel, options, this.getDefaultPresentationMode());
                    return new ShowInView(showInViewMenuEntryModel);
                }
                if (first instanceof ArchitectureFile) {
                    ShowInViewNode showInViewMenuEntryModel = new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true, this.getNextOrReusedSecondaryId(secondaryIdForReuse));
                    showInViewMenuEntryModel.addOption((IStandardEnumeration)FocusMode.IN_AND_OUT);
                    this.adjustShowInViewOptions(showInViewMenuEntryModel, options, this.getDefaultPresentationMode());
                    return new ShowInView(showInViewMenuEntryModel);
                }
            }
            if (selectedElements.size() == 1 && selectedElements.get(0) instanceof RepresentationEdge) {
                ShowInViewNode edgeMenuEntry = new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true, this.getNextOrReusedSecondaryId(secondaryIdForReuse));
                edgeMenuEntry.addOption((IStandardEnumeration)FocusMode.NO_ADDITIONAL);
                this.adjustShowInViewOptions(edgeMenuEntry, options, this.getDefaultPresentationMode());
                return new ShowInView(edgeMenuEntry);
            }
            ShowInViewNode rootMenuEntry = new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true, this.getNextOrReusedSecondaryId(secondaryIdForReuse));
            this.adjustShowInViewOptions(rootMenuEntry, options, this.getDefaultPresentationMode());
            this.addFocusBasedSubMenuEntries(rootMenuEntry);
            return new ShowInView(rootMenuEntry);
        }
        return null;
    }

    @Override
    public boolean supportsShowInSelf() {
        return true;
    }

    protected final String getNextOrReusedSecondaryId(String secondaryIdForReuse) {
        return secondaryIdForReuse == null ? String.valueOf(this.m_nextSecondaryId++) : secondaryIdForReuse;
    }

    protected final void addFocusBasedSubMenuEntries(ShowInViewNode parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addFocusBasedSubMenuEntries' must not be null";
        FocusMode[] focusModes = FocusMode.values();
        int i = 0;
        while (i < focusModes.length) {
            FocusMode mode = focusModes[i];
            ShowInViewNode childNode = new ShowInViewNode(parent.getElements(), mode.getPresentationName(), mode.getStandardName(), false);
            childNode.addOption((IStandardEnumeration)mode);
            parent.addChild(childNode);
            if (i == focusModes.length - 1) {
                childNode.setAddSeparatorAfter(true);
            }
            ++i;
        }
        EnumSet<FocusDialog.FocusDialogProperty> dialogProperties = EnumSet.of(FocusDialog.FocusDialogProperty.SUPPORTS_DEPENDENCY_TYPES, FocusDialog.FocusDialogProperty.SUPPORTS_TRANSITIVE, FocusDialog.FocusDialogProperty.SUPPORTS_ONLY_INTERNAL);
        AdvancedDrawableViewCreationDialog showInViewOptionProvider = new AdvancedDrawableViewCreationDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), dialogProperties);
        ShowInViewNodeWithOptionProvider advancedFocusNode = new ShowInViewNodeWithOptionProvider(parent.getElements(), "Advanced...", "Focus", showInViewOptionProvider);
        parent.addChild(advancedFocusNode);
    }

    protected void adjustShowInViewOptions(ShowInViewNode showInViewMenuEntryModel, List<IStandardEnumeration> options, PresentationMode defaultPresentationMode) {
        assert (showInViewMenuEntryModel != null) : "Parameter 'showInViewMenuEntryModel' of method 'adjustShowInViewOptions' must not be null";
        assert (options != null) : "Parameter 'options' of method 'adjustShowInViewOptions' must not be null";
        assert (defaultPresentationMode != null) : "Parameter 'defaultPresentationMode' of method 'adjustShowInViewOptions' must not be null";
        boolean containsPresentationMode = false;
        for (IStandardEnumeration option : options) {
            if (!(option instanceof PresentationMode)) continue;
            containsPresentationMode = true;
            break;
        }
        if (!options.isEmpty()) {
            showInViewMenuEntryModel.addAllOptions(options);
        }
        if (!containsPresentationMode) {
            showInViewMenuEntryModel.addOption((IStandardEnumeration)defaultPresentationMode);
        }
    }
}

