/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExplorationViewShowInViewRequest
implements IStandardEnumeration {
    private final Type m_type;
    private final ExplorationViewFocusProperties m_focusProperties;
    private final List<ExplorationViewOnDemand> m_onDemand = new ArrayList<ExplorationViewOnDemand>(2);

    public ExplorationViewShowInViewRequest(Type type, ExplorationViewFocusProperties focusProperties, ExplorationViewOnDemand onDemand) {
        assert (type != null) : "Parameter 'type' of method 'ExplorationViewShowInViewRequest' must not be null";
        this.m_type = type;
        this.m_focusProperties = focusProperties;
        if (onDemand != null) {
            this.m_onDemand.add(onDemand);
        }
    }

    void addOnDemand(ExplorationViewOnDemand onDemand) {
        assert (onDemand != null) : "Parameter 'onDemand' of method 'addOnDemand' must not be null";
        assert (!this.m_onDemand.contains(onDemand)) : "Already added onDemand";
        this.m_onDemand.add(onDemand);
    }

    public List<ExplorationViewOnDemand> getOnDemand() {
        return Collections.unmodifiableList(this.m_onDemand);
    }

    public Type getType() {
        return this.m_type;
    }

    public PresentationMode getPresentationMode() {
        return this.m_type.getPresentationMode();
    }

    public ExplorationViewFocusProperties getFocusProperties() {
        return this.m_focusProperties;
    }

    public String getStandardName() {
        return this.m_type.getStandardName();
    }

    public String getPresentationName() {
        return this.m_type.getPresentationName();
    }

    String getImageResourceName() {
        return this.m_type.getImageResourceName();
    }

    public String toString() {
        return this.m_type.name();
    }

    public static final class Type
    extends Enum<Type>
    implements IStandardEnumeration {
        public static final /* enum */ Type ARCHITECTURAL_VIEW = new Type("ArchitecturalView", null);
        public static final /* enum */ Type ON_DEMAND = new Type("ExplorationView");
        public static final /* enum */ Type ON_DEMAND_CYCLE_FLAT = new Type("ExplorationView", null, PresentationMode.FLAT, false);
        public static final /* enum */ Type ON_DEMAND_CYCLE_NONE = new Type("ExplorationView", null, PresentationMode.NONE, false);
        public static final /* enum */ Type ON_DEMAND_ARCHITECTURE_FILE = new Type("ExplorationView", null);
        public static final /* enum */ Type ON_DEMAND_SELECT_AND_REVEAL = new Type("SelectAndReveal");
        public static final /* enum */ Type ON_DEMAND_NO_ADDITIONAL = new Type("NoAdditional", ExplorationViewFocusProperties.NodeInclusionMode.NO_ADDITONAL_NODES);
        public static final /* enum */ Type ON_DEMAND_IN_AND_OUT = new Type("InAndOut", ExplorationViewFocusProperties.NodeInclusionMode.NODES_IN_AND_OUT);
        public static final /* enum */ Type ON_DEMAND_IN = new Type("In", ExplorationViewFocusProperties.NodeInclusionMode.NODES_IN);
        public static final /* enum */ Type ON_DEMAND_OUT = new Type("Out", ExplorationViewFocusProperties.NodeInclusionMode.NODES_OUT);
        public static final /* enum */ Type ON_DEMAND_ADVANCED = new Type("Focus", null);
        private final String m_imageResourceName;
        private final ExplorationViewFocusProperties.NodeInclusionMode m_mode;
        private final PresentationMode m_presentationMode;
        private final boolean m_useFocusProperties;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{ARCHITECTURAL_VIEW, ON_DEMAND, ON_DEMAND_CYCLE_FLAT, ON_DEMAND_CYCLE_NONE, ON_DEMAND_ARCHITECTURE_FILE, ON_DEMAND_SELECT_AND_REVEAL, ON_DEMAND_NO_ADDITIONAL, ON_DEMAND_IN_AND_OUT, ON_DEMAND_IN, ON_DEMAND_OUT, ON_DEMAND_ADVANCED};
        }

        private Type(String imageResourceName) {
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'Type' must not be empty";
            this.m_imageResourceName = imageResourceName;
            this.m_mode = null;
            this.m_presentationMode = null;
            this.m_useFocusProperties = false;
        }

        private Type(String imageResourceName, ExplorationViewFocusProperties.NodeInclusionMode mode) {
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'Type' must not be empty";
            this.m_imageResourceName = imageResourceName;
            this.m_mode = mode;
            this.m_presentationMode = null;
            this.m_useFocusProperties = true;
        }

        private Type(String imageResourceName, ExplorationViewFocusProperties.NodeInclusionMode mode, PresentationMode presentationMode, boolean useFocusProperties) {
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'Type' must not be empty";
            this.m_imageResourceName = imageResourceName;
            this.m_mode = mode;
            this.m_presentationMode = presentationMode;
            this.m_useFocusProperties = useFocusProperties;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        String getImageResourceName() {
            return this.m_imageResourceName;
        }

        boolean useFocusProperties() {
            return this.m_useFocusProperties;
        }

        ExplorationViewFocusProperties.NodeInclusionMode getNodeInclusionMode() {
            return this.m_mode;
        }

        PresentationMode getPresentationMode() {
            return this.m_presentationMode;
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

