/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

final class DrawableViewStatusBar
extends Composite {
    private final Map<CoreParserDependencyType, Button> m_dependencyTypeToButton;
    private final boolean m_supportsDependencyTypeFocus;
    private final Button m_focusMode;
    private final Button m_transitive;
    private final Button m_onlyInternal;

    DrawableViewStatusBar(Composite parent, boolean supportsDependencyTypeFocus) {
        super(parent, 0);
        this.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_supportsDependencyTypeFocus = supportsDependencyTypeFocus;
        this.setEnabled(false);
        GridLayout layout = new GridLayout(CoreParserDependencyType.values().length + 3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.m_focusMode = new Button((Composite)this, 0x800002);
        this.m_focusMode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_focusMode.setText(FocusMode.NO_ADDITIONAL.getPresentationName());
        this.m_focusMode.setSelection(true);
        this.m_transitive = new Button((Composite)this, 0x800002);
        this.m_transitive.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_transitive.setText("Transitive");
        this.m_onlyInternal = new Button((Composite)this, 0x800002);
        this.m_onlyInternal.setText("Internal");
        this.m_onlyInternal.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        if (this.m_supportsDependencyTypeFocus) {
            this.m_dependencyTypeToButton = new THashMap();
            CoreParserDependencyType[] coreParserDependencyTypeArray = CoreParserDependencyType.values();
            int n = coreParserDependencyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CoreParserDependencyType nextDependencyType = coreParserDependencyTypeArray[n2];
                Button nextButton = new Button((Composite)this, 0x800002);
                nextButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                nextButton.setText(nextDependencyType.getPresentationName());
                this.m_dependencyTypeToButton.put(nextDependencyType, nextButton);
                ++n2;
            }
        } else {
            this.m_dependencyTypeToButton = null;
        }
        this.layout();
    }

    public void update(FocusMode mode, boolean includeTransitive, boolean onlyInternal, Set<CoreParserDependencyType> dependencyTypes) {
        assert (mode != null) : "Parameter 'mode' of method 'updateStatusWidget' must not be null";
        this.m_focusMode.setText(mode.getPresentationName());
        this.m_transitive.setSelection(includeTransitive);
        this.m_onlyInternal.setSelection(onlyInternal);
        if (this.m_dependencyTypeToButton != null) {
            CoreParserDependencyType[] coreParserDependencyTypeArray = CoreParserDependencyType.values();
            int n = coreParserDependencyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CoreParserDependencyType dependencyType = coreParserDependencyTypeArray[n2];
                Button nextButton = this.m_dependencyTypeToButton.get(dependencyType);
                nextButton.setSelection(dependencyTypes != null && dependencyTypes.contains(dependencyType));
                ++n2;
            }
        }
        this.layout();
    }
}

