/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.IndexBasedTextSearchHandler;
import java.util.Collections;
import java.util.List;

public final class DrawableSlaveViewFigureBasedTextSearchHandler
extends IndexBasedTextSearchHandler<IDrawableNode> {
    private final DrawableWidget m_drawableWidget;

    public DrawableSlaveViewFigureBasedTextSearchHandler(DrawableWidget drawableWidget, String connectedTo) {
        super(connectedTo);
        assert (drawableWidget != null) : "Parameter 'drawableWidget' of method 'DrawableSlaveViewFigureBasedTextSearchHandler' must not be null";
        this.m_drawableWidget = drawableWidget;
    }

    @Override
    public boolean canConnect() {
        return !this.m_drawableWidget.isDisposed();
    }

    @Override
    public List<IDrawableNode> getSortedElementsForSearch() {
        return this.m_drawableWidget.getSortedElementsForSearch();
    }

    @Override
    public void selectAndRevealForFind(IDrawableNode elementToSelectAndReveal) {
        assert (elementToSelectAndReveal != null) : "Parameter 'elementToSelectAndReveal' of method 'selectAndRevealForFind' must not be null";
        this.m_drawableWidget.setRedraw(false);
        this.m_drawableWidget.selected(Collections.singletonList(elementToSelectAndReveal), false, true);
        this.m_drawableWidget.reveal(elementToSelectAndReveal);
        this.m_drawableWidget.setRedraw(true);
    }

    @Override
    protected String getTextForTextSearch(IDrawableNode elementForTextSearch) {
        assert (elementForTextSearch != null) : "Parameter 'elementForTextSearch' of method 'getTextForTextSearch' must not be null";
        return elementForTextSearch.getTextForNode();
    }

    @Override
    protected int calculatePositionForFind() {
        int selectedTopIndex = -1;
        for (RepresentationElement element : this.m_drawableWidget.getSelectedElements()) {
            if (!(element instanceof RepresentationNode)) continue;
            IDrawableNode selectedNode = this.m_drawableWidget.getNode((RepresentationNode)element);
            int selectedNodeIndex = this.getSortedElementsForSearch().indexOf(selectedNode);
            assert (selectedNodeIndex >= 0) : "'selectedNode' should be present in the ordered list of elements";
            selectedTopIndex = selectedTopIndex == -1 ? selectedNodeIndex : Math.min(selectedTopIndex, selectedNodeIndex);
        }
        if (selectedTopIndex == -1) {
            selectedTopIndex = 0;
        }
        return selectedTopIndex;
    }
}

