/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CycleGroupsViewShowInViewSupport
extends SupportsShowInView {
    CycleGroupsViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    private List<Element> getElementsForShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'convert' must not be null";
        if (!elements.isEmpty()) {
            ArrayList<Element> relevantElements = new ArrayList<Element>(elements.size());
            for (Element element : elements) {
                Object relevantElement = null;
                if (element instanceof IDiffElement) {
                    Element candidate = ((IDiffElement)element).getCurrentElement();
                    if (candidate != null) {
                        relevantElement = candidate;
                    }
                } else {
                    relevantElement = element instanceof IssueRank ? ((IssueRank)element).getRankedElement() : (element instanceof INamedElementNode ? ((INamedElementNode)element).getNamedElement() : element);
                }
                if (relevantElement instanceof Issue) {
                    Issue selectedIssue = (Issue)relevantElement;
                    relevantElement = selectedIssue.getAffectedElement();
                }
                if (relevantElement == null || !(relevantElement instanceof AnalyzerCycleGroup)) {
                    return Collections.emptyList();
                }
                relevantElements.add((Element)relevantElement);
            }
            return relevantElements;
        }
        return Collections.emptyList();
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        List<Element> elementsForShowInView = this.getElementsForShowInView(selectedElements);
        if (!elementsForShowInView.isEmpty()) {
            return new ShowInView(new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true));
        }
        return null;
    }
}

