/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.wizard;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NonLazySonargraphWizard
extends SonargraphWizard {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonLazySonargraphWizard.class);
    private final List<SonargraphWizardPage> m_pages = new ArrayList<SonargraphWizardPage>();

    public NonLazySonargraphWizard(String title) {
        super(title);
    }

    protected final void addPage(SonargraphWizardPage page) {
        assert (page != null) : "Parameter 'page' of method 'addPage' must not be null";
        this.m_pages.add(page);
        page.setWizard(this);
    }

    @Override
    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        int i = 0;
        while (i < this.m_pages.size()) {
            if (!this.m_pages.get(i).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        GridData gd = (GridData)pageContainer.getLayoutData();
        gd.minimumHeight = this.getMinimumHeight();
        gd.minimumWidth = this.getMinimumWidth();
        int i = 0;
        while (i < this.m_pages.size()) {
            IWizardPage page = (IWizardPage)this.m_pages.get(i);
            page.createControl(pageContainer);
            assert (page.getControl() != null) : "getControl() of wizard page returns null";
            ++i;
        }
    }

    @Override
    public void dispose() {
        int i = 0;
        while (i < this.m_pages.size()) {
            try {
                IWizardPage page = (IWizardPage)this.m_pages.get(i);
                if (page.getControl() != null && !page.getControl().isDisposed()) {
                    page.dispose();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception on dipose: " + ExceptionUtility.collectAll((Throwable)e));
            }
            ++i;
        }
        super.dispose();
    }

    public final SonargraphWizardPage getNextPage(IWizardPage page) {
        int index = this.m_pages.indexOf(page);
        if (index == this.m_pages.size() - 1 || index == -1) {
            return null;
        }
        SonargraphWizardPage next = this.m_pages.get(index + 1);
        if (next.skip()) {
            return this.getNextPage((IWizardPage)next);
        }
        return next;
    }

    public final SonargraphWizardPage getPage(String name) {
        int i = 0;
        while (i < this.m_pages.size()) {
            SonargraphWizardPage page = this.m_pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public final int getPageCount() {
        return this.m_pages.size();
    }

    public final SonargraphWizardPage[] getPages() {
        return this.m_pages.toArray(new SonargraphWizardPage[this.m_pages.size()]);
    }

    public final SonargraphWizardPage getPreviousPage(IWizardPage page) {
        int index = this.m_pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        SonargraphWizardPage prev = this.m_pages.get(index - 1);
        if (prev.skip()) {
            return this.getPreviousPage((IWizardPage)prev);
        }
        return prev;
    }

    public final SonargraphWizardPage getStartingPage() {
        if (this.m_pages.size() == 0) {
            return null;
        }
        return this.m_pages.get(0);
    }
}

