/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class ValidatingTextOrComboWidget
extends ValidatingWidget
implements ModifyListener {
    private final ITextValidator m_validator;
    private final IConsumer m_consumer;
    private final String m_initialInput;

    public ValidatingTextOrComboWidget(Composite parent, ITextValidator validator, IConsumer consumer, String value) {
        super(parent);
        assert (validator != null) : "Parameter 'validator' of method 'ValidatingTextWidget' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'ValidatingPathWidget' must not be null";
        this.m_validator = validator;
        this.m_consumer = consumer;
        this.m_initialInput = value;
        this.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
    }

    public abstract String getText();

    public abstract void setText(String var1);

    public abstract Control getControl();

    public void validate(boolean notifyConsumer) {
        String text = this.getText();
        ValidationResult result = this.m_validator.isValid(this.m_initialInput, text);
        this.updateDecoration(this.getControl(), result);
        if (notifyConsumer) {
            this.m_consumer.setText(this, result.isSuccess() ? text : null, result.inputModified());
        }
    }

    public void modifyText(ModifyEvent event) {
        if (super.isEnabled()) {
            this.validate(true);
        }
    }

    public void clearDecoration() {
        this.clearDecoration(this.getControl());
    }

    @FunctionalInterface
    public static interface IConsumer {
        public void setText(ValidatingTextOrComboWidget var1, String var2, boolean var3);
    }
}

