/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.treemap.LeafNodeColor;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.ColorTable;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import gnu.trove.map.hash.THashMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UiResourceManager {
    public static final RGB VERY_LIGHT_RED = new RGB(255, 150, 114);
    public static final RGB LIGHT_RED = new RGB(250, 128, 114);
    public static final RGB RED = new RGB(237, 41, 57);
    public static final RGB DARK_RED = new RGB(141, 2, 31);
    public static final RGB LIGHT_GREEN = new RGB(80, 210, 0);
    public static final RGB GREEN = new RGB(80, 170, 0);
    public static final RGB DARK_GREEN = new RGB(80, 130, 0);
    public static final RGB VERY_LIGHT_BLUE = new RGB(216, 228, 248);
    public static final RGB LIGHT_BLUE = new RGB(63, 95, 191);
    public static final RGB BLUE = new RGB(0, 0, 128);
    public static final RGB LIGHT_YELLOW = new RGB(255, 255, 153);
    public static final RGB YELLOW = new RGB(254, 220, 86);
    public static final RGB DARK_YELLOW = new RGB(255, 195, 11);
    public static final RGB DARK_ORANGE = new RGB(255, 95, 0);
    public static final RGB ORANGE = new RGB(255, 155, 0);
    public static final RGB LIGHT_ORANGE = new RGB(255, 215, 0);
    public static final RGB VERY_VERY_LIGHT_GREY = new RGB(230, 230, 230);
    public static final RGB VERY_LIGHT_GREY = new RGB(200, 200, 200);
    public static final RGB LIGHT_GREY = new RGB(164, 164, 164);
    public static final RGB GREY = new RGB(128, 128, 128);
    public static final RGB DARK_GREY = new RGB(108, 108, 108);
    public static final RGB VERY_DARK_GREY = new RGB(50, 50, 50);
    public static final RGB LIGHT_BROWN = new RGB(222, 184, 135);
    public static final RGB PURPLE = new RGB(127, 0, 85);
    public static final RGB LIGHTER_PAPAYA_WHIP = new RGB(255, 219, 193);
    public static final RGB PAPAYA_WHIP = new RGB(255, 199, 173);
    public static final RGB WHITE = new RGB(255, 255, 255);
    public static final RGB BLACK = new RGB(0, 0, 0);
    private static final Logger LOGGER = LoggerFactory.getLogger(UiResourceManager.class);
    private static final String UNKNOWN = "Unknown";
    private static final String WINDOWS_SOURCE_MONOSPACE_FONT = "Lucida Console";
    private static final String MAC_SOURCE_MONOSPACE_FONT = "Menlo";
    private static final String LINUX_SOURCE_MONOSPACE_FONT = "Andale Mono";
    private static UiResourceManager s_instance;
    private final List<ResourceProviderAdapter> m_adapters = new ArrayList<ResourceProviderAdapter>();
    private final Map<CursorId, Cursor> m_idToCursor = new THashMap();
    private final Map<RGB, Color> m_rgbToColor = new THashMap();
    private final Map<FontId, Font> m_idToFont = new THashMap();
    private final Map<String, Image> m_nameToImage = new THashMap();
    private final Map<String, ImageDescriptor> m_nameToImageDescriptor = new THashMap();
    private final Map<CompositeImageDescriptor, Image> m_compositeImageDescriptorToImage = new THashMap();
    private final Map<CompositeImageDescriptor, DecoratingImageDescriptor> m_compositeImageDescriptorToImageDescriptor = new THashMap();
    private final Color[] m_treeNestingColors = new Color[10];
    private final RGB[] m_treeMapNestingColors = new RGB[10];
    private final Color[] m_contentColors = new Color[10];
    private final Color[] m_cyclicColors = new Color[4];
    private final Display m_display;
    private final Clipboard m_clipboard;
    private final boolean m_inDarkMode;
    private final FontId m_systemFont;
    private final Color m_backgroundColor;
    private final Color m_foregoundColor;
    private final Color m_comment;
    private final Color m_keyword;
    private final Color m_literal;
    private final Color m_hash;
    private final Color m_at;
    private final Color m_annotation;
    private final Color m_annotationInComment;

    private UiResourceManager(Display display) {
        FontData[] defaultFontData;
        assert (display != null) : "Parameter 'display' of method 'UiResourceManager' must not be null";
        this.m_display = display;
        this.m_clipboard = new Clipboard(display);
        boolean bl = this.m_inDarkMode = Platform.isLinux() && Display.isSystemDarkTheme();
        if (this.m_inDarkMode) {
            Shell shell = new Shell();
            Tree tree = new Tree((Composite)shell, 0);
            this.m_backgroundColor = tree.getBackground();
            this.m_foregoundColor = tree.getForeground();
            tree.dispose();
            shell.dispose();
            this.m_keyword = this.getColor(LIGHT_BROWN);
            this.m_comment = this.getColor(GREEN);
            this.m_literal = this.getColor(YELLOW);
            this.m_hash = this.getColor(GREY);
            this.m_at = this.getColor(GREY);
            this.m_annotation = this.getColor(GREY);
            this.m_annotationInComment = this.getColor(GREY);
            int i = 0;
            double value = 0.22;
            do {
                this.m_treeNestingColors[i] = this.getColor(new RGB(0.0f, 0.0f, (float)value));
                value += 0.04;
            } while (++i < this.m_treeNestingColors.length);
            i = 0;
            value = 0.22;
            do {
                this.m_treeMapNestingColors[i] = new RGB(0.0f, 0.0f, (float)value);
                value += 0.06;
            } while (++i < this.m_treeMapNestingColors.length);
            i = 0;
            int redDelta = 20;
            int greenDelta = 10;
            RGB current = new RGB(215, 235, 255);
            i = 0;
            while (i < this.m_contentColors.length) {
                current = new RGB(current.red - 20, current.green - 10, current.blue);
                this.m_contentColors[i] = this.getColor(current);
                ++i;
            }
        } else {
            this.m_backgroundColor = this.getColor(new RGB(255, 255, 255));
            this.m_foregoundColor = this.getColor(new RGB(0, 0, 0));
            this.m_keyword = this.getColor(PURPLE);
            this.m_comment = this.getColor(DARK_GREEN);
            this.m_literal = this.getColor(LIGHT_BLUE);
            this.m_hash = this.getColor(GREY);
            this.m_at = this.getColor(GREY);
            this.m_annotation = this.getColor(GREY);
            this.m_annotationInComment = this.getColor(GREY);
            int i = 0;
            int redDelta = 18;
            int greenDelta = 9;
            RGB current = new RGB(250, 250, 255);
            i = 0;
            while (i < this.m_treeNestingColors.length) {
                current = new RGB(current.red - 18, current.green - 9, current.blue);
                this.m_treeNestingColors[i] = this.getColor(current);
                ++i;
            }
            i = 0;
            double value = 0.78;
            do {
                this.m_treeMapNestingColors[i] = new RGB(0.0f, 0.0f, (float)value);
                value -= 0.06;
            } while (++i < this.m_treeMapNestingColors.length);
            i = 0;
            value = 0.92;
            do {
                this.m_contentColors[i] = this.getColor(new RGB(0.0f, 0.0f, (float)value));
                value -= 0.05;
            } while (++i < this.m_contentColors.length);
        }
        this.m_cyclicColors[0] = this.getColor(new RGB(255, 42, 0));
        this.m_cyclicColors[1] = this.getColor(new RGB(204, 0, 34));
        this.m_cyclicColors[2] = this.getColor(new RGB(255, 77, 77));
        this.m_cyclicColors[3] = this.getColor(new RGB(255, 25, 102));
        FontId systemFont = null;
        FontData[] fontDataArray = defaultFontData = this.m_display.getSystemFont().getFontData();
        if (defaultFontData.length != 0) {
            FontData nextDefaultFontData = fontDataArray[0];
            systemFont = new FontId(nextDefaultFontData.getName(), nextDefaultFontData.getHeight(), nextDefaultFontData.getStyle());
        }
        assert (systemFont != null) : "System font not detected";
        this.m_systemFont = systemFont;
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static void createInstance(Display display) {
        assert (!UiResourceManager.hasInstance()) : "Instance already created";
        s_instance = new UiResourceManager(display);
    }

    public static UiResourceManager getInstance() {
        assert (UiResourceManager.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public boolean inDarkMode() {
        return this.m_inDarkMode;
    }

    public Clipboard getClipboard() {
        return this.m_clipboard;
    }

    public boolean clipboardHasText() {
        if (!this.m_clipboard.isDisposed()) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            String textData = (String)this.m_clipboard.getContents((Transfer)textTransfer);
            return textData != null && !textData.isEmpty();
        }
        return false;
    }

    private static void disposeResource(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static void delete() {
        if (s_instance != null) {
            UiResourceManager.s_instance.m_idToCursor.values().forEach(r -> UiResourceManager.disposeResource((Resource)r));
            UiResourceManager.s_instance.m_idToCursor.clear();
            UiResourceManager.s_instance.m_rgbToColor.values().forEach(r -> UiResourceManager.disposeResource((Resource)r));
            UiResourceManager.s_instance.m_rgbToColor.clear();
            UiResourceManager.s_instance.m_idToFont.values().forEach(r -> UiResourceManager.disposeResource((Resource)r));
            UiResourceManager.s_instance.m_idToFont.clear();
            UiResourceManager.s_instance.m_nameToImage.values().forEach(r -> UiResourceManager.disposeResource((Resource)r));
            UiResourceManager.s_instance.m_nameToImage.clear();
            UiResourceManager.s_instance.m_nameToImageDescriptor.clear();
            UiResourceManager.s_instance.m_compositeImageDescriptorToImage.values().forEach(r -> UiResourceManager.disposeResource((Resource)r));
            UiResourceManager.s_instance.m_compositeImageDescriptorToImage.clear();
            UiResourceManager.s_instance.m_compositeImageDescriptorToImageDescriptor.clear();
            if (!UiResourceManager.s_instance.m_clipboard.isDisposed()) {
                UiResourceManager.s_instance.m_clipboard.dispose();
            }
            s_instance = null;
        }
    }

    public void addResourceProviderAdapter(ResourceProviderAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'addResourceProviderAdapter' must not be null";
        assert (!this.m_adapters.contains(adapter)) : "Already added adapter: " + String.valueOf(adapter);
        this.m_adapters.add(adapter);
    }

    public ColorTable createColorTable() {
        return new ColorTable(this.m_display);
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public Color getForegroundColor() {
        return this.m_foregoundColor;
    }

    public Color getDimmedForegroundColor() {
        return this.m_inDarkMode ? this.getColor(LIGHT_GREY) : this.getColor(DARK_GREY);
    }

    public Color getSeparatorColor() {
        if (this.m_inDarkMode) {
            return Platform.isWindows() ? this.m_display.getSystemColor(19) : this.getColor(VERY_LIGHT_GREY);
        }
        return Platform.isWindows() ? this.m_display.getSystemColor(19) : this.getColor(VERY_LIGHT_GREY);
    }

    public Color getViewHasFilteredElementsColor() {
        return this.m_inDarkMode ? this.getColor(DARK_GREY) : this.getColor(LIGHT_YELLOW);
    }

    public Color getTextHighlightPrimaryColor() {
        return this.m_inDarkMode ? this.getColor(DARK_GREY) : this.getColor(VERY_VERY_LIGHT_GREY);
    }

    public Color getTextHighlightSecondaryColor() {
        return this.m_inDarkMode ? this.getColor(GREY) : this.getColor(VERY_LIGHT_GREY);
    }

    public Color getGraphNodeTextColor() {
        return this.m_inDarkMode ? this.getBackgroundColor() : this.getForegroundColor();
    }

    public Color getHeaderColor() {
        return this.m_inDarkMode ? this.getColor(LIGHT_GREY) : this.getColor(VERY_LIGHT_BLUE);
    }

    public Color getDisabledColor() {
        return this.getColor(DARK_GREY);
    }

    public Color getNoneViolatingConnectionColor() {
        return this.getColor(GREEN);
    }

    public Color getMixedConnectionColor() {
        return this.getColor(YELLOW);
    }

    public Color getSelectionColor() {
        return this.m_inDarkMode ? this.getColor(DARK_ORANGE) : this.getColor(YELLOW);
    }

    public Color getHighlightColor() {
        return this.m_inDarkMode ? this.getColor(DARK_GREEN) : this.getColor(GREEN);
    }

    public Color getNodeHighlightPrimaryColor() {
        return this.m_inDarkMode ? this.getColor(DARK_ORANGE) : this.getColor(VERY_LIGHT_GREY);
    }

    public Color getNodeHighlightSecondaryColor() {
        return this.m_inDarkMode ? this.getColor(ORANGE) : this.getColor(VERY_VERY_LIGHT_GREY);
    }

    public Color getViolatingConnectionColor() {
        return this.getColor(RED);
    }

    public Color getDeprecatedConnectionColor() {
        return this.getColor(LIGHT_BLUE);
    }

    public Color getCommentColor() {
        return this.m_comment;
    }

    public Color getKeywordColor() {
        return this.m_keyword;
    }

    public Color getAtColor() {
        return this.m_at;
    }

    public Color getHashColor() {
        return this.m_hash;
    }

    public Color getLiteralColor() {
        return this.m_literal;
    }

    public Color getAnnotationColor() {
        return this.m_annotation;
    }

    public Color getAnnotationInCommentColor() {
        return this.m_annotationInComment;
    }

    private Color getColor(int index, Color[] colors) {
        int colorIndex;
        assert (index >= 0) : "Parameter 'depth' of method 'getColor' must not be negative";
        assert (colors != null && colors.length > 0) : "Parameter 'colors' of method 'getColor' must not be empty";
        int length = colors.length;
        if (index < length) {
            colorIndex = index;
        } else {
            int section = index / (length - 1);
            if (section % 2 == 0) {
                int t;
                colorIndex = t = index % (length - 1);
            } else {
                int t = index % (length - 1);
                colorIndex = -1 * t + (length - 1);
            }
        }
        return colors[colorIndex];
    }

    public Color getTreeNestingColor(int depth) {
        assert (depth >= 0) : "Parameter 'depth' of method 'getTreeNestingColor' must not be negative";
        return this.getColor(depth, this.m_treeNestingColors);
    }

    public RGB getTreeMapNodeSelectionRGB() {
        return this.m_inDarkMode ? BLUE : LIGHT_BLUE;
    }

    public RGB getTreeMapNodeGreyedRGB() {
        return this.m_inDarkMode ? DARK_GREY : LIGHT_GREY;
    }

    public RGB getTreeMapNestingRGB(int level) {
        int rgbIndex;
        assert (level >= 0) : "Parameter 'level' of method 'getTreeNestingColor' must not be negative";
        int length = this.m_treeMapNestingColors.length;
        if (level < length) {
            rgbIndex = level;
        } else {
            int section = level / (length - 1);
            if (section % 2 == 0) {
                int t;
                rgbIndex = t = level % (length - 1);
            } else {
                int t = level % (length - 1);
                rgbIndex = -1 * t + (length - 1);
            }
        }
        return this.m_treeMapNestingColors[rgbIndex];
    }

    public RGB getTreeMapLeafRGB(LeafNodeColor color) {
        assert (color != null) : "Parameter 'color' of method 'getTreeMapLeafColor' must not be null";
        switch (color) {
            case LIGHT_GREEN: {
                return LIGHT_GREEN;
            }
            case GREEN: {
                return GREEN;
            }
            case DARK_GREEN: {
                return DARK_GREEN;
            }
            case LIGHT_YELLOW: {
                return LIGHT_YELLOW;
            }
            case YELLOW: {
                return YELLOW;
            }
            case DARK_YELLOW: {
                return DARK_YELLOW;
            }
            case LIGHT_RED: {
                return LIGHT_RED;
            }
            case RED: {
                return RED;
            }
            case DARK_RED: {
                return DARK_RED;
            }
        }
        assert (false) : "Unhandled leaf color: " + String.valueOf(color);
        return BLACK;
    }

    public Color getTreeMapLeafColor(LeafNodeColor color) {
        assert (color != null) : "Parameter 'color' of method 'getTreeMapLeafColor' must not be null";
        return this.getColor(this.getTreeMapLeafRGB(color));
    }

    public Color getForegroundForTreeMapLeafColor(LeafNodeColor color) {
        assert (color != null) : "Parameter 'color' of method 'getForegroundForTreeMapLeafColor' must not be null";
        switch (color) {
            case LIGHT_GREEN: 
            case GREEN: 
            case LIGHT_YELLOW: 
            case YELLOW: 
            case DARK_YELLOW: 
            case LIGHT_RED: 
            case RED: {
                return this.getColor(BLACK);
            }
            case DARK_GREEN: 
            case DARK_RED: {
                return this.getColor(WHITE);
            }
        }
        assert (false) : "Unhandled leaf color: " + String.valueOf(color);
        return this.getColor(BLACK);
    }

    public Color getCyclicColor(int cycleIndex) {
        assert (cycleIndex >= 0) : "Parameter 'cycleIndex' of method 'getCyclicColor' must not be negative";
        return cycleIndex < this.m_cyclicColors.length ? this.m_cyclicColors[cycleIndex] : this.m_cyclicColors[cycleIndex % this.m_cyclicColors.length];
    }

    public int getContentSteps() {
        return this.m_contentColors.length;
    }

    public Color getContentColor(int step) {
        assert (step >= 0 && step < this.m_contentColors.length) : "Invalid 'step': " + step;
        return this.m_contentColors[step];
    }

    public Color getLevelSeparatorColor() {
        return this.m_inDarkMode ? this.getColor(PURPLE) : this.getColor(DARK_GREY);
    }

    public Color getColor(RGB rgb) {
        assert (rgb != null) : "'rgb' must not be null";
        Color color = this.m_rgbToColor.get(rgb);
        if (color == null) {
            color = new Color((Device)this.m_display, rgb);
            this.m_rgbToColor.put(rgb, color);
        }
        return color;
    }

    public Font getFont(FontId id) {
        assert (id != null) : "'id' must not be null";
        if (this.m_systemFont.equals(id)) {
            return this.m_display.getSystemFont();
        }
        Font font = this.m_idToFont.get(id);
        if (font == null) {
            font = new Font((Device)this.m_display, id.getName(), id.getHeight(), id.getStyle());
            this.m_idToFont.put(id, font);
        }
        return font;
    }

    public Font getFont(int style) {
        FontId fontId = new FontId(this.m_systemFont, style);
        return this.getFont(fontId);
    }

    public Font getFontWithHeightDelta(int delta, int style) {
        FontId fontId = new FontId(this.m_systemFont.getName(), this.m_systemFont.getHeight() + delta, style);
        return this.getFont(fontId);
    }

    public Font getDefaultSourceFont(int fontHeight) {
        if (Platform.isWindows()) {
            return this.getFont(new FontId(WINDOWS_SOURCE_MONOSPACE_FONT, fontHeight, 0));
        }
        if (Platform.isMac()) {
            return this.getFont(new FontId(MAC_SOURCE_MONOSPACE_FONT, fontHeight, 0));
        }
        assert (Platform.isLinux()) : "Unexpected platform: " + String.valueOf(Platform.getOperatingSystem());
        return this.getFont(new FontId(LINUX_SOURCE_MONOSPACE_FONT, fontHeight, 0));
    }

    public Font getDefaultMonospaceFont(boolean bold) {
        int height = this.getDefaultSystemFontHeight();
        if (Platform.isWindows()) {
            return this.getFont(new FontId(WINDOWS_SOURCE_MONOSPACE_FONT, height, bold ? 1 : 0));
        }
        if (Platform.isMac()) {
            return this.getFont(new FontId(MAC_SOURCE_MONOSPACE_FONT, height, bold ? 1 : 0));
        }
        assert (Platform.isLinux()) : "Unexpected platform: " + String.valueOf(Platform.getOperatingSystem());
        return this.getFont(new FontId(LINUX_SOURCE_MONOSPACE_FONT, height, bold ? 1 : 0));
    }

    public int getDefaultSystemFontHeight() {
        Font systemFont = this.getFont(0);
        assert (systemFont.getFontData().length > 0) : " font data expected";
        return systemFont.getFontData()[0].getHeight();
    }

    public Cursor getCursor(int style) {
        return this.m_display.getSystemCursor(style);
    }

    public Cursor getCursor(CursorId cursorId) {
        assert (cursorId != null) : "Parameter 'cursorId' of method 'getCursor' must not be null";
        Cursor cursor = this.m_idToCursor.get((Object)cursorId);
        if (cursor == null) {
            Image image = this.getImage(cursorId.getImageResourceName());
            cursor = new Cursor((Device)this.m_display, image.getImageData(), image.getBounds().width / 2, image.getBounds().height / 2);
            this.m_idToCursor.put(cursorId, cursor);
        }
        return cursor;
    }

    private URL getImageResourceUrl(String resourceName) {
        assert (resourceName != null) : "'resourceName' must not be null";
        assert (resourceName.length() > 0) : "'resourceName' must not be empty";
        for (ResourceProviderAdapter nextAdapter : this.m_adapters) {
            URL url = nextAdapter.getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE, resourceName);
            if (url != null) {
                return url;
            }
            url = nextAdapter.getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.PNG, resourceName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(String resourceName) {
        assert (resourceName != null) : "'resourceName' must not be null";
        assert (resourceName.length() > 0) : "'resourceName' must not be empty";
        ImageDescriptor imageDescriptor = this.m_nameToImageDescriptor.get(resourceName);
        if (imageDescriptor == null) {
            URL url = this.getImageResourceUrl(resourceName);
            if (url != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (imageDescriptor == null) {
                LOGGER.warn("Image resource not found: " + resourceName);
            }
            this.m_nameToImageDescriptor.put(resourceName, imageDescriptor);
        }
        return imageDescriptor;
    }

    private ImageDescriptor createImageDescriptor(String resourceName) {
        URL url = this.getImageResourceUrl(resourceName);
        if (url == null) {
            LOGGER.warn("Resource not found: " + resourceName);
            return null;
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        if (imageDescriptor == null) {
            LOGGER.warn("Unable to create image descriptor for: " + resourceName);
            return null;
        }
        return imageDescriptor;
    }

    private ImageDescriptor getImageDescriptor(CompositeImageDescriptor compositeImageDescriptor) {
        assert (compositeImageDescriptor != null) : "'compositeImageDescriptor' must not be null";
        DecoratingImageDescriptor markedImageDescriptor = this.m_compositeImageDescriptorToImageDescriptor.get(compositeImageDescriptor);
        if (markedImageDescriptor == null) {
            URL url = this.getImageResourceUrl(compositeImageDescriptor.getResourceName());
            if (url != null) {
                ImageDescriptor nextImageDescriptor;
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                markedImageDescriptor = new DecoratingImageDescriptor(imageDescriptor);
                boolean success = true;
                String nextResourceName = compositeImageDescriptor.getResourceNameBackground();
                if (nextResourceName != null) {
                    nextImageDescriptor = this.createImageDescriptor(nextResourceName);
                    if (nextImageDescriptor != null) {
                        markedImageDescriptor.setBackground(nextImageDescriptor);
                    } else {
                        success = false;
                    }
                }
                nextResourceName = compositeImageDescriptor.getResourceName(DecoratingImageDescriptor.Corner.UPPER_LEFT);
                if (success && nextResourceName != null) {
                    nextImageDescriptor = this.createImageDescriptor(nextResourceName);
                    if (nextImageDescriptor != null) {
                        markedImageDescriptor.addMarker(nextImageDescriptor, DecoratingImageDescriptor.Corner.UPPER_LEFT);
                    } else {
                        success = false;
                    }
                }
                nextResourceName = compositeImageDescriptor.getResourceName(DecoratingImageDescriptor.Corner.UPPER_RIGHT);
                if (success && nextResourceName != null) {
                    nextImageDescriptor = this.createImageDescriptor(nextResourceName);
                    if (nextImageDescriptor != null) {
                        markedImageDescriptor.addMarker(nextImageDescriptor, DecoratingImageDescriptor.Corner.UPPER_RIGHT);
                    } else {
                        success = false;
                    }
                }
                nextResourceName = compositeImageDescriptor.getResourceName(DecoratingImageDescriptor.Corner.LOWER_RIGHT);
                if (success && nextResourceName != null) {
                    nextImageDescriptor = this.createImageDescriptor(nextResourceName);
                    if (nextImageDescriptor != null) {
                        markedImageDescriptor.addMarker(nextImageDescriptor, DecoratingImageDescriptor.Corner.LOWER_RIGHT);
                    } else {
                        success = false;
                    }
                }
                nextResourceName = compositeImageDescriptor.getResourceName(DecoratingImageDescriptor.Corner.LOWER_LEFT);
                if (success && nextResourceName != null) {
                    nextImageDescriptor = this.createImageDescriptor(nextResourceName);
                    if (nextImageDescriptor != null) {
                        markedImageDescriptor.addMarker(nextImageDescriptor, DecoratingImageDescriptor.Corner.LOWER_LEFT);
                    } else {
                        success = false;
                    }
                }
                if (!success) {
                    markedImageDescriptor = null;
                }
            }
            if (markedImageDescriptor == null) {
                LOGGER.warn("Unable to create marked image resource for: " + String.valueOf(compositeImageDescriptor));
            }
            this.m_compositeImageDescriptorToImageDescriptor.put(compositeImageDescriptor, markedImageDescriptor);
        }
        return markedImageDescriptor;
    }

    public Image getImage(CompositeImageDescriptor compositeImageDescriptor) {
        assert (compositeImageDescriptor != null) : "'compositeImageDescriptor' must not be null";
        Image image = this.m_compositeImageDescriptorToImage.get(compositeImageDescriptor);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.getImageDescriptor(compositeImageDescriptor);
            if (imageDescriptor != null) {
                image = imageDescriptor.createImage();
            }
            if (image != null) {
                this.m_compositeImageDescriptorToImage.put(compositeImageDescriptor, image);
            }
        }
        return image;
    }

    public Image getImage(String resourceName, ImageDecoratorInfo decoratorInfo) {
        assert (resourceName != null && resourceName.length() > 0) : "Parameter 'resourceName' of method 'getImage' must not be empty";
        Image image = null;
        if (decoratorInfo != null) {
            CompositeImageDescriptor descriptor = new CompositeImageDescriptor(resourceName);
            String upperRight = decoratorInfo.getOne();
            String lowerRight = decoratorInfo.getTwo();
            String lowerLeft = decoratorInfo.getThree();
            String upperLeft = decoratorInfo.getFour();
            String resourceNameBackground = decoratorInfo.getResourceNameBackground();
            if (upperRight != null) {
                descriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, upperRight);
            }
            if (lowerRight != null) {
                descriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_RIGHT, lowerRight);
            }
            if (lowerLeft != null) {
                descriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_LEFT, lowerLeft);
            }
            if (upperLeft != null) {
                descriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_LEFT, upperLeft);
            }
            if (resourceNameBackground != null) {
                descriptor.setResourceNameBackground(resourceNameBackground);
            }
            image = this.getImage(descriptor);
        } else {
            image = this.getImage(resourceName);
        }
        if (image == null) {
            if (decoratorInfo != null) {
                LOGGER.warn("Unable to create composite image for: " + resourceName + " - " + String.valueOf(decoratorInfo));
            } else {
                LOGGER.warn("Unable to create image for: " + resourceName);
            }
            image = this.getImage(UNKNOWN);
        }
        return image;
    }

    public Image getImage(Element element, boolean addDecorators) {
        assert (element != null) : "Parameter 'element' of method 'getImage' must not be null";
        Image image = null;
        String resourceName = element.getImageResourceName();
        if (resourceName == null || resourceName.isEmpty()) {
            LOGGER.warn("No image resource name provided for: " + String.valueOf(element));
            resourceName = UNKNOWN;
        }
        image = this.getImage(resourceName, addDecorators ? element.getImageResourceDecoratorInfo() : null);
        assert (image != null) : "'image' of method 'getImage' must not be null";
        return image;
    }

    public Image getImage(Element element) {
        return this.getImage(element, true);
    }

    public Image getImage(String resourceName) {
        ImageDescriptor imageDescriptor;
        assert (resourceName != null) : "'resourceName' must not be null";
        assert (resourceName.length() > 0) : "'resourceName' must not be empty";
        Image image = this.m_nameToImage.get(resourceName);
        if (image == null && (imageDescriptor = this.getImageDescriptor(resourceName)) != null) {
            image = imageDescriptor.createImage();
            if (image != null) {
                this.m_nameToImage.put(resourceName, image);
            } else {
                LOGGER.warn("Unable to create image for image descriptor: " + resourceName);
            }
        }
        if (image == null && !resourceName.equals(UNKNOWN)) {
            image = this.getImage(UNKNOWN);
        }
        return image;
    }

    public static final class CursorId
    extends Enum<CursorId> {
        public static final /* enum */ CursorId OPEN_HAND = new CursorId("OpenHand");
        public static final /* enum */ CursorId ROTATE = new CursorId("Rotate");
        private final String m_imageResourceName;
        private static final /* synthetic */ CursorId[] ENUM$VALUES;

        static {
            ENUM$VALUES = new CursorId[]{OPEN_HAND, ROTATE};
        }

        private CursorId(String imageResourceName) {
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'CursorId' must not be empty";
            this.m_imageResourceName = imageResourceName;
        }

        String getImageResourceName() {
            return this.m_imageResourceName;
        }

        public static CursorId[] values() {
            CursorId[] cursorIdArray = ENUM$VALUES;
            int n = cursorIdArray.length;
            CursorId[] cursorIdArray2 = new CursorId[n];
            System.arraycopy(ENUM$VALUES, 0, cursorIdArray2, 0, n);
            return cursorIdArray2;
        }

        public static CursorId valueOf(String string) {
            return Enum.valueOf(CursorId.class, string);
        }
    }

    public static final class FontId {
        private final String m_name;
        private final int m_height;
        private final int m_style;

        public FontId(FontId fontId, int style) {
            assert (fontId != null) : "Parameter 'fontId' of method 'FontId' must not be null";
            this.m_name = fontId.m_name;
            this.m_height = fontId.m_height;
            this.m_style = style;
        }

        public FontId(FontId fontId, int heigth, int style) {
            assert (fontId != null) : "Parameter 'fontId' of method 'FontId' must not be null";
            this.m_name = fontId.m_name;
            this.m_height = heigth;
            this.m_style = style;
        }

        public FontId(String name, int heigth, int style) {
            assert (name != null) : "'name' must not be null";
            this.m_name = name;
            this.m_height = heigth;
            this.m_style = style;
        }

        public String getName() {
            return this.m_name;
        }

        public int getHeight() {
            return this.m_height;
        }

        public int getStyle() {
            return this.m_style;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_name.hashCode();
            result = 31 * result + this.m_height;
            result = 31 * result + this.m_style;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FontId other = (FontId)obj;
            return this.getName().equals(other.getName()) && this.getHeight() == other.getHeight() && this.getStyle() == other.getStyle();
        }
    }
}

