/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public final class SwtUtility {
    public static final int DEFAULT_TEXT_FIELD_STYLE = 2048;
    public static final Point DEFAULT_MINIMUM_DIALOG_SIZE = new Point(300, 100);
    public static final Point DEFAULT_MAXIMUM_DIALOG_SIZE = new Point(900, 800);
    private static final int BUTTON_WIDTH = 90;
    private static final int BUTTON_HEIGHT = 25;
    private static final int TOOLTIP_MAX_CHAR_PER_LINE = 60;

    private SwtUtility() {
    }

    public static void consumeUiEvents(Display display) {
        while (!display.isDisposed()) {
            if (!display.readAndDispatch()) break;
        }
    }

    public static void consumeUiEvents(Control control) {
        if (control != null && !control.isDisposed()) {
            SwtUtility.consumeUiEvents(control.getDisplay());
        }
    }

    public static Point calculateSize(Shell shell, Point minSize, Point maxSize, Point preferredSize) {
        assert (shell != null) : "Parameter 'shell' of method 'calculateSize' must not be null";
        assert (minSize != null) : "Parameter 'minSize' of method 'calculateSize' must not be null";
        assert (maxSize != null) : "Parameter 'maxSize' of method 'calculateSize' must not be null";
        if (preferredSize != null) {
            return preferredSize;
        }
        shell.pack(true);
        int width = Math.max(minSize.x, shell.getBounds().width);
        int height = Math.max(minSize.y, shell.getBounds().height);
        width = Math.min(width, maxSize.x);
        height = Math.min(height, maxSize.y);
        return new Point(width, height);
    }

    public static boolean selectElementOfCombo(Combo combo, String elementToSelect) {
        assert (combo != null) : "Parameter 'combo' of method 'selectElementOfCombo' must not be null";
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getItem(i).equals(elementToSelect)) {
                combo.select(i);
                combo.setText(elementToSelect);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static GridLayout createSingleRootWidgetGridLayoutWithoutMargin() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    public static GridLayout createMultipleRootWidgetGridLayoutWithoutMargin(int colummns) {
        GridLayout gridLayout = new GridLayout(colummns, false);
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    public static GridLayout createMultipleRootWidgetGridLayoutWithMargin(int columns, boolean equalWidth) {
        GridLayout gridLayout = new GridLayout(columns, equalWidth);
        gridLayout.marginHeight = 4;
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginWidth = 4;
        return gridLayout;
    }

    public static GridLayout createMultipleRootWidgetGridLayout(int columns, boolean equalWidth) {
        GridLayout gridLayout = new GridLayout(columns, equalWidth);
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    public static GridLayout createSingleRootWidgetGridLayoutWithMargin() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 4;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginWidth = 4;
        return gridLayout;
    }

    public static GridLayout createMultipleRootWidgetGridLayoutWithMargin(int colummns) {
        return SwtUtility.createMultipleRootWidgetGridLayoutWithMargin(colummns, false);
    }

    public static GridLayout createMultipleRootWidgetGridLayout(int columns) {
        return SwtUtility.createMultipleRootWidgetGridLayout(columns, false);
    }

    public static CTabFolder createTabFolder(Composite parent) {
        assert (parent != null) : "'parent' must not be null";
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setSimple(true);
        tabFolder.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        return tabFolder;
    }

    public static Button createButtonForGridLayoutStandardSize(Composite composite, String text) {
        assert (composite != null) : "Parameter 'composite' of method 'createButton' must not be null";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'createButton' must not be empty";
        return SwtUtility.createButtonForGridLayoutStandardSize(composite, text, 1);
    }

    public static Button createButtonForGridLayoutStandardSize(Composite composite, String text, int horizontalAlignment) {
        assert (composite != null) : "Parameter 'composite' of method 'createButton' must not be null";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'createButton' must not be empty";
        Button button = new Button(composite, 8);
        button.setText(text);
        GridData gridData = new GridData(90, 25);
        gridData.horizontalAlignment = horizontalAlignment;
        gridData.verticalAlignment = 1;
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static Label createFillerForGridLayoutCell(Composite container) {
        return SwtUtility.createFillerForGridLayoutCell(container, 1, 1);
    }

    public static Label createFillerForGridLayoutCell(Composite container, int horizontalSpan, int verticalSpan) {
        assert (horizontalSpan > 0) : "Parameter 'horizontalSpan' of method 'placeFiller' must be > 0";
        assert (verticalSpan > 0) : "Parameter 'verticalSpan' of method 'placeFiller' must be > 0";
        Label filler = new Label(container, 0);
        filler.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, horizontalSpan, verticalSpan));
        filler.setText("");
        filler.setVisible(false);
        return filler;
    }

    public static Control placeHorizontalSeparator(Composite container, int columns) {
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 2, true, false, columns, 1));
        return separator;
    }

    public static Label createOneCellLabel(Composite container, String text, int hAlignment) {
        return SwtUtility.createOneCellLabelAligned(container, text, hAlignment, 0x1000000);
    }

    public static Label createOneCellLabelAligned(Composite container, String text, int hAlignment, int vAlignment) {
        Label label = new Label(container, hAlignment);
        label.setLayoutData((Object)new GridData(hAlignment, vAlignment, false, false, 1, 1));
        label.setText(text);
        return label;
    }

    public static Label createLabelWrapping(Composite container, String text, int colSpan, int widthHint) {
        Label label = new Label(container, 64);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        if (widthHint > 0) {
            gridData.widthHint = widthHint;
        }
        gridData.horizontalSpan = colSpan;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        container.pack(true);
        return label;
    }

    public static Text createTextFieldInGroup(Composite container, String groupLabel, int widthHint, int heightHint, int verticalSpan) {
        return SwtUtility.createTextFieldInGroup(container, groupLabel, widthHint, heightHint, 1, verticalSpan);
    }

    public static Text createTextFieldInGroup(Composite container, String groupLabel, int widthHint, int heightHint, int horizontalSpan, int verticalSpan) {
        Group group = new Group(container, 0);
        group.setText(groupLabel);
        group.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = verticalSpan;
        gridData.horizontalSpan = horizontalSpan;
        group.setLayoutData((Object)gridData);
        return SwtUtility.createTextFieldForGridLayout((Composite)group, widthHint, heightHint, 1, 1, true);
    }

    public static Text createTextFieldForGridLayout(Composite container, int widthHint, int heightHint, int horizontalSpan, int verticalSpan, boolean isMultiLine) {
        int style = 2048;
        if (isMultiLine) {
            style = style | 2 | 0x100 | 0x200;
        }
        Text text = new Text(container, style);
        GridData gridData = null;
        gridData = isMultiLine ? new GridData(4, 4, true, true) : new GridData(768);
        if (widthHint > 0) {
            gridData.widthHint = widthHint;
        }
        if (heightHint > 0) {
            gridData.heightHint = heightHint;
        }
        gridData.verticalSpan = verticalSpan;
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Text createTextFieldForGridLayout(Composite container, boolean isMultiLine, int swtFlags) {
        int style = 0x800 | swtFlags;
        if (isMultiLine) {
            style = style | 2 | 0x100 | 0x200;
        }
        Text text = SwtUtility.createTextField(container, style);
        if (isMultiLine) {
            text.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            text.setLayoutData((Object)new GridData(768));
        }
        return text;
    }

    public static Text createTextField(Composite parent, int ... style) {
        assert (parent != null) : "Parameter 'parent' of method 'createTextField' must not be null";
        int swtStyle = 2048;
        if (style != null) {
            int[] nArray = style;
            int n = style.length;
            int n2 = 0;
            while (n2 < n) {
                int styleValue = nArray[n2];
                swtStyle |= styleValue;
                ++n2;
            }
        }
        Text textField = new Text(parent, swtStyle);
        textField.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        return textField;
    }

    public static void packAllColumnsAndRightAlignLast(TableViewer tableViewer) {
        assert (tableViewer != null) : "Parameter 'tableViewer' of method 'packAndFillLastColumn' must not be null";
        final Table table = tableViewer.getTable();
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                table.removeControlListener((ControlListener)this);
                TableColumn[] tableColumns = table.getColumns();
                if (tableColumns.length > 1) {
                    TableColumn lastButOneTableColumn;
                    int widthToBeSet;
                    ScrollBar vScrollBar;
                    int columnsWidth = 0;
                    TableColumn[] tableColumnArray = tableColumns;
                    int n = tableColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn nextTableColumn = tableColumnArray[n2];
                        nextTableColumn.pack();
                        columnsWidth += nextTableColumn.getWidth();
                        ++n2;
                    }
                    Rectangle clientArea = table.getClientArea();
                    Point preferredSize = table.computeSize(-1, -1);
                    int netWidth = clientArea.width - 2 * table.getBorderWidth();
                    if (preferredSize.y > clientArea.height + table.getHeaderHeight() && (vScrollBar = table.getVerticalBar()) != null) {
                        netWidth -= vScrollBar.getSize().x;
                    }
                    if ((widthToBeSet = (lastButOneTableColumn = tableColumns[tableColumns.length - 2]).getWidth() + netWidth - columnsWidth) > lastButOneTableColumn.getWidth()) {
                        lastButOneTableColumn.setWidth(widthToBeSet);
                    }
                }
                table.addControlListener((ControlListener)this);
            }
        });
    }

    public static String wrapTextForTooltip(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        return StringUtility.wrap((String)text, (int)60, (String)" ");
    }

    public static void applySashSeparatorStyle(SashForm sashForm) {
        assert (sashForm != null) : "Parameter 'sashForm' of method 'applySashSeparatorStyle' must not be null";
        assert (!sashForm.isDisposed()) : "Parameter 'sashForm' of method 'applySashSeparatorStyle' must not be disposed!";
        sashForm.setBackground(UiResourceManager.getInstance().getSeparatorColor());
        sashForm.setSashWidth(2);
    }

    private static String createLines(int numberOfLines) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < numberOfLines) {
            sb.append("ADDLF");
            if (i < numberOfLines - 1) {
                sb.append(StringUtility.LINE_SEPARATOR);
            }
            ++i;
        }
        return sb.toString();
    }

    public static int calculatePreferredHeight(Text text, int numberOfLines) {
        assert (text != null) : "Parameter 'text' of method 'calculatePreferredHeight' must not be null";
        assert (numberOfLines > 0) : "Must be greater than 0";
        String originalText = text.getText();
        text.setText(SwtUtility.createLines(numberOfLines));
        Point preferredSize = text.computeSize(-1, -1);
        text.setText(originalText);
        return preferredSize.y;
    }

    public static int getLastOffset(StyledText text, int line) {
        assert (text != null) : "Parameter 'text' of method 'getLastOffset' must not be null";
        assert (line >= 0) : "Parameter 'line' of method 'getLastOffset' must be positive";
        int lastLine = text.getLineCount() - 1;
        assert (line <= lastLine) : "Parameter 'line' of method 'getLastOffset' must be lower line count";
        int length = text.getLine(line).length();
        int firstOffset = text.getOffsetAtLine(line);
        int lastOffset = firstOffset + length;
        assert (text.getLineAtOffset(lastOffset) == line) : "Last offset of line must be part of that line";
        return lastOffset;
    }

    public static String getLineWithLineBreak(StyledText text, int line) {
        assert (text != null) : "Parameter 'text' of method 'getLineWithLineBreak' must not be null";
        assert (line >= 0) : "Parameter 'line' of method 'getLineWithLineBreak' must be positive";
        assert (line <= text.getLineCount() - 1) : "Parameter 'line' of method 'getLineWithLineBreak' must be lower line count";
        return text.getLine(line) + SwtUtility.getLineBreak(text, line);
    }

    public static String getLineBreak(StyledText text, int line) {
        block15: {
            String lineBreak;
            assert (text != null) : "Parameter 'text' of method 'getLineBreak' must not be null";
            assert (line >= 0) : "Parameter 'line' of method 'getLineBreak' must be positive";
            int lastLine = text.getLineCount() - 1;
            assert (line <= lastLine) : "Parameter 'line' of method 'getLineBreak' must be lower line count";
            if (line >= lastLine) break block15;
            int length = text.getLine(line).length();
            int firstOffset = text.getOffsetAtLine(line) + length;
            int lastOffset = text.getOffsetAtLine(line + 1) - 1;
            switch (lineBreak = text.getText(firstOffset, lastOffset)) {
                case "\n": 
                case "\r": 
                case "\r\n": {
                    return lineBreak;
                }
            }
            assert (false) : "Unexpected line break: '" + lineBreak + "'";
        }
        return "";
    }

    public static void disableEscape(Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'disableEscape' must not be null";
        assert (!shell.isDisposed()) : "'shell' already disposed";
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
    }

    public static Point calculateScreenCenteredLocation(Shell shell, Point initialSize) {
        assert (shell != null) : "Parameter 'shell' of method 'calculateScreenCenteredLocation' must not be null";
        assert (!shell.isDisposed()) : "'shell' already disposed";
        assert (initialSize != null) : "Parameter 'initialSize' of method 'calculateScreenCenteredLocation' must not be null";
        Monitor monitor = shell.getMonitor();
        if (monitor != null) {
            Rectangle bounds = monitor.getBounds();
            int x = bounds.x + (bounds.width - initialSize.x) / 2;
            int y = bounds.y + (bounds.height - initialSize.y) / 2;
            return new Point(x, y);
        }
        return null;
    }

    public static void adjustToMonitorBounds(Rectangle rectangle, Shell shell) {
        int monitorY;
        int monitorHeight;
        int notVisibleInY;
        assert (rectangle != null) : "Parameter 'rectangle' of method 'adjustToMonitorBounds' must not be null";
        assert (shell != null) : "Parameter 'shell' of method 'adjustToMonitorBounds' must not be null";
        Monitor monitor = shell.getMonitor();
        assert (monitor != null) : "'monitor' of method 'openTooltip' must not be null";
        Rectangle monitorBounds = monitor.getBounds();
        int monitorWidth = monitorBounds.width;
        int monitorX = monitorBounds.x;
        int notVisibleInX = monitorWidth + monitorX - rectangle.x - rectangle.width;
        if (notVisibleInX < 0) {
            rectangle.x = Math.max(rectangle.x + notVisibleInX, 0);
            rectangle.width = Math.min(monitorWidth - rectangle.x, rectangle.width);
        }
        if ((notVisibleInY = (monitorHeight = monitorBounds.height) + (monitorY = monitorBounds.y) - rectangle.y - rectangle.height) < 0) {
            rectangle.y = Math.max(rectangle.y + notVisibleInY, 0);
            rectangle.height = Math.min(monitorHeight - rectangle.y, rectangle.height);
        }
    }
}

