/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.ui.swt.base.AbstractHorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class DetailsSeparatorWidget
extends AbstractHorizontalSeparator
implements MouseListener {
    public static final RGB SEPARATOR_COLOR = UiResourceManager.GREY;
    private ExpansionState m_state;
    private final List<IExpansionStateListener> m_listeners = new ArrayList<IExpansionStateListener>();
    private final String m_identifier;

    public DetailsSeparatorWidget(Composite parent, ExpansionState state, String identifier) {
        super(parent, null, UiResourceManager.getInstance().getColor(SEPARATOR_COLOR), UiResourceManager.getInstance().getBackgroundColor(), state.getImageName());
        assert (state != null) : "Parameter 'state' of method 'DetailsSeparatorWidget' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'DetailsSeparatorWidget' must not be empty";
        this.m_state = state;
        this.m_identifier = identifier;
        this.applyVisibility(this.m_state);
        this.addMouseListener(this);
        this.getControls().forEach(c -> c.addMouseListener((MouseListener)this));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                DetailsSeparatorWidget.this.removeMouseListener(DetailsSeparatorWidget.this);
                DetailsSeparatorWidget.this.getControls().forEach(c -> c.removeMouseListener((MouseListener)DetailsSeparatorWidget.this));
                DetailsSeparatorWidget.this.m_listeners.clear();
            }
        });
    }

    public void addVisibilityChangeListener(IExpansionStateListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'addVisibilityChangeListener' must not be null";
        this.m_listeners.add(listener);
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
        this.m_state = this.m_state == ExpansionState.EXPANDED ? ExpansionState.COLLAPSED : ExpansionState.EXPANDED;
        this.applyVisibility(this.m_state);
        this.getParent().layout(true);
    }

    private void applyVisibility(ExpansionState state) {
        assert (state != null) : "Parameter 'state' of method 'applyVisibility' must not be null";
        this.set(null, UiResourceManager.getInstance().getImage(state.getImageName()), state.getImageName());
        for (IExpansionStateListener next : this.m_listeners) {
            next.changeExpansionState(state, this.m_identifier);
        }
    }

    public ExpansionState getState() {
        return this.m_state;
    }

    public static final class DefaultExpansionStateListener
    implements IExpansionStateListener {
        private final Control m_control;

        public DefaultExpansionStateListener(Control control) {
            assert (control != null) : "Parameter 'control' of method 'DefaultVisibilityChangeListener' must not be null";
            this.m_control = control;
        }

        @Override
        public void changeExpansionState(ExpansionState expansionState, String identifier) {
            assert (expansionState != null) : "Parameter 'expansionState' of method 'changeExpansionState' must not be null";
            assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'changeExpansionState' must not be empty";
            boolean visible = expansionState == ExpansionState.EXPANDED;
            this.m_control.setVisible(visible);
            Object layoutData = this.m_control.getLayoutData();
            if (layoutData instanceof GridData) {
                ((GridData)layoutData).exclude = !visible;
            }
        }
    }

    public static enum ExpansionState {
        EXPANDED("Collapse"),
        COLLAPSED("Expand");

        private String m_imageName;

        private ExpansionState(String imageName) {
            this.m_imageName = imageName;
        }

        public String getImageName() {
            return this.m_imageName;
        }
    }

    public static interface IExpansionStateListener {
        public void changeExpansionState(ExpansionState var1, String var2);
    }
}

