/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.analyzersview;

import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.analyzersview.AnalyzerExecutionLevelDescriptionMenuItem;
import com.hello2morrow.sonargraph.ui.swt.analyzersview.AnalyzerExecutionLevelMenuItem;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public final class AnalyzerExecutionLevelSubMenu
implements ISonargraphUIContribution {
    private static final String ANALYZER_EXECUTION_LEVEL_ICON_URI = "platform:/plugin/com.hello2morrow.sonargraph.ui.swt/images/AnalyzerExecutionLevel.gif";

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        assert (items != null) : "Parameter 'items' of method 'aboutToShow' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        IAnalyzerProvider analyzerProvider = provider.hasSoftwareSystem() ? (IAnalyzerProvider)provider.getSoftwareSystem().getExtension(IAnalyzerProvider.class) : null;
        String iconUri = Platform.isWindows() ? null : ANALYZER_EXECUTION_LEVEL_ICON_URI;
        AnalyzerExecutionLevel currentLevel = provider.getAnalyzerExecutionLevel();
        AnalyzerExecutionLevel[] analyzerExecutionLevelArray = AnalyzerExecutionLevel.values();
        int n = analyzerExecutionLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalyzerExecutionLevel next = analyzerExecutionLevelArray[n2];
            MDirectMenuItem nextItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            nextItem.setType(ItemType.CHECK);
            nextItem.setLabel(next.getPresentationName());
            if (analyzerProvider != null) {
                nextItem.setTooltip(analyzerProvider.getAnalyzerExecutionLevelDescription(next));
            }
            nextItem.setSelected(currentLevel.equals((Object)next));
            nextItem.getTransientData().put(AnalyzerExecutionLevel.class.getName(), next);
            nextItem.setIconURI(iconUri);
            nextItem.setContributorURI("platform:/plugin/com.hello2morrow.sonargraph.ui.swt");
            nextItem.setContributionURI("bundleclass://com.hello2morrow.sonargraph.ui.swt/" + AnalyzerExecutionLevelMenuItem.class.getName());
            items.add((MMenuElement)nextItem);
            ++n2;
        }
        if (analyzerProvider != null) {
            items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
            MDirectMenuItem descriptionItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            descriptionItem.setType(ItemType.PUSH);
            descriptionItem.setLabel("Description...");
            descriptionItem.setIconURI(ANALYZER_EXECUTION_LEVEL_ICON_URI);
            descriptionItem.setContributorURI("platform:/plugin/com.hello2morrow.sonargraph.ui.swt");
            descriptionItem.setContributionURI("bundleclass://com.hello2morrow.sonargraph.ui.swt/" + AnalyzerExecutionLevelDescriptionMenuItem.class.getName());
            items.add((MMenuElement)descriptionItem);
        }
    }
}

