/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.ColorConstants;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Label;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.Toggle;
import org.eclipse.swt.graphics.Image;

public class ToggleButton
extends Toggle {
    protected Label label = null;

    public ToggleButton() {
        this.setStyle(STYLE_BUTTON | STYLE_TOGGLE);
    }

    public ToggleButton(IFigure contents) {
        super(contents, STYLE_BUTTON | STYLE_TOGGLE);
    }

    public ToggleButton(String text) {
        this(text, null);
    }

    public ToggleButton(String text, Image normalIcon) {
        super(new Label(text, normalIcon), STYLE_BUTTON | STYLE_TOGGLE);
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        if (this.isSelected() && this.isOpaque()) {
            this.fillCheckeredRectangle(graphics);
        } else {
            super.paintFigure(graphics);
        }
    }

    protected void fillCheckeredRectangle(Graphics graphics) {
        graphics.setBackgroundColor(ColorConstants.button);
        graphics.setForegroundColor(ColorConstants.buttonLightest);
        Rectangle rect = this.getClientArea(Rectangle.SINGLETON).crop(new Insets(1, 1, 0, 0));
        graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        graphics.clipRect(rect);
        graphics.translate(rect.x, rect.y);
        int n = rect.width + rect.height;
        int i = 1;
        while (i < n) {
            graphics.drawLine(0, i, i, 0);
            i += 2;
        }
        graphics.restoreState();
    }
}

