/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.DirectedGraph;
import com.hello2morrow.draw2d.Edge;
import com.hello2morrow.draw2d.EdgeList;
import com.hello2morrow.draw2d.Node;
import com.hello2morrow.draw2d.NodeList;
import com.hello2morrow.draw2d.Rank;
import com.hello2morrow.draw2d.Subgraph;

class GraphUtilities {
    GraphUtilities() {
    }

    static Subgraph getCommonAncestor(Node left, Node right) {
        Subgraph parent = right instanceof Subgraph ? (Subgraph)right : right.getParent();
        while (parent != null) {
            if (parent.isNested(left)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean isCyclic(DirectedGraph graph) {
        return GraphUtilities.isCyclic(new NodeList(graph.nodes));
    }

    public static boolean isCyclic(NodeList nodes) {
        if (nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        int i = 0;
        while (i < nodes.size()) {
            Node node = nodes.getNode(i);
            if (node.outgoing == null || node.outgoing.isEmpty()) {
                nodes.remove(node);
                int j = 0;
                while (j < node.incoming.size()) {
                    Edge e = node.incoming.getEdge(j);
                    e.source.outgoing.remove(e);
                    ++j;
                }
            }
            ++i;
        }
        if (nodes.size() == size) {
            return true;
        }
        return GraphUtilities.isCyclic(nodes);
    }

    public static int numberOfCrossingsInGraph(DirectedGraph graph) {
        int crossings = 0;
        int i = 0;
        while (i < graph.ranks.size()) {
            Rank rank = graph.ranks.getRank(i);
            crossings += GraphUtilities.numberOfCrossingsInRank(rank);
            ++i;
        }
        return crossings;
    }

    public static int numberOfCrossingsInRank(Rank rank) {
        int crossings = 0;
        int i = 0;
        while (i < rank.size() - 1) {
            Node currentNode = rank.getNode(i);
            int j = i + 1;
            while (j < rank.size()) {
                Node nextNode = rank.getNode(j);
                EdgeList currentOutgoing = currentNode.outgoing;
                EdgeList nextOutgoing = nextNode.outgoing;
                int k = 0;
                while (k < currentOutgoing.size()) {
                    Edge currentEdge = currentOutgoing.getEdge(k);
                    int l = 0;
                    while (l < nextOutgoing.size()) {
                        if (nextOutgoing.getEdge(l).getIndexForRank(currentNode.rank + 1) < currentEdge.getIndexForRank(currentNode.rank + 1)) {
                            ++crossings;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return crossings;
    }

    private static NodeList search(Node node, NodeList list) {
        if (node.flag) {
            return list;
        }
        node.flag = true;
        list.add(node);
        int i = 0;
        while (i < node.outgoing.size()) {
            GraphUtilities.search(node.outgoing.getEdge((int)i).target, list);
            ++i;
        }
        return list;
    }

    public static boolean willCauseCycle(Node source, Node target) {
        NodeList nodes = GraphUtilities.search(target, new NodeList());
        nodes.resetFlags();
        return nodes.contains(source);
    }

    static boolean isConstrained(Node left, Node right) {
        Subgraph common = left.getParent();
        while (common != null && !common.isNested(right)) {
            left = left.getParent();
            common = left.getParent();
        }
        while (right.getParent() != common) {
            right = right.getParent();
        }
        return left.rowOrder != -1 && right.rowOrder != -1 && left.rowOrder != right.rowOrder;
    }
}

