/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.FigureListener;
import com.hello2morrow.draw2d.FreeformFigure;
import com.hello2morrow.draw2d.FreeformListener;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Rectangle;
import java.util.List;

class FreeformHelper
implements FreeformListener {
    private FreeformFigure host;
    private Rectangle freeformExtent;
    private FigureListener figureListener = new ChildTracker();

    FreeformHelper(FreeformFigure host) {
        this.host = host;
    }

    public Rectangle getFreeformExtent() {
        if (this.freeformExtent != null) {
            return this.freeformExtent;
        }
        List children = this.host.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Rectangle r = child instanceof FreeformFigure ? ((FreeformFigure)child).getFreeformExtent() : child.getBounds();
            if (this.freeformExtent == null) {
                this.freeformExtent = r.getCopy();
            } else {
                this.freeformExtent.union(r);
            }
            ++i;
        }
        Insets insets = this.host.getInsets();
        if (this.freeformExtent == null) {
            this.freeformExtent = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
        } else {
            this.host.translateToParent(this.freeformExtent);
            this.freeformExtent.expand(insets);
        }
        return this.freeformExtent;
    }

    public void hookChild(IFigure child) {
        this.invalidate();
        if (child instanceof FreeformFigure) {
            ((FreeformFigure)child).addFreeformListener(this);
        } else {
            child.addFigureListener(this.figureListener);
        }
    }

    void invalidate() {
        this.freeformExtent = null;
        this.host.fireExtentChanged();
        if (this.host.getParent() != null) {
            this.host.getParent().revalidate();
        } else {
            this.host.revalidate();
        }
    }

    @Override
    public void notifyFreeformExtentChanged() {
        this.invalidate();
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.host.setBounds(bounds);
        bounds = bounds.getCopy();
        this.host.translateFromParent(bounds);
        List children = this.host.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (child instanceof FreeformFigure) {
                ((FreeformFigure)child).setFreeformBounds(bounds);
            }
            ++i;
        }
    }

    public void unhookChild(IFigure child) {
        this.invalidate();
        if (child instanceof FreeformFigure) {
            ((FreeformFigure)child).removeFreeformListener(this);
        } else {
            child.removeFigureListener(this.figureListener);
        }
    }

    class ChildTracker
    implements FigureListener {
        ChildTracker() {
        }

        @Override
        public void figureMoved(IFigure source) {
            FreeformHelper.this.invalidate();
        }
    }
}

