/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.CompoundDirectedGraph;
import com.hello2morrow.draw2d.DirectedGraph;
import com.hello2morrow.draw2d.Edge;
import com.hello2morrow.draw2d.Node;
import com.hello2morrow.draw2d.NodeList;
import com.hello2morrow.draw2d.PopulateRanks;
import com.hello2morrow.draw2d.Subgraph;
import java.util.Iterator;

class CompoundPopulateRanks
extends PopulateRanks {
    CompoundPopulateRanks() {
    }

    @Override
    public void visit(DirectedGraph g) {
        CompoundDirectedGraph graph = (CompoundDirectedGraph)g;
        Iterator containment = graph.containment.iterator();
        while (containment.hasNext()) {
            Edge e = (Edge)containment.next();
            if (e.getSlack() <= 0) continue;
            graph.removeEdge(e);
            containment.remove();
        }
        super.visit(g);
        NodeList subgraphs = graph.subgraphs;
        int i = 0;
        while (i < subgraphs.size()) {
            Subgraph subgraph = (Subgraph)subgraphs.get(i);
            this.bridgeSubgraph(subgraph, graph);
            ++i;
        }
    }

    private void bridgeSubgraph(Subgraph subgraph, CompoundDirectedGraph g) {
        int offset = subgraph.head.rank;
        boolean[] occupied = new boolean[subgraph.tail.rank - subgraph.head.rank + 1];
        Node[] bridge = new Node[occupied.length];
        int i = 0;
        while (i < subgraph.members.size()) {
            Node n = (Node)subgraph.members.get(i);
            if (n instanceof Subgraph) {
                Subgraph s = (Subgraph)n;
                int r = s.head.rank;
                while (r <= s.tail.rank) {
                    occupied[r - offset] = true;
                    ++r;
                }
            } else {
                occupied[n.rank - offset] = true;
            }
            ++i;
        }
        i = 0;
        while (i < bridge.length) {
            if (!occupied[i]) {
                Node br = bridge[i] = new Node("bridge", subgraph);
                br.rank = i + offset;
                br.width = 0;
                br.height = 0;
                br.nestingIndex = subgraph.nestingIndex;
                g.ranks.getRank(br.rank).add(br);
                g.nodes.add(br);
            }
            ++i;
        }
    }
}

