/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.refactoringsview;

import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.StandardEnumerationMultiSelectWidget;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.RefactoringsViewFilterConfiguration;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.StatusGroup;
import java.util.EnumSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class RefactoringsViewFilterDialog
extends StandardDialog {
    private Text m_assigneeText;
    private Text m_descriptionText;
    private StandardEnumerationMultiSelectWidget<Priority> m_priorityWidget;
    private StandardEnumerationMultiSelectWidget<StatusGroup> m_statusGroupWidget;
    private final RefactoringsViewFilterConfiguration m_configuration = new RefactoringsViewFilterConfiguration();

    public RefactoringsViewFilterDialog(Shell shell, String title) {
        super(shell, title);
    }

    @Override
    protected int getNumberOfColumns() {
        return 2;
    }

    @Override
    protected Point getPreferredSize() {
        return new Point(520, 280);
    }

    @Override
    protected Point getMinimumSize() {
        return new Point(520, 280);
    }

    @Override
    protected IDialogId getDialogId() {
        return UiSwtDialogId.REFACTORINGS_VIEW_FILTER_DIALOG;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        SwtUtility.createOneCellLabel(composite, "Status: ", 131072);
        StandardEnumerationMultiSelectWidget.IConsumer statusGroupConsumer = selectedEnumerationValues -> this.checkButton();
        this.m_statusGroupWidget = new StandardEnumerationMultiSelectWidget<StatusGroup>(composite, statusGroupConsumer, EnumSet.allOf(StatusGroup.class), EnumSet.allOf(StatusGroup.class), 1);
        this.m_statusGroupWidget.setToolTipText(StatusGroup.APPLICABLE, StatusGroup.APPLICABLE.getGroupPresentationString());
        this.m_statusGroupWidget.setToolTipText(StatusGroup.NOT_APPLICABLE, StatusGroup.NOT_APPLICABLE.getGroupPresentationString());
        SwtUtility.createOneCellLabel(composite, "Priority: ", 131072);
        StandardEnumerationMultiSelectWidget.IConsumer priorityConsumer = selectedEnumerationValues -> this.checkButton();
        this.m_priorityWidget = new StandardEnumerationMultiSelectWidget<Priority>(composite, priorityConsumer, EnumSet.allOf(Priority.class), EnumSet.allOf(Priority.class), 1);
        SwtUtility.createOneCellLabel(composite, "Assignee: ", 131072);
        this.m_assigneeText = SwtUtility.createTextFieldForGridLayout(composite, -1, -1, 1, 1, false);
        this.m_assigneeText.addModifyListener(event -> this.checkButton());
        SwtUtility.createOneCellLabel(composite, "Description: ", 131072);
        this.m_descriptionText = SwtUtility.createTextFieldForGridLayout(composite, -1, -1, 1, 1, false);
        this.m_descriptionText.addModifyListener(event -> this.checkButton());
    }

    private void checkButton() {
        this.getButton(0).setEnabled(true);
    }

    @Override
    protected void applyData() {
        this.m_descriptionText.setText(this.m_configuration.getDescription());
        this.m_assigneeText.setText(this.m_configuration.getAssignee());
        this.m_statusGroupWidget.select(this.m_configuration.getStatusGroup());
        this.m_priorityWidget.select(this.m_configuration.getPriority());
        this.getButton(0).setEnabled(false);
    }

    @Override
    protected IEclipsePreferences saveData() {
        this.m_configuration.setAssignee(this.m_assigneeText.getText());
        this.m_configuration.setDescription(this.m_descriptionText.getText());
        this.m_configuration.setStatusGroup(this.m_statusGroupWidget.getSelected());
        this.m_configuration.setPriority(this.m_priorityWidget.getSelected());
        return this.m_configuration.getPreferences();
    }

    public static enum TextSearchOption implements IStandardEnumeration
    {
        CONTAINS,
        CASE_SENSITIVE,
        REGULAR_EXPRESSION,
        WHOLE_WORD;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

