/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.refactoringsview;

import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.foundation.utilities.EnumUtility;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.StatusGroup;
import java.util.EnumSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class RefactoringsViewFilterConfiguration
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String ASSIGNEE_FILTER = "ASSIGNEE_FILTER";
    public static final String DESCRIPTION_FILTER = "DESCRIPTION_FILTER";
    public static final String PRIORITY_FILTER = "PRIORITY_FILTER";
    public static final String STATUS_GROUP_FILTER = "STATUS_GROUP_FILTER";
    public static final String ASSIGNEE_FILTER_DEFAULT = "";
    public static final String DESCRIPTION_FILTER_DEFAULT = "";
    public static final EnumSet<Priority> PRIORITY_FILTER_DEFAULT = EnumSet.allOf(Priority.class);
    public static final EnumSet<StatusGroup> STATUS_GROUP_FILTER_DEFAULT = EnumSet.allOf(StatusGroup.class);
    private final IEclipsePreferences m_preferences = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", UiSwtDialogId.REFACTORINGS_VIEW_FILTER_DIALOG);
    private String m_assignee;
    private String m_description;
    private EnumSet<Priority> m_priority;
    private EnumSet<StatusGroup> m_statusGroup;

    public RefactoringsViewFilterConfiguration() {
        this.refresh();
        this.m_preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void refresh() {
        this.m_assignee = this.m_preferences.get(ASSIGNEE_FILTER, "");
        this.m_description = this.m_preferences.get(DESCRIPTION_FILTER, "");
        String priority = this.m_preferences.get(PRIORITY_FILTER, null);
        this.m_priority = priority == null ? PRIORITY_FILTER_DEFAULT : EnumUtility.parseEnumValues((String)priority, Priority.class);
        String statusGroup = this.m_preferences.get(STATUS_GROUP_FILTER, null);
        this.m_statusGroup = statusGroup == null ? STATUS_GROUP_FILTER_DEFAULT : EnumUtility.parseEnumValues((String)statusGroup, StatusGroup.class);
    }

    public String getAssignee() {
        return this.m_assignee;
    }

    public String getDescription() {
        return this.m_description;
    }

    public EnumSet<Priority> getPriority() {
        return this.m_priority;
    }

    public EnumSet<StatusInfo.Status> getStatus() {
        EnumSet<StatusInfo.Status> result = EnumSet.noneOf(StatusInfo.Status.class);
        for (StatusGroup group : this.getStatusGroup()) {
            result.addAll(group.getGroup());
        }
        return result;
    }

    public EnumSet<StatusGroup> getStatusGroup() {
        return this.m_statusGroup;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String newValue = (String)event.getNewValue();
        switch (event.getKey()) {
            case "ASSIGNEE_FILTER": {
                this.m_assignee = newValue;
                break;
            }
            case "DESCRIPTION_FILTER": {
                this.m_description = newValue;
                break;
            }
            case "PRIORITY_FILTER": {
                this.m_priority = EnumUtility.parseEnumValues((String)newValue, Priority.class);
                break;
            }
            case "STATUS_GROUP_FILTER": {
                this.m_statusGroup = EnumUtility.parseEnumValues((String)newValue, StatusGroup.class);
            }
        }
    }

    public IEclipsePreferences getPreferences() {
        return this.m_preferences;
    }

    public void setAssignee(String assignee) {
        this.m_preferences.put(ASSIGNEE_FILTER, assignee);
    }

    public void setDescription(String description) {
        this.m_preferences.put(DESCRIPTION_FILTER, description);
    }

    public void setStatusGroup(EnumSet<StatusGroup> statusGroup) {
        this.m_preferences.put(STATUS_GROUP_FILTER, EnumUtility.concatEnumValues(statusGroup));
    }

    public void setPriority(EnumSet<Priority> priority) {
        this.m_preferences.put(PRIORITY_FILTER, EnumUtility.concatEnumValues(priority));
    }

    public void resetToDefault() {
        this.setAssignee("");
        this.setDescription("");
        this.setPriority(PRIORITY_FILTER_DEFAULT);
        this.setStatusGroup(STATUS_GROUP_FILTER_DEFAULT);
    }
}

