/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.license.LicensePropertyValidator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class LicenseInfoWidget
extends Composite
implements LicensePropertyValidator.ILicenseAccess,
ValidatingTextOrComboWidget.IConsumer {
    private static final String LICENSE_DETAILS = "License Details";
    private static final String SEPARATOR = ",";
    private final Map<SonargraphLicense.Property, ValidatingTextWidget> m_propertyToWidget = new HashMap<SonargraphLicense.Property, ValidatingTextWidget>();
    private final List<Control> m_languageRelatedControls = new ArrayList<Control>(5);
    private final Group m_group;
    private final ScrolledComposite m_scrolledComposite;
    private final Composite m_propertiesComposite;
    private final EnumSet<SonargraphLicense.Property> m_ignoredProperties = EnumSet.of(SonargraphLicense.Property.HEART_BEAT_SECONDS, SonargraphLicense.Property.TICKET_ID, SonargraphLicense.Property.TICKET_MAGIC, SonargraphLicense.Property.COPYRIGHT);
    private SonargraphLicense m_currentlyShownLicense;

    public LicenseInfoWidget(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.m_group = new Group((Composite)this, 0);
        this.m_group.setText(LICENSE_DETAILS);
        this.m_group.setLayout((Layout)new FillLayout());
        this.m_scrolledComposite = new ScrolledComposite((Composite)this.m_group, 768);
        this.m_propertiesComposite = new Composite((Composite)this.m_scrolledComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 1;
        layout.marginBottom = 1;
        layout.marginLeft = 1;
        layout.marginRight = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.verticalSpacing = 1;
        layout.horizontalSpacing = 1;
        this.m_propertiesComposite.setLayout((Layout)layout);
        SonargraphLicense.Property[] propertyArray = SonargraphLicense.Property.values();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SonargraphLicense.Property nextProperty = propertyArray[n2];
            if (!this.m_ignoredProperties.contains(nextProperty)) {
                Label nextLabel = new Label(this.m_propertiesComposite, 131072);
                if (nextProperty == SonargraphLicense.Property.LOGIN) {
                    nextLabel.setText(String.format("%s (current '%s'): ", nextProperty.getPresentationName(), Platform.getUserName()));
                } else {
                    nextLabel.setText(nextProperty.getPresentationName() + ": ");
                }
                ValidatingTextWidget nextValidatingTextWidget = new ValidatingTextWidget(this.m_propertiesComposite, new LicensePropertyValidator(this, nextProperty), this);
                nextValidatingTextWidget.setLayoutData(new GridData(4, 0, true, false));
                this.m_propertyToWidget.put(nextProperty, nextValidatingTextWidget);
                nextValidatingTextWidget.setEditable(false);
            }
            ++n2;
        }
        this.m_scrolledComposite.setContent((Control)this.m_propertiesComposite);
        Point size = this.m_propertiesComposite.computeSize(-1, -1);
        this.m_scrolledComposite.setMinSize(size.x, size.y);
        this.m_scrolledComposite.setExpandHorizontal(true);
        this.m_scrolledComposite.setExpandVertical(true);
    }

    public void show(SonargraphLicense license, String additionalText, ISoftwareSystemProvider provider) {
        assert (additionalText != null) : "Parameter 'additionalText' of method 'show' must not be null";
        for (Control nextControl : this.m_languageRelatedControls) {
            nextControl.dispose();
        }
        this.m_languageRelatedControls.clear();
        this.m_currentlyShownLicense = license;
        if (this.m_currentlyShownLicense != null) {
            SonargraphLicense.Property[] propertyArray = SonargraphLicense.Property.values();
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatingTextWidget nextValidatingTextWidget;
                SonargraphLicense.Property nextProperty = propertyArray[n2];
                String nextValue = this.m_currentlyShownLicense.getValue(nextProperty);
                if (nextValue != null && nextValue.contains(SEPARATOR)) {
                    nextValue = nextValue.replaceAll(SEPARATOR, ", ");
                }
                if ((nextValidatingTextWidget = this.m_propertyToWidget.get(nextProperty)) != null) {
                    nextValidatingTextWidget.setText(nextValue == null ? "" : nextValue);
                }
                ++n2;
            }
            Set licensedLanguages = this.m_currentlyShownLicense.getLicensedLanguages();
            for (Language nextLicensedLanguage : licensedLanguages) {
                Label languages = new Label(this.m_propertiesComposite, 131072);
                this.m_languageRelatedControls.add((Control)languages);
                Text text = SwtUtility.createTextFieldForGridLayout(this.m_propertiesComposite, false, 0);
                this.m_languageRelatedControls.add((Control)text);
                String sizeUnit = nextLicensedLanguage.getSizeUnit();
                StringBuilder builder = new StringBuilder();
                builder.append(this.m_currentlyShownLicense.getLicensedSizePresentationName(nextLicensedLanguage));
                builder.append(" '");
                builder.append(sizeUnit);
                builder.append("' available");
                if (provider != null) {
                    builder.append(" (");
                    builder.append(NumberUtility.format((Number)provider.getUsedSize(nextLicensedLanguage)));
                    builder.append(" used)");
                }
                languages.setText(nextLicensedLanguage.getPresentationName() + ": ");
                text.setText(builder.toString());
            }
        } else {
            for (ValidatingTextWidget nextValidatingTextWidget : this.m_propertyToWidget.values()) {
                nextValidatingTextWidget.setText("");
            }
        }
        this.m_group.setText("License Details " + additionalText);
        this.m_propertiesComposite.layout(true);
        Point size = this.m_propertiesComposite.computeSize(-1, -1);
        this.m_scrolledComposite.setMinSize(size.x, size.y);
        this.m_scrolledComposite.layout(true);
        this.m_group.layout(true);
    }

    @Override
    public SonargraphLicense getSonargraphLicense() {
        return this.m_currentlyShownLicense;
    }

    @Override
    public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
    }
}

