/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.foundation.common.graph.Adjacency;
import com.hello2morrow.sonargraph.core.foundation.common.graph.PrecisionLocation;
import com.hello2morrow.sonargraph.core.foundation.common.graph.SpringEmbedderLayoutAlgorithm;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawCache;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.IGraphViewCycleLayouter;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraphViewSpringEmbedderLayouter
implements IGraphViewCycleLayouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphViewSpringEmbedderLayouter.class);
    private static final String KEY_NODE_FIGURE_TO_BOUNDS = "NodeFigureToBounds";
    private static final int ADJUST_OVERLAPPING_THRESHOLD = 200;
    private static final int OFFSET_NODES = 10;

    GraphViewSpringEmbedderLayouter() {
    }

    @Override
    public Dimension getPreferredSize(List<GraphViewNodeFigure> nodes, DrawCache cache) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'getPreferredSize' must not be empty";
        assert (cache != null) : "Parameter 'cache' of method 'getPreferredSize' must not be null";
        LOGGER.debug("Calculate preferred size");
        LOGGER.trace("Create adjacency for " + nodes.size() + " nodes");
        THashSet nodesAsSet = new THashSet(nodes.size());
        nodes.forEach(arg_0 -> GraphViewSpringEmbedderLayouter.lambda$0((Set)nodesAsSet, arg_0));
        Adjacency adjacency = new Adjacency();
        for (GraphViewNodeFigure nextNode : nodes) {
            for (GraphViewNode.GraphViewDependency edge : ((GraphViewNode)nextNode.getNode()).getOutgoingDependencies()) {
                if (!nodesAsSet.contains(edge.getTo())) continue;
                adjacency.addEdge((Object)edge.getFrom(), (Object)edge.getTo(), edge.getNumberOfParserDependencies());
            }
        }
        LOGGER.trace("Create spring embedder layout");
        SpringEmbedderLayoutAlgorithm algorithm = new SpringEmbedderLayoutAlgorithm();
        Map positions = algorithm.layout(adjacency);
        LOGGER.trace("Determine min/max positions");
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (PrecisionLocation nextLoc : positions.values()) {
            minX = Math.min(minX, nextLoc.getRoundedX());
            minY = Math.min(minY, nextLoc.getRoundedY());
        }
        LOGGER.debug("Calculate bounds (minX/minY): " + minX + " / " + minY);
        int requiredWidth = 0;
        int requiredHeight = 0;
        THashMap nodeFigureToBounds = new THashMap(nodes.size());
        if (nodes.size() <= 200) {
            LOGGER.trace("Sort nodes");
            ArrayList<GraphViewNodeFigure> nodesToUse = new ArrayList<GraphViewNodeFigure>(nodes);
            Collections.sort(nodesToUse, new GraphViewNodeFigureComparator(positions));
            int currentOffsetX = 0;
            int currentOffsetY = 0;
            ArrayList<Rectangle> processed = new ArrayList<Rectangle>(nodes.size());
            int i = 0;
            while (i < nodesToUse.size()) {
                GraphViewNodeFigure nextNode = (GraphViewNodeFigure)nodesToUse.get(i);
                PrecisionLocation nextLocation = (PrecisionLocation)positions.get(nextNode.getNode());
                assert (nextLocation != null) : "'nextLocation' of method 'layout' must not be null";
                Dimension nodePreferredSize = nextNode.getPreferredSize();
                Rectangle boundingBox = new Rectangle();
                boundingBox.x = currentOffsetX + nextLocation.getRoundedX() - minX + 10;
                boundingBox.y = currentOffsetY + nextLocation.getRoundedY() - minY + 10;
                boundingBox.width = nodePreferredSize.width;
                boundingBox.height = nodePreferredSize.height;
                boolean correctedPosition = false;
                int startPosX = boundingBox.x;
                int startPosY = boundingBox.y;
                for (Rectangle nextProcessed : processed) {
                    if (!nextProcessed.intersects(boundingBox)) continue;
                    int newX = nextProcessed.x + nextProcessed.width;
                    int diffX = newX - boundingBox.x;
                    int newY = nextProcessed.y + nextProcessed.height;
                    int diffY = newY - boundingBox.y;
                    if (diffX <= diffY) {
                        boundingBox.x += diffX;
                    } else {
                        boundingBox.y += diffY;
                    }
                    correctedPosition = true;
                }
                if (correctedPosition) {
                    currentOffsetX += boundingBox.x - startPosX;
                    currentOffsetY += boundingBox.y - startPosY;
                }
                nodeFigureToBounds.put(nextNode, boundingBox);
                processed.add(boundingBox);
                requiredWidth = Math.max(boundingBox.x + nodePreferredSize.width, requiredWidth);
                requiredHeight = Math.max(boundingBox.y + nodePreferredSize.height, requiredHeight);
                ++i;
            }
        } else {
            for (GraphViewNodeFigure nextNode : nodes) {
                PrecisionLocation nextLocation = (PrecisionLocation)positions.get(nextNode.getNode());
                assert (nextLocation != null) : "'nextLocation' of method 'layout' must not be null";
                Dimension nodePreferredSize = nextNode.getPreferredSize();
                Rectangle boundingBox = new Rectangle();
                boundingBox.x = nextLocation.getRoundedX() - minX + 10;
                boundingBox.y = nextLocation.getRoundedY() - minY + 10;
                boundingBox.width = nodePreferredSize.width;
                boundingBox.height = nodePreferredSize.height;
                nodeFigureToBounds.put(nextNode, boundingBox);
                requiredWidth = Math.max(boundingBox.x + nodePreferredSize.width, requiredWidth);
                requiredHeight = Math.max(boundingBox.y + nodePreferredSize.height, requiredHeight);
            }
        }
        cache.put(KEY_NODE_FIGURE_TO_BOUNDS, nodeFigureToBounds);
        LOGGER.debug("Calculate preferred size - done");
        return new Dimension(requiredWidth += 10, requiredHeight += 10);
    }

    @Override
    public void layout(int offsetX, int offsetY, List<GraphViewNodeFigure> nodes, DrawCache cache) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'layout' must not be empty";
        assert (cache != null) : "Parameter 'cache' of method 'layout' must not be null";
        Map nodeFigureToBounds = (Map)cache.get(KEY_NODE_FIGURE_TO_BOUNDS, THashMap.class);
        for (GraphViewNodeFigure nextNode : nodes) {
            Rectangle nextBounds = (Rectangle)nodeFigureToBounds.get(nextNode);
            assert (nextBounds != null) : "'nextBounds' of method 'layout' must not be null";
            nextNode.setBounds(nextBounds.translate(offsetX, offsetY));
        }
    }

    private static /* synthetic */ void lambda$0(Set set, GraphViewNodeFigure n) {
        boolean bl = set.add((GraphViewNode)n.getNode());
    }

    static final class GraphViewNodeFigureComparator
    implements Comparator<GraphViewNodeFigure> {
        private final Map<GraphViewNode, PrecisionLocation> m_nodeToLocation;

        public GraphViewNodeFigureComparator(Map<GraphViewNode, PrecisionLocation> nodeToLocation) {
            assert (nodeToLocation != null) : "Parameter 'nodeToLocation' of method 'GraphViewNodeFigureComparator' must not be null";
            this.m_nodeToLocation = nodeToLocation;
        }

        @Override
        public int compare(GraphViewNodeFigure g1, GraphViewNodeFigure g2) {
            double f2;
            PrecisionLocation g1Loc = this.m_nodeToLocation.get(g1.getNode());
            PrecisionLocation g2Loc = this.m_nodeToLocation.get(g2.getNode());
            double f1 = g1Loc.getX() / g1Loc.getY();
            if (f1 > (f2 = g2Loc.getX() / g2Loc.getY())) {
                return -1;
            }
            if (f1 < f2) {
                return 1;
            }
            return -1;
        }
    }
}

