/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.GridData;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawExpandCollapseFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawImageAndLabelFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class GraphViewNodeFigure
extends DrawNodeFigure<GraphViewNode> {
    private List<GraphViewNodeFigure> m_childNodeFigures;

    public GraphViewNodeFigure(GraphViewNode node, DrawNodeFigure.INodeFigureProvider<GraphViewNode> provider) {
        super(node);
        this.initialize(provider);
    }

    public void addChildNodeFigure(GraphViewNodeFigure childNodeFigure) {
        assert (childNodeFigure != null) : "Parameter 'childNodeFigure' of method 'addChildNodeFigure' must not be null";
        if (this.m_childNodeFigures == null) {
            this.m_childNodeFigures = new ArrayList<GraphViewNodeFigure>();
        }
        this.m_childNodeFigures.add(childNodeFigure);
    }

    public List<GraphViewNodeFigure> getChildNodeFigures() {
        return this.m_childNodeFigures == null ? Collections.emptyList() : Collections.unmodifiableList(this.m_childNodeFigures);
    }

    @Override
    protected void performInitialize(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'performInitialize' must not be null";
        this.setBackgroundColor(UiResourceManager.getInstance().getBackgroundColor());
        Image image = UiResourceManager.getInstance().getImage((Element)node);
        DrawUtilities.checkImageDimension(image, "Node '" + String.valueOf(this.getNode()) + "'");
        if (node.isExpandable()) {
            this.setLayoutManager(DrawUtilities.createGridLayout(2));
            DrawImageAndLabelFigure figure = new DrawImageAndLabelFigure(image, GraphViewUtilities.getPresentationName(node));
            figure.setForegroundColor(UiResourceManager.getInstance().getForegroundColor());
            this.add(figure);
            DrawExpandCollapseFigure expandCollapseFigure = new DrawExpandCollapseFigure(true, node.isExpanded(), 0);
            this.add(expandCollapseFigure);
            expandCollapseFigure.addMouseListener(this);
            figure.addMouseListener(this);
        } else {
            this.setLayoutManager(DrawUtilities.createGridLayout(1));
            DrawImageAndLabelFigure figure = new DrawImageAndLabelFigure(image, GraphViewUtilities.getPresentationName(node));
            figure.setForegroundColor(UiResourceManager.getInstance().getGraphNodeTextColor());
            this.add((IFigure)figure, new GridData(4, 0x1000000, true, false));
            figure.addMouseListener(this);
        }
        this.addMouseListener(this);
    }

    @Override
    protected boolean performUpdate(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'performUpdate' must not be null";
        return true;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        List<DrawFigure> figures = DrawUtilities.findChildFigures(DrawFigure.class, this);
        for (DrawFigure next : figures) {
            if (!next.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performPaintFigure(Graphics graphics, GraphViewNode node) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        assert (node != null) : "Parameter 'node' of method 'performPaintFigure' must not be null";
        boolean highlight = GraphViewUtilities.highlight(node);
        if (!node.isExpanded()) {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.fillRoundRectangle(this.bounds, 3, 3);
        }
        if (highlight) {
            if (!node.isSelected()) {
                if (GraphViewUtilities.formAtLeastOneCycleOfTwoWithAnotherSelectedNode(node)) {
                    graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.RED));
                } else {
                    graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.ORANGE));
                }
            } else {
                graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.DARK_GREY));
            }
            graphics.setLineWidth(2);
            graphics.drawRoundRectangle(this.bounds.getResized(-2, -2).getTranslated(1, 1), 3, 3);
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY));
            graphics.drawRoundRectangle(this.bounds.getResized(-1, -1), 3, 3);
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (color == null) {
            super.setBackgroundColor(UiResourceManager.getInstance().getBackgroundColor());
        } else {
            super.setBackgroundColor(color);
        }
    }

    @Override
    public String getDebugInfo() {
        return ((GraphViewNode)this.getNode()).getName() + " [" + super.getDebugInfo() + "]";
    }
}

