/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.swt.base.ColorTable;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;

public final class GraphViewColorManager {
    private static final String DIRECT_STRUCTURAL_PARENT = "Direct structural parent";
    private final List<IListener> m_listeners = new ArrayList<IListener>(2);
    private final Map<String, Pair<ArchitectureFile, Boolean>> m_parentModes = new LinkedHashMap<String, Pair<ArchitectureFile, Boolean>>();
    private final ColorTable m_colorTable = UiResourceManager.getInstance().createColorTable();
    private final Map<NamedElement, StrictPair<Color, Integer>> m_colorTableInfo = new THashMap();
    private final IArchitectureProvider m_architectureProvider;
    private Pair<ArchitectureFile, Boolean> m_useArchitectureFile;
    private String m_currentMode;
    private boolean m_isColoringEnabled;

    public GraphViewColorManager(IArchitectureProvider architectureProvider, boolean enableColoring) {
        this.m_architectureProvider = architectureProvider;
        this.m_parentModes.put(DIRECT_STRUCTURAL_PARENT, null);
        this.m_currentMode = DIRECT_STRUCTURAL_PARENT;
        this.m_isColoringEnabled = enableColoring;
    }

    private void notifyListeners(IListener listener) {
        for (IListener next : this.m_listeners) {
            if (listener == next) continue;
            next.colorsUpdated();
        }
    }

    public void addListener(IListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'addListener' must not be null";
        assert (!this.m_listeners.contains(listener)) : "'listener' already added: " + String.valueOf(listener);
        this.m_listeners.add(listener);
    }

    private NamedElement getParentForColoring(NamedElement namedElement) {
        assert (this.isColoringEnabled()) : "Not enabled";
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getParentForColoring' must not be null";
        if (this.m_useArchitectureFile == null) {
            return namedElement.getParent();
        }
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
        if (softwareSystem != null) {
            return ((IArchitectureProvider)softwareSystem.getExtension(IArchitectureProvider.class)).getParentArtifact((ArchitectureFile)this.m_useArchitectureFile.getFirst(), (Element)namedElement, ((Boolean)this.m_useArchitectureFile.getSecond()).booleanValue());
        }
        return null;
    }

    public Collection<String> getParentModes() {
        return Collections.unmodifiableSet(this.m_parentModes.keySet());
    }

    public String getCurrentParentMode() {
        return this.m_currentMode;
    }

    public Map<NamedElement, StrictPair<Color, Integer>> getColorTableInfo() {
        return this.m_colorTableInfo;
    }

    public boolean isColoringEnabled() {
        return this.m_isColoringEnabled;
    }

    public boolean enableColoring(IListener listener, boolean enable) {
        if (enable != this.m_isColoringEnabled) {
            this.m_isColoringEnabled = enable;
            if (!this.m_isColoringEnabled) {
                this.m_colorTable.clear();
                this.m_parentModes.clear();
                this.m_useArchitectureFile = null;
                this.m_parentModes.put(DIRECT_STRUCTURAL_PARENT, null);
                this.m_currentMode = DIRECT_STRUCTURAL_PARENT;
            }
            this.notifyListeners(listener);
            return true;
        }
        return false;
    }

    public boolean setParentMode(IListener listener, String mode) {
        assert (this.isColoringEnabled()) : "Not enabled";
        assert (mode != null && mode.length() > 0) : "Parameter 'mode' of method 'setParentMode' must not be empty";
        assert (this.m_parentModes.containsKey(mode)) : "Unknown mode: " + mode;
        if (!this.m_currentMode.equals(mode)) {
            this.m_useArchitectureFile = this.m_parentModes.get(mode);
            this.m_currentMode = mode;
            this.notifyListeners(listener);
            return true;
        }
        return false;
    }

    public ArchitectureFile getUsedArchitectureFile() {
        return this.m_useArchitectureFile != null ? (ArchitectureFile)this.m_useArchitectureFile.getFirst() : null;
    }

    public Map<NamedElement, Color> getElementColoring(IListener listener, List<NamedElement> elements) {
        boolean parentModesChanged;
        List checkedArchitectureFiles;
        IDomainRoot.Domain domain;
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getElementColoring' must not be empty";
        if (!this.isColoringEnabled()) {
            return Collections.emptyMap();
        }
        this.m_colorTableInfo.clear();
        LinkedHashMap<Object, Pair> parentModes = new LinkedHashMap<Object, Pair>();
        parentModes.put(DIRECT_STRUCTURAL_PARENT, null);
        if (this.m_architectureProvider != null && (domain = elements.get(0).getDomain()) != null && !(checkedArchitectureFiles = this.m_architectureProvider.getCheckedArchitectureFiles()).isEmpty()) {
            IDomainRoot.Domain nextDomain;
            for (NamedElement next : checkedArchitectureFiles) {
                nextDomain = next.getDomain();
                assert (nextDomain != null) : "'nextDomain' of method 'getParentColoring' must not be null";
                if (domain.isPhysical() != nextDomain.isPhysical()) continue;
                parentModes.put("Direct artifact parent '" + next.getIdentifyingPath() + "' [" + next.getModel().getPresentationName() + ", Checked]", new Pair((Object)next, (Object)Boolean.FALSE));
            }
            for (NamedElement next : checkedArchitectureFiles) {
                nextDomain = next.getDomain();
                assert (nextDomain != null) : "'nextDomain' of method 'getParentColoring' must not be null";
                if (domain.isPhysical() != nextDomain.isPhysical()) continue;
                parentModes.put("Top-level artifact parent '" + next.getIdentifyingPath() + "' [" + next.getModel().getPresentationName() + ", Checked]", new Pair((Object)next, (Object)Boolean.TRUE));
            }
        }
        boolean bl = parentModesChanged = !this.m_parentModes.equals(parentModes);
        if (parentModesChanged) {
            this.m_parentModes.clear();
            this.m_parentModes.putAll(parentModes);
            this.m_useArchitectureFile = null;
            this.m_currentMode = DIRECT_STRUCTURAL_PARENT;
        }
        LinkedHashMap<NamedElement, ArrayList<NamedElement>> parentToNamedElement = new LinkedHashMap<NamedElement, ArrayList<NamedElement>>();
        for (NamedElement next : elements) {
            NamedElement nextParent = this.getParentForColoring(next);
            ArrayList<NamedElement> children = (ArrayList<NamedElement>)parentToNamedElement.get(nextParent);
            if (children == null) {
                children = new ArrayList<NamedElement>();
                parentToNamedElement.put(nextParent, children);
            }
            children.add(next);
        }
        assert (parentToNamedElement != null && !parentToNamedElement.isEmpty()) : "'parentToCyclics' of method 'getColoring' must not be empty";
        List<Color> colors = this.m_colorTable.generate(parentToNamedElement.size());
        LinkedHashMap<NamedElement, Color> namedElementToColor = new LinkedHashMap<NamedElement, Color>();
        int i = 0;
        for (Map.Entry nextEntry : parentToNamedElement.entrySet()) {
            Color nextColor = colors.get(i);
            ((List)nextEntry.getValue()).forEach(c -> {
                Color color2 = namedElementToColor.put((NamedElement)c, nextColor);
            });
            this.m_colorTableInfo.put((NamedElement)nextEntry.getKey(), (StrictPair<Color, Integer>)new StrictPair((Object)nextColor, (Object)((List)nextEntry.getValue()).size()));
            ++i;
        }
        if (parentModesChanged) {
            this.notifyListeners(listener);
        }
        return namedElementToColor;
    }

    public static interface IListener {
        public void colorsUpdated();
    }
}

