/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog.feedback;

import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackComposite;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class FeedbackDialog
extends StandardDialog
implements FeedbackComposite.IListener {
    private boolean m_attachLogFile;
    private DialogFeedbackComposite m_feedbackComposite;
    private final TFile m_logFile;
    private final String m_bundleId;
    private final IProxySettingsProvider m_proxySettingsProvider;

    public FeedbackDialog(Shell parentShell, TFile logFile, String bundleId, IProxySettingsProvider proxySettingsProvider) {
        super(parentShell, "Send Feedback", 34928);
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'FeedbackDialog' must not be empty";
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'FeedbackDialog' must not be null";
        this.m_logFile = logFile;
        this.m_bundleId = bundleId;
        this.m_proxySettingsProvider = proxySettingsProvider;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        this.m_feedbackComposite = this.createFeedbackComposite(composite);
        this.m_feedbackComposite.setLayoutData(new GridData(4, 4, true, true));
    }

    protected DialogFeedbackComposite createFeedbackComposite(Composite composite) {
        return new DialogFeedbackComposite(composite, 0, this.getNumberOfColumns(), "Your feedback will be forwarded to support@hello2morrow.com. We will try to get back to you as quickly as possible.", this.m_logFile, this.m_proxySettingsProvider);
    }

    @Override
    protected int getNumberOfColumns() {
        return 2;
    }

    @Override
    protected IDialogId getDialogId() {
        return UiSwtDialogId.FEEDBACK_DIALOG;
    }

    @Override
    protected void applyData() {
        super.applyData();
    }

    @Override
    public boolean hasValidData() {
        return this.m_feedbackComposite.getConnectionMode() == ConnectionMode.ONLINE && !this.isAnyMandatoryFieldEmpty();
    }

    private boolean isAnyMandatoryFieldEmpty() {
        return this.isNullOrEmpty(this.m_feedbackComposite.getContactName()) || this.isNullOrEmpty(this.m_feedbackComposite.getEmail()) || this.isNullOrEmpty(this.m_feedbackComposite.getSubject()) || this.isNullOrEmpty(this.m_feedbackComposite.getContextInfo());
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public boolean attachLogFile() {
        return this.m_attachLogFile;
    }

    public Feedback.Salutation getSalutation() {
        return this.m_feedbackComposite.getSalutation();
    }

    public String getContactName() {
        return this.m_feedbackComposite.getContactName();
    }

    public String getEmail() {
        return this.m_feedbackComposite.getEmail();
    }

    public String getPhone() {
        return this.m_feedbackComposite.getPhone();
    }

    public String getFeedbackText() {
        return this.m_feedbackComposite.getContextInfo();
    }

    public String getSubject() {
        return this.m_feedbackComposite.getSubject();
    }

    public void setSubject(String subject) {
        assert (subject != null && subject.length() > 0) : "Parameter 'subject' of method 'setSubject' must not be empty";
        this.m_feedbackComposite.setSubject(subject);
    }

    public void setContextInfo(String contextInfo) {
        assert (contextInfo != null && contextInfo.length() > 0) : "Parameter 'contextInfo' of method 'setFeedbackText' must not be empty";
        this.m_feedbackComposite.setContextInfo(contextInfo);
    }

    @Override
    protected IEclipsePreferences saveData() {
        this.m_feedbackComposite.storeSettings();
        IEclipsePreferences settings = this.getPreferences(this.m_bundleId);
        settings.putBoolean("Feedback_Dont_Attach_Logfile", !this.attachLogFile());
        return settings;
    }

    @Override
    public void modified() {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    protected TFile getLogFile() {
        return this.m_logFile;
    }

    protected void cancelPressed() {
        if (!this.getButton(0).isEnabled() && !this.essentialInfoProvided()) {
            super.cancelPressed();
            return;
        }
        if (MessageDialog.openQuestion((Shell)this.getParentShell(), (String)"Cancel", (String)"Do you really want to cancel?\n\nAlready provided details will be lost.")) {
            super.cancelPressed();
        }
    }

    private boolean essentialInfoProvided() {
        return this.getSubject() != null && this.getSubject().length() > 0 || this.getFeedbackText() != null && this.getFeedbackText().length() > 0;
    }

    public class DialogFeedbackComposite
    extends FeedbackComposite {
        private Button m_attachLogFileCheckBox;

        public DialogFeedbackComposite(Composite parent, int style, int columns, String introText, TFile logFile, IProxySettingsProvider proxyProvider) {
            super(parent, FeedbackDialog.this, proxyProvider, style, columns, introText, logFile, true, FeedbackDialog.this.m_bundleId);
        }

        @Override
        protected boolean validateInputFields() {
            return true;
        }

        @Override
        protected void addAdditionalWidgets() {
            Label logFileLabel = new Label((Composite)this, 0);
            logFileLabel.setText("Log file: ");
            logFileLabel.setLayoutData((Object)new GridData(128, 1, false, false));
            this.m_attachLogFileCheckBox = new Button((Composite)this, 32);
            this.m_attachLogFileCheckBox.setLayoutData((Object)new GridData(1, 128, false, false));
            this.m_attachLogFileCheckBox.setText("Attach log file");
            this.m_attachLogFileCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((DialogFeedbackComposite)DialogFeedbackComposite.this).FeedbackDialog.this.m_attachLogFile = DialogFeedbackComposite.this.m_attachLogFileCheckBox.getSelection();
                }
            });
            SwtUtility.createFillerForGridLayoutCell(this);
            IEclipsePreferences settings = PreferencesUtility.getPreferences(FeedbackDialog.this.m_bundleId, FeedbackDialog.this.getDialogId());
            assert (settings != null) : "settings must not be null";
            FeedbackDialog.this.m_attachLogFile = !settings.getBoolean("Feedback_Dont_Attach_Logfile", false);
            this.m_attachLogFileCheckBox.setSelection(FeedbackDialog.this.m_attachLogFile);
            Link logFileLink = new Link((Composite)this, 0);
            GridData layoutData = new GridData(4, 128, true, false);
            layoutData.widthHint = 300;
            logFileLink.setLayoutData((Object)layoutData);
            final String logFilePath = this.getLogFile().getNormalizedAbsolutePath();
            logFileLink.setText("<a>" + logFilePath + "</a>");
            logFileLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Program.launch((String)logFilePath);
                }
            });
        }

        @Override
        protected String getContextInfoLabel() {
            return "Feedback: ";
        }
    }
}

