/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleView;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewLayout;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;

public final class SetCycleLayoutHandler
extends CommandHandler {
    public static final String COMMAND_ID = "com.hello2morrow.sonargraph.standalone.command.setCycleLayout";
    public static final String PARAM_ID_LAYOUT = "com.hello2morrow.sonargraph.standalone.command.setCycleLayout.layout";

    @CanExecute
    public final boolean canExecute(@Named(value="com.hello2morrow.sonargraph.standalone.command.setCycleLayout.layout") String layout, MPart part, MToolItem toolItem) {
        assert (layout != null) : "Parameter 'layout' of method 'canExecute' must not be null";
        assert (part != null) : "Parameter 'part' of method 'enclosing_method' must not be null";
        assert (toolItem != null) : "Parameter 'toolItem' of method 'canExecute' must not be null";
        CycleView view = RcpUtility.getWorkbenchView(part, CycleView.class);
        if (view != null && view.isActive() && view.isReady()) {
            GraphViewLayout.CycleLayout currentLayout = view.getLayout();
            switch (currentLayout) {
                case CIRCULAR: {
                    toolItem.setSelected(GraphViewLayout.CycleLayout.CIRCULAR.name().equalsIgnoreCase(layout));
                    break;
                }
                case SPRING_EMBEDDER: {
                    toolItem.setSelected(GraphViewLayout.CycleLayout.SPRING_EMBEDDER.name().equalsIgnoreCase(layout));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="com.hello2morrow.sonargraph.standalone.command.setCycleLayout.layout") String layout, MPart part) {
        assert (layout != null) : "Parameter 'layout' of method 'execute' must not be null";
        assert (part != null) : "Parameter 'part' of method 'execute' must not be null";
        CycleView view = RcpUtility.getWorkbenchView(part, CycleView.class);
        assert (view != null) : "'view' of method 'execute' must not be null";
        if (GraphViewLayout.CycleLayout.CIRCULAR.name().equalsIgnoreCase(layout)) {
            view.setLayout(GraphViewLayout.CycleLayout.CIRCULAR);
        } else if (GraphViewLayout.CycleLayout.SPRING_EMBEDDER.name().equalsIgnoreCase(layout)) {
            view.setLayout(GraphViewLayout.CycleLayout.SPRING_EMBEDDER);
        } else assert (false) : "Unhandled layout: " + layout;
    }
}

