/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

final class CycleViewFillLayout
extends Layout {
    CycleViewFillLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        assert (composite != null) : "Parameter 'composite' of method 'computeSize' must not be null";
        Control[] children = composite.getChildren();
        int count = children.length;
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            int w = wHint;
            int h = hHint;
            if (count > 0) {
                if (wHint != -1) {
                    w = Math.max(0, wHint);
                }
                if (hHint != -1) {
                    h = Math.max(0, hHint);
                }
            }
            Point size = this.computeChildSize(child, w, h, flushCache);
            maxWidth = Math.max(maxWidth, size.x);
            maxHeight = Math.max(maxHeight, size.y);
            ++i;
        }
        return new Point(maxWidth, maxHeight);
    }

    Point computeChildSize(Control control, int wHint, int hHint, boolean flushCache) {
        Data fillData;
        assert (control != null) : "Parameter 'control' of method 'computeChildSize' must not be null";
        Object data = control.getLayoutData();
        if (data instanceof Data) {
            fillData = (Data)data;
        } else {
            fillData = new Data();
            if (data == null) {
                control.setLayoutData((Object)fillData);
            }
        }
        Point size = null;
        if (wHint == -1 && hHint == -1) {
            size = fillData.computeSize(control, wHint, hHint, flushCache);
        } else {
            int trimY;
            int trimX;
            if (control instanceof Scrollable) {
                Rectangle rect = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                trimX = rect.width;
                trimY = rect.height;
            } else {
                trimX = trimY = control.getBorderWidth() * 2;
            }
            int w = wHint == -1 ? wHint : Math.max(0, wHint - trimX);
            int h = hHint == -1 ? hHint : Math.max(0, hHint - trimY);
            size = fillData.computeSize(control, w, h, flushCache);
        }
        return size;
    }

    protected boolean flushCache(Control control) {
        Object data = control.getLayoutData();
        if (data instanceof Data) {
            ((Data)data).flushCache();
            return true;
        }
        return false;
    }

    protected void layout(Composite composite, boolean flushCache) {
        assert (composite != null) : "Parameter 'composite' of method 'layout' must not be null";
        Rectangle rect = composite.getClientArea();
        Control[] children = composite.getChildren();
        int count = children.length;
        if (count == 0) {
            return;
        }
        int i = 0;
        while (i < count) {
            Control child = children[i];
            if (child.isVisible()) {
                child.setBounds(rect.x, rect.y, rect.width, rect.height);
            } else {
                child.setBounds(rect.x, rect.y, 0, 0);
            }
            ++i;
        }
    }

    private static final class Data {
        private int m_defaultWidth = -1;
        private int m_defaultHeight = -1;
        private int m_currentWhint;
        private int m_currentHhint;
        private int m_currentWidth = -1;
        private int m_currentHeight = -1;

        Data() {
        }

        Point computeSize(Control control, int wHint, int hHint, boolean flushCache) {
            assert (control != null) : "Parameter 'control' of method 'computeSize' must not be null";
            if (flushCache) {
                this.flushCache();
            }
            if (wHint == -1 && hHint == -1) {
                if (this.m_defaultWidth == -1 || this.m_defaultHeight == -1) {
                    Point size = control.computeSize(wHint, hHint, flushCache);
                    this.m_defaultWidth = size.x;
                    this.m_defaultHeight = size.y;
                }
                return new Point(this.m_defaultWidth, this.m_defaultHeight);
            }
            if (this.m_currentWidth == -1 || this.m_currentHeight == -1 || wHint != this.m_currentWhint || hHint != this.m_currentHhint) {
                Point size = control.computeSize(wHint, hHint, flushCache);
                this.m_currentWhint = wHint;
                this.m_currentHhint = hHint;
                this.m_currentWidth = size.x;
                this.m_currentHeight = size.y;
            }
            return new Point(this.m_currentWidth, this.m_currentHeight);
        }

        void flushCache() {
            this.m_defaultHeight = -1;
            this.m_defaultWidth = -1;
            this.m_currentHeight = -1;
            this.m_currentWidth = -1;
        }
    }
}

