/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithTree;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;

public abstract class TreeViewerBasedView
extends WorkbenchSlaveView
implements ITreeViewerListener,
ISelectionChangedListener,
IViewWithTree {
    @Override
    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected abstract TreeViewer getTreeViewer();

    @Override
    public abstract IViewId getViewId();

    @Override
    public final List<Control> getControlsForInteraction() {
        return new ArrayList<Control>(Arrays.asList(this.getTreeViewer().getControl()));
    }

    protected final void addListeners() {
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getTreeViewer().addTreeListener((ITreeViewerListener)this);
    }

    protected final void removeListeners() {
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getTreeViewer().removeTreeListener((ITreeViewerListener)this);
    }

    public final void treeCollapsed(TreeExpansionEvent event) {
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_COLLAPSED);
        TreeBasedViewNavigationStateUtility.createViewState(state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), this.getTreeViewer(), event, TreeBasedViewNavigationStateUtility.TreeOperation.COLLAPSE);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public final void treeExpanded(TreeExpansionEvent event) {
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_EXPANDED);
        TreeBasedViewNavigationStateUtility.createViewState(state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), this.getTreeViewer(), event, TreeBasedViewNavigationStateUtility.TreeOperation.EXPAND);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    @Override
    public final void collapseAll() {
        this.getTreeViewer().collapseAll();
        this.treeCollapsed(null);
    }

    @Override
    public final void expandAll() {
        this.getTreeViewer().expandAll();
        this.treeExpanded(null);
    }

    @Override
    protected final void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        TreeBasedViewNavigationStateUtility.createViewState(state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), this.getTreeViewer());
        ViewNavigationManager.getInstance().addNavigationState(state);
        IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
        this.getSelectionProviderAdapter().handleSelectionChanged(structuredSelection);
    }

    @Override
    public final void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        this.getTreeViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    protected final void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.removeListeners();
        this.getTreeViewer().getTree().setRedraw(false);
        TreeBasedViewNavigationStateUtility.restoreViewState(this.getTreeViewer(), state, this.getElementResolver());
        this.getTreeViewer().getTree().setRedraw(true);
        this.addListeners();
    }

    @Override
    public final void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationStateForFocusGained' must not be null";
        TreeBasedViewNavigationStateUtility.createViewState(state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), this.getTreeViewer());
    }
}

