/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ResolutionViewShowInViewSupport
extends SupportsShowInView {
    ResolutionViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    @Override
    public final ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        List<Element> relevantElements;
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        if (WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED) && !(relevantElements = this.getElementsForShowInView(selectedElements)).isEmpty()) {
            return new ShowInView(new ShowInViewNode(relevantElements, this.getViewPresentationName(), this.getImageName(), true));
        }
        return null;
    }

    private List<Element> getElementsForShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getRelevantElements' must not be null";
        IIssueProvider issueProvider = (IIssueProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IIssueProvider.class);
        if (elements.stream().anyMatch(e -> e instanceof IDiffElement)) {
            List<Element> currentResolutions = this.getCurrentResolutionsFromDiffElements(elements);
            return issueProvider.getShowInViewElementsForResolutionBasedView(currentResolutions, this.getRelevantClassForShowInView());
        }
        return issueProvider.getShowInViewElementsForResolutionBasedView(elements, this.getRelevantClassForShowInView());
    }

    protected final List<Element> getCurrentResolutionsFromDiffElements(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getCurrentResolutionsFromDiffElements' must not be null";
        return elements.stream().filter(e -> e instanceof IDiffElement).map(e -> ((IDiffElement)e).getCurrentElement()).filter(e -> e != null).collect(Collectors.toList());
    }

    protected abstract Class<? extends Resolution> getRelevantClassForShowInView();
}

