/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableSorter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class PagingPropertyTableViewer<T>
extends PropertyTableViewer<T> {
    public static final int DEFAULT_PAGE_SIZE = 1000;
    private final List<ViewerFilter> m_filters = new ArrayList<ViewerFilter>();
    private final int m_pageSize;
    private boolean m_initInput = true;
    private Collection<? extends T> m_unfilteredInput;
    private List<T> m_filteredInput;
    private int m_numberOfPages;
    private int m_currentPage;
    private Composite m_pagerControls;
    private Composite m_pagerInfo;
    private Button m_jumpToBegin;
    private Button m_backward;
    private Button m_forward;
    private Button m_jumpToEnd;
    private Label m_index;
    private Label m_count;

    public PagingPropertyTableViewer(Composite composite, BeanPropertyReader.BeanAdapter<T> adapter, String defaultSortProperty, boolean ascending, PropertyTableViewer.SelectionType selectionType, int maxEntriesPerPage, boolean autoAdjustColumnSize) {
        super(composite, new BeanPropertyReader(adapter), selectionType, (StrictPair<String, Boolean>)(defaultSortProperty != null ? new StrictPair((Object)defaultSortProperty, (Object)ascending) : null), 0, autoAdjustColumnSize);
        assert (maxEntriesPerPage > 0) : "Invalid 'maxEntriesPerPage': " + maxEntriesPerPage;
        this.m_pageSize = maxEntriesPerPage;
        this.enableSort(false);
    }

    public PagingPropertyTableViewer(Composite composite, BeanPropertyReader.BeanAdapter<T> adapter, String defaultSortProperty, boolean ascending, PropertyTableViewer.SelectionType selectionType, int maxEntriesPerPage) {
        super(composite, adapter, defaultSortProperty, ascending, selectionType);
        assert (maxEntriesPerPage > 0) : "Invalid 'maxEntriesPerPage': " + maxEntriesPerPage;
        this.m_pageSize = maxEntriesPerPage;
        this.enableSort(false);
    }

    public PagingPropertyTableViewer(Composite composite, BeanPropertyReader.BeanAdapter<T> adapter, String defaultSortProperty, boolean ascending, PropertyTableViewer.SelectionType selectionType) {
        this(composite, adapter, defaultSortProperty, ascending, selectionType, 1000);
    }

    @Override
    public boolean isFiltered() {
        if ((this.m_unfilteredInput == null || this.m_unfilteredInput.isEmpty()) && (this.m_filteredInput == null || this.m_filteredInput.isEmpty())) {
            return false;
        }
        assert (this.m_unfilteredInput != null || this.m_filteredInput == null) : "If unfiltered input is null, filteredInput must not be != null";
        if (this.m_unfilteredInput != null && this.m_filteredInput == null) {
            return true;
        }
        return this.m_unfilteredInput.size() > this.m_filteredInput.size();
    }

    private void setFilteredInput(PropertyTableSorter<T> sorter, Collection<? extends T> filteredInput) {
        if (filteredInput == null) {
            this.m_filteredInput = null;
            this.m_numberOfPages = 0;
        } else {
            this.m_filteredInput = new ArrayList<T>(filteredInput);
            if (!this.m_filteredInput.isEmpty() && sorter != null) {
                Collections.sort(this.m_filteredInput, new PagingComparator(sorter));
            }
            if (this.m_filteredInput.isEmpty()) {
                this.m_numberOfPages = 0;
            } else if (this.m_filteredInput.size() > this.m_pageSize) {
                if (this.m_filteredInput.size() % this.m_pageSize == 0) {
                    this.m_numberOfPages = this.m_filteredInput.size() / this.m_pageSize;
                } else {
                    this.m_numberOfPages = this.m_filteredInput.size() / this.m_pageSize;
                    ++this.m_numberOfPages;
                }
            } else {
                this.m_numberOfPages = 1;
            }
        }
        this.m_currentPage = 0;
    }

    private boolean isJumpToBeginPossible() {
        return this.m_numberOfPages > 0 && this.m_currentPage != 0;
    }

    private boolean isBackwardPossible() {
        return this.m_numberOfPages > 0 && this.m_currentPage > 0;
    }

    private boolean isForwardPossible() {
        return this.m_numberOfPages > 0 && this.m_currentPage + 1 < this.m_numberOfPages;
    }

    private boolean isJumpToEndPossible() {
        return this.m_numberOfPages > 0 && this.m_currentPage + 1 < this.m_numberOfPages;
    }

    private void jumpToBegin() {
        assert (this.isJumpToBeginPossible()) : "Jump to begin not possible";
        this.m_currentPage = 0;
    }

    private void backward() {
        assert (this.isBackwardPossible()) : "Backward not possible";
        --this.m_currentPage;
    }

    private void forward() {
        assert (this.isForwardPossible()) : "Forward not possible";
        ++this.m_currentPage;
    }

    private void jumpToEnd() {
        assert (this.isJumpToEndPossible()) : "Jump to end not possible";
        this.m_currentPage = this.m_numberOfPages - 1;
    }

    private void jumpToFirstPageOfElements(List<T> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getFirstPageOfElements' must not be null";
        if (this.m_numberOfPages == 0) {
            return;
        }
        if (this.m_numberOfPages == 1) {
            return;
        }
        assert (this.m_filteredInput != null) : "'m_filteredInput' must not be null";
        THashSet elementsToFind = new THashSet(elements);
        int p = 0;
        while (p < this.m_numberOfPages) {
            int from = p * this.m_pageSize;
            int to = p + 1 < this.m_numberOfPages ? from + this.m_pageSize : this.m_filteredInput.size();
            boolean matchFound = false;
            ArrayList<T> page = new ArrayList<T>(to - from);
            int i = from;
            while (i < to) {
                T element = this.m_filteredInput.get(i);
                page.add(element);
                if (!matchFound && elementsToFind.contains(element)) {
                    matchFound = true;
                }
                ++i;
            }
            if (matchFound) {
                this.m_currentPage = p;
                return;
            }
            ++p;
        }
    }

    private List<T> getCurrentPage() {
        if (this.m_numberOfPages == 0) {
            return Collections.emptyList();
        }
        List<T> page = null;
        assert (this.m_filteredInput != null) : "'m_Input' must not be null";
        int from = this.m_currentPage * this.m_pageSize;
        int to = this.m_currentPage + 1 < this.m_numberOfPages ? from + this.m_pageSize : this.m_filteredInput.size();
        page = this.m_filteredInput.subList(from, to);
        return page;
    }

    private Collection<T> getUnfilteredInput() {
        return this.m_unfilteredInput == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.m_unfilteredInput);
    }

    @Override
    protected int getItemCount() {
        return this.m_filteredInput != null ? this.m_filteredInput.size() : 0;
    }

    private void removePagerControls() {
        assert (this.m_pagerControls != null) : "'m_pagerControls' of method 'removePagerControls' must not be null";
        this.m_pagerControls.dispose();
        this.m_pagerControls = null;
        this.m_pagerInfo = null;
        this.m_jumpToBegin = null;
        this.m_backward = null;
        this.m_forward = null;
        this.m_jumpToEnd = null;
        this.m_index = null;
        this.m_count = null;
    }

    private void addPagerControls() {
        assert (this.m_pagerControls == null) : "'m_pagerControls' of method 'addPagerControls' must be null";
        this.m_pagerControls = new Composite((Composite)this, 0);
        this.m_pagerControls.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout gridLayoutPagerControls = new GridLayout(5, false);
        if (Platform.isMac()) {
            PagingPropertyTableViewer.reset(gridLayoutPagerControls);
        } else {
            gridLayoutPagerControls.horizontalSpacing = 2;
            gridLayoutPagerControls.marginBottom = 2;
            gridLayoutPagerControls.marginHeight = 0;
            gridLayoutPagerControls.marginLeft = 2;
            gridLayoutPagerControls.marginRight = 2;
            gridLayoutPagerControls.marginTop = 2;
            gridLayoutPagerControls.marginWidth = 0;
            gridLayoutPagerControls.verticalSpacing = 2;
        }
        this.m_pagerControls.setLayout((Layout)gridLayoutPagerControls);
        Label separator = new Label(this.m_pagerControls, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false, 5, 1));
        this.m_jumpToBegin = new Button(this.m_pagerControls, 8);
        this.m_jumpToBegin.setImage(UiResourceManager.getInstance().getImage("ArrowTopLeft"));
        this.m_jumpToBegin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagingPropertyTableViewer.this.jumpToBegin();
                PagingPropertyTableViewer.this.m_initInput = false;
                PagingPropertyTableViewer.this.showData(null);
                PagingPropertyTableViewer.this.m_initInput = true;
            }
        });
        this.m_jumpToBegin.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.m_backward = new Button(this.m_pagerControls, 8);
        this.m_backward.setImage(UiResourceManager.getInstance().getImage("ArrowLeft"));
        this.m_backward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagingPropertyTableViewer.this.backward();
                PagingPropertyTableViewer.this.m_initInput = false;
                PagingPropertyTableViewer.this.showData(null);
                PagingPropertyTableViewer.this.m_initInput = true;
            }
        });
        this.m_backward.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_pagerInfo = new Composite(this.m_pagerControls, 0);
        this.m_pagerInfo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        GridLayout gridLayoutPagerInfo = new GridLayout(3, false);
        if (Platform.isMac()) {
            PagingPropertyTableViewer.reset(gridLayoutPagerInfo);
        } else {
            gridLayoutPagerInfo.horizontalSpacing = 1;
            gridLayoutPagerInfo.marginBottom = 0;
            gridLayoutPagerInfo.marginHeight = 0;
            gridLayoutPagerInfo.marginLeft = 2;
            gridLayoutPagerInfo.marginRight = 0;
            gridLayoutPagerInfo.marginTop = 0;
            gridLayoutPagerInfo.marginWidth = 0;
            gridLayoutPagerInfo.verticalSpacing = 0;
        }
        this.m_pagerInfo.setLayout((Layout)gridLayoutPagerInfo);
        this.m_index = new Label(this.m_pagerInfo, 0x1000000);
        this.m_index.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        Label of = new Label(this.m_pagerInfo, 0x1000000);
        of.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        of.setText("/");
        this.m_count = new Label(this.m_pagerInfo, 0x1000000);
        this.m_count.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.m_forward = new Button(this.m_pagerControls, 8);
        this.m_forward.setImage(UiResourceManager.getInstance().getImage("ArrowRight"));
        this.m_forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagingPropertyTableViewer.this.forward();
                PagingPropertyTableViewer.this.m_initInput = false;
                PagingPropertyTableViewer.this.showData(null);
                PagingPropertyTableViewer.this.m_initInput = true;
            }
        });
        this.m_forward.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_jumpToEnd = new Button(this.m_pagerControls, 8);
        this.m_jumpToEnd.setImage(UiResourceManager.getInstance().getImage("ArrowBottomRight"));
        this.m_jumpToEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagingPropertyTableViewer.this.jumpToEnd();
                PagingPropertyTableViewer.this.m_initInput = false;
                PagingPropertyTableViewer.this.showData(null);
                PagingPropertyTableViewer.this.m_initInput = true;
            }
        });
        this.m_jumpToEnd.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    @Override
    public void resetFilters() {
        this.setFilters(new ViewerFilter[0]);
    }

    @Override
    public void select(List<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        this.setRedraw(false);
        this.jumpToFirstPageOfElements(elements);
        this.m_initInput = false;
        this.showData(null);
        this.m_initInput = true;
        super.select(elements);
        this.updatePagerControls();
        this.setRedraw(true);
    }

    @Override
    public void setFilters(ViewerFilter[] filters) {
        assert (filters != null) : "Parameter 'filters' of method 'setFilters' must not be null";
        this.m_filters.clear();
        ViewerFilter[] viewerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter next = viewerFilterArray[n2];
            this.m_filters.add(next);
            ++n2;
        }
        this.setFilteredInput(this.getSorter().hasSortCriteria() ? this.getSorter() : null, this.getVisibleElements(this.getUnfilteredInput()));
        this.m_initInput = false;
        this.showData(null);
        this.m_initInput = true;
        this.setFilterBackground();
    }

    @Override
    public ViewerFilter[] getFilters() {
        return this.m_filters.toArray(new ViewerFilter[0]);
    }

    @Override
    protected Collection<T> getProcessedInput(Collection<? extends T> input) {
        if (this.m_initInput) {
            this.m_unfilteredInput = input;
            this.setFilteredInput(null, this.getVisibleElements(input));
        }
        List<T> data = this.getCurrentPage();
        this.setRedraw(false);
        this.updatePagerControls();
        this.setRedraw(true);
        return data;
    }

    private void updatePagerControls() {
        if (this.m_numberOfPages <= 1) {
            if (this.m_pagerControls != null) {
                this.removePagerControls();
            }
        } else {
            if (this.m_pagerControls == null) {
                this.addPagerControls();
            }
            this.m_jumpToBegin.setEnabled(this.isJumpToBeginPossible());
            this.m_backward.setEnabled(this.isBackwardPossible());
            this.m_forward.setEnabled(this.isForwardPossible());
            this.m_jumpToEnd.setEnabled(this.isJumpToEndPossible());
            this.m_index.setText(NumberUtility.format((Number)(this.m_currentPage + 1)));
            this.m_count.setText(NumberUtility.format((Number)this.m_numberOfPages));
            this.m_pagerInfo.layout(true);
            this.m_pagerControls.layout(true);
        }
        this.layout(true);
    }

    @Override
    protected void sortPropertyChanged(String propertyName) {
        assert (propertyName != null) : "Parameter 'propertyName' of method 'sortPropertyChanged' must not be null";
        this.setFilteredInput(this.getSorter().hasSortCriteria() ? this.getSorter() : null, this.m_filteredInput);
        this.m_initInput = false;
        this.showData(null);
        this.m_initInput = true;
    }

    @Override
    public Collection<T> getInputData() {
        return this.getUnfilteredInput();
    }

    @Override
    public Collection<T> getFilteredInputData() {
        return this.m_filteredInput == null ? Collections.emptyList() : Collections.unmodifiableList(this.m_filteredInput);
    }

    @Override
    public boolean hasInputData() {
        return this.m_unfilteredInput != null && !this.m_unfilteredInput.isEmpty();
    }

    final class PagingComparator
    implements Comparator<T> {
        private final PropertyTableSorter<T> m_sorter;

        PagingComparator(PropertyTableSorter<T> sorter) {
            assert (sorter != null) : "'sorter' must not be null";
            this.m_sorter = sorter;
        }

        @Override
        public int compare(T one, T two) {
            int categoryTwo;
            int categoryOne = this.m_sorter.category(one);
            if (categoryOne != (categoryTwo = this.m_sorter.category(two))) {
                return categoryOne - categoryTwo;
            }
            return this.m_sorter.compare(null, one, two);
        }
    }
}

