/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchMasterView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IViewContentExclusionFilter;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkSelectionListener
implements WorkbenchRegistry.ILinkSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkSelectionListener.class);

    private boolean isFiltered(ViewId viewId, SupportsShowInView supportsShowInView, NamedElement element) {
        assert (viewId != null) : "Parameter 'viewId' of method 'isFiltered' must not be null";
        assert (supportsShowInView != null) : "Parameter 'supportsShowInView' of method 'isFiltered' must not be null";
        assert (element != null) : "Parameter 'element' of method 'isFiltered' must not be null";
        IViewContentExclusionFilter viewContentFilter = supportsShowInView.getFilter();
        if (viewContentFilter != null && viewContentFilter.match((Element)element)) {
            return true;
        }
        for (IViewContentExclusionFilter nextViewContentFilter : WorkbenchRegistry.getInstance().getViewContentFilters(viewId)) {
            if (!nextViewContentFilter.match((Element)element)) continue;
            return true;
        }
        return false;
    }

    @Inject
    public final void selectionChanged(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (selection != null) {
            IWorkbenchView workbenchView = selection.getWorkbenchView();
            MPart partForSelected = workbenchView.getPart();
            MElementContainer parentForSelected = partForSelected != null ? partForSelected.getParent() : null;
            List<Element> elements = selection.getElements();
            if (elements.size() == 1 && workbenchView instanceof WorkbenchSlaveView && WorkbenchRegistry.hasInstance() && WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) {
                MPart part;
                NamedElement namedElement = ((WorkbenchSlaveView)workbenchView).getLinkNamedElement(elements.get(0));
                if (namedElement == null || namedElement.getParent(Root.class, new Class[0]) == null) {
                    return;
                }
                IDialogId handlingMasterViewId = null;
                ViewId[] viewIdArray = ViewId.values();
                int n = viewIdArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SupportsShowInView nextSupportsShowInView;
                    ViewId nextViewId = viewIdArray[n2];
                    if (nextViewId.hasProperty(IViewId.Property.IS_MASTER_VIEW) && (nextSupportsShowInView = nextViewId.getSupportsShowInView(null)) != null && nextSupportsShowInView.handlesLinkFor(namedElement) && !this.isFiltered(nextViewId, nextSupportsShowInView, namedElement)) {
                        if (handlingMasterViewId == null) {
                            handlingMasterViewId = nextViewId;
                        } else {
                            LOGGER.warn("'" + String.valueOf(nextViewId) + "' wants to handle selection - but already handled by '" + String.valueOf(handlingMasterViewId) + "' - selected: " + namedElement.getName());
                        }
                    }
                    ++n2;
                }
                if (handlingMasterViewId != null && (part = workbenchView.getPartService().findPart(handlingMasterViewId.getId())) != null) {
                    MElementContainer parentForMasterView = part.getParent();
                    IWorkbenchView handlingView = RcpUtility.getWorkbenchView(part, IWorkbenchView.class);
                    if (WorkbenchMasterView.link() && handlingView == null) {
                        handlingView = RcpUtility.createView(workbenchView.getEclipseContext(), workbenchView.getPartService(), (IViewId)handlingMasterViewId);
                    }
                    if (handlingView != null && handlingView instanceof WorkbenchMasterView) {
                        WorkbenchMasterView handlingMasterView = (WorkbenchMasterView)handlingView;
                        NavigationState newViewState = ViewNavigationManager.getInstance().createNavigationState(handlingMasterView.getViewId(), handlingMasterView.getSecondaryId(), NavigationState.Type.LINK);
                        newViewState.addElementsInformation(ElementGroup.SELECTION, NavigationState.getDescriptors(Arrays.asList(namedElement), handlingMasterView.getElementResolver()));
                        handlingMasterView.setLastStateFromSlaveView(newViewState);
                        WorkbenchMasterView.setLastStateFromSlaveViewReceivedFor(handlingMasterView);
                        if (WorkbenchMasterView.link() && parentForSelected != parentForMasterView) {
                            StructuredSelection structuredSelection = new StructuredSelection((Object)namedElement);
                            MPart handlingMasterViewPart = handlingMasterView.getPart();
                            if (!handlingMasterView.getPartService().isPartVisible(handlingMasterViewPart)) {
                                RcpUtility.activateView(workbenchView.getEclipseContext(), workbenchView.getPartService(), (IViewId)handlingMasterViewId);
                            }
                            handlingMasterView.selectAndReveal(structuredSelection);
                        }
                    }
                }
            }
        }
    }
}

