/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.ComponentCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ExplorationViewShowInViewRequest;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExplorationViewShowInViewSupport
extends SupportsShowInView {
    public ExplorationViewShowInViewSupport(String viewPresentationName, String imageName) {
        super(viewPresentationName, imageName);
    }

    private ShowInViewNode createChildNode(IArchitecturalViewProvider provider, ExplorationViewShowInViewRequest.Type type, ExplorationViewOnDemand primaryOnDemand, String label, int index, boolean addSeparator, ExplorationViewOnDemand ... additionalOnDemand) {
        assert (provider != null) : "Parameter 'provider' of method 'createChildNode' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createChildNode' must not be null";
        assert (primaryOnDemand != null) : "Parameter 'onDemand' of method 'createChildNode' must not be null";
        assert (label != null && label.length() > 0) : "Parameter 'label' of method 'createChildNode' must not be empty";
        assert (additionalOnDemand != null) : "Parameter 'additionalOnDemand' of method 'createChildNode' must not be null";
        ExplorationViewFocusProperties focusProperties = null;
        if (type.useFocusProperties()) {
            focusProperties = provider.createOnDemandFocusProperties();
            ExplorationViewFocusProperties.NodeInclusionMode mode = type.getNodeInclusionMode();
            if (mode != null) {
                focusProperties.setNodeInclusionMode(mode);
            }
        }
        ExplorationViewShowInViewRequest request = new ExplorationViewShowInViewRequest(type, focusProperties, primaryOnDemand);
        ExplorationViewOnDemand[] explorationViewOnDemandArray = additionalOnDemand;
        int n = additionalOnDemand.length;
        int n2 = 0;
        while (n2 < n) {
            ExplorationViewOnDemand next = explorationViewOnDemandArray[n2];
            request.addOnDemand(next);
            ++n2;
        }
        ShowInViewNode childNode = new ShowInViewNode(Collections.singletonList(primaryOnDemand), label, type.getImageResourceName(), this.getSecondaryId(primaryOnDemand.getId()), index >= 0 ? Integer.toString(index) : null);
        childNode.addOption(request);
        childNode.setAddSeparatorAfter(addSeparator);
        return childNode;
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
        if (softwareSystem == null) {
            return null;
        }
        if (CommandRegistry.getInstance().isCommandLicensed((ICommandId)CoreCommandId.LOAD_ARCHITECTURAL_VIEW) && selectedElements.size() == 1 && selectedElements.get(0) instanceof ArchitecturalViewFile) {
            ArchitecturalViewFile architecturalViewFile = (ArchitecturalViewFile)selectedElements.get(0);
            if (((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).isLoadable(architecturalViewFile)) {
                ExplorationViewShowInViewRequest showInViewRequest = new ExplorationViewShowInViewRequest(ExplorationViewShowInViewRequest.Type.ARCHITECTURAL_VIEW, null, null);
                ShowInViewNode rootNode = new ShowInViewNode(Collections.singletonList(architecturalViewFile), "Show In Architectural View", showInViewRequest.getImageResourceName(), false, this.getSecondaryId(architecturalViewFile.getName()));
                rootNode.addOption(showInViewRequest);
                return new ShowInView(rootNode);
            }
        }
        if (CommandRegistry.getInstance().isCommandLicensed((ICommandId)CoreCommandId.LOAD_EXPLORATION_VIEW) && !selectedElements.isEmpty()) {
            IArchitecturalViewProvider provider = (IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class);
            if (selectedElements.size() == 1 && selectedElements.get(0) instanceof ArchitectureFile) {
                List onDemand = ((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).isLoadable(selectedElements);
                if (!onDemand.isEmpty()) {
                    assert (onDemand.size() == 1) : "Only 1 onDemand expected";
                    return new ShowInView(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_ARCHITECTURE_FILE, (ExplorationViewOnDemand)onDemand.get(0), "Show in Exploration View", -1, false, new ExplorationViewOnDemand[0]));
                }
            } else {
                if (selectedElements.size() == 1 && selectedElements.get(0) instanceof AnalyzerCycleGroup) {
                    return this.createShowInViewForCycle(softwareSystem, provider, (AnalyzerCycleGroup)selectedElements.get(0));
                }
                if (selectedElements.size() == 1 && selectedElements.get(0) instanceof GraphViewCycleGroupNode) {
                    AnalyzerCycleGroup analyzerCycleGroup = ((GraphViewCycleGroupNode)selectedElements.get(0)).getBasedOn();
                    return analyzerCycleGroup != null ? this.createShowInViewForCycle(softwareSystem, provider, analyzerCycleGroup) : null;
                }
                if (selectedElements.size() == 1 && selectedElements.get(0) instanceof CycleGroupIssue) {
                    return this.createShowInViewForCycle(softwareSystem, provider, ((CycleGroupIssue)selectedElements.get(0)).getAffectedElement());
                }
                if (selectedElements.size() == 1 && selectedElements.get(0) instanceof CycleGroupIssueDiff) {
                    CycleGroupIssue issue = (CycleGroupIssue)((CycleGroupIssueDiff)selectedElements.get(0)).getCurrent();
                    return issue == null ? null : this.createShowInViewForCycle(softwareSystem, provider, issue.getAffectedElement());
                }
                List onDemand = ((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).isLoadable(selectedElements);
                if (!onDemand.isEmpty()) {
                    ExplorationViewOnDemand primaryOnDemand = (ExplorationViewOnDemand)onDemand.get(0);
                    if (!primaryOnDemand.getFocusParserDependencies().isEmpty()) {
                        if (onDemand.size() == 1) {
                            return new ShowInView(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND, (ExplorationViewOnDemand)onDemand.get(0), "Show in Exploration View", -1, false, new ExplorationViewOnDemand[0]));
                        }
                        ShowInViewNode rootNode = new ShowInViewNode("Show in Exploration View", "ExplorationView");
                        int i = 0;
                        for (ExplorationViewOnDemand nextOnDemand : onDemand) {
                            String nextLabel = nextOnDemand.getStructureMode().getPresentationName();
                            rootNode.addChild(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND, nextOnDemand, nextLabel, i, false, new ExplorationViewOnDemand[0]));
                            ++i;
                        }
                        return new ShowInView(rootNode);
                    }
                    ShowInViewNode rootNode = new ShowInViewNode("Show in Exploration View", "ExplorationView");
                    rootNode.addChild(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_SELECT_AND_REVEAL, primaryOnDemand, "Select and Reveal", 0, true, new ExplorationViewOnDemand[0]));
                    rootNode.addChild(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_NO_ADDITIONAL, primaryOnDemand, "No Additional", 1, false, new ExplorationViewOnDemand[0]));
                    rootNode.addChild(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_IN_AND_OUT, primaryOnDemand, "In and Out", 2, false, new ExplorationViewOnDemand[0]));
                    rootNode.addChild(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_IN, primaryOnDemand, "In", 3, false, new ExplorationViewOnDemand[0]));
                    rootNode.addChild(this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_OUT, primaryOnDemand, "Out", 4, true, new ExplorationViewOnDemand[0]));
                    ShowInViewNode advancedNode = onDemand.size() == 2 ? this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_ADVANCED, primaryOnDemand, "Advanced...", 5, false, (ExplorationViewOnDemand)onDemand.get(1)) : this.createChildNode(provider, ExplorationViewShowInViewRequest.Type.ON_DEMAND_ADVANCED, primaryOnDemand, "Advanced...", 5, false, new ExplorationViewOnDemand[0]);
                    rootNode.addChild(advancedNode);
                    return new ShowInView(rootNode);
                }
            }
        }
        return null;
    }

    private ShowInView createShowInViewForCycle(SoftwareSystem softwareSystem, IArchitecturalViewProvider provider, AnalyzerCycleGroup cycleGroup) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createShowInViewForCycle' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'createShowInViewForCycle' must not be null";
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'createShowInViewForCycle' must not be null";
        LinkedHashMap<Object, ExplorationViewOnDemand> onDemands = new LinkedHashMap<Object, ExplorationViewOnDemand>();
        ExplorationViewOnDemand onDemandDefault = provider.isLoadable(cycleGroup, null);
        if (onDemandDefault != null) {
            onDemands.put("Show in Exploration View", onDemandDefault);
        }
        for (ArchitectureFile next : ((IArchitectureProvider)softwareSystem.getExtension(IArchitectureProvider.class)).getCheckedArchitectureFiles()) {
            ExplorationViewOnDemand nextOnDemand = provider.isLoadable(cycleGroup, next);
            if (nextOnDemand == null) continue;
            onDemands.put("Show in Exploration View (" + next.getIdentifyingPath() + (next.getDomain().isPhysical() ? " <physical>" : " <logical>") + ")", nextOnDemand);
        }
        if (!onDemands.isEmpty()) {
            ExplorationViewShowInViewRequest.Type type;
            ExplorationViewShowInViewRequest.Type type2 = type = cycleGroup instanceof ComponentCycleGroup ? ExplorationViewShowInViewRequest.Type.ON_DEMAND_CYCLE_NONE : ExplorationViewShowInViewRequest.Type.ON_DEMAND_CYCLE_FLAT;
            if (onDemands.size() == 1) {
                Map.Entry entry = onDemands.entrySet().iterator().next();
                return new ShowInView(this.createChildNode(provider, type, (ExplorationViewOnDemand)entry.getValue(), (String)entry.getKey(), -1, false, new ExplorationViewOnDemand[0]));
            }
            ShowInViewNode menu = new ShowInViewNode("Show in Exploration View", type.getImageResourceName());
            ShowInView showInView = new ShowInView(menu);
            int index = 1;
            for (Map.Entry nextEntry : onDemands.entrySet()) {
                menu.addChild(this.createChildNode(provider, type, (ExplorationViewOnDemand)nextEntry.getValue(), (String)nextEntry.getKey(), index, false, new ExplorationViewOnDemand[0]));
                ++index;
            }
            return showInView;
        }
        return null;
    }
}

