/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuInteractionListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.IDrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ContextMenuCreator;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextMenuContentProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.MenuHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewNodeLeafDetector;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElementInteractor
implements IContextMenuContentProvider,
Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementInteractor.class);
    private final ContextMenuCreator m_contextMenuCreator = new ContextMenuCreator();
    private final IWorkbenchView m_workbenchView;
    private final EnumSet<Gesture> m_disabledGestures;
    private Point m_previousMouseLocationInViewMove;
    private Point m_startPositionInElementMove;
    private Event m_mouseDownEvent;
    private Event m_mouseUpEvent;
    private Gesture m_gestureInProgress;
    private boolean m_inGesture;
    private boolean m_dragDetected;
    private boolean m_isEnabled = true;

    public ElementInteractor(IWorkbenchView workbenchView, EnumSet<Gesture> disableGestures) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'ElementInteractor' must not be null";
        assert (disableGestures != null) : "Parameter 'disableGestures' of method 'ElementInteractor' must not be null";
        for (Gesture nextGesture : disableGestures) {
            assert (nextGesture.mayBeDisabled()) : "May not be disabled: " + String.valueOf((Object)nextGesture);
        }
        this.m_workbenchView = workbenchView;
        this.m_disabledGestures = disableGestures;
        for (Control nextControl : workbenchView.getControlsForInteraction()) {
            new MenuHandler(this, nextControl);
            nextControl.addListener(3, (Listener)this);
            nextControl.addListener(4, (Listener)this);
            nextControl.addListener(8, (Listener)this);
            if (this.m_workbenchView instanceof IDrawableSlaveView) {
                nextControl.addListener(29, (Listener)this);
                nextControl.addListener(5, (Listener)this);
            }
            if (!(this.m_workbenchView instanceof IViewWithZoom)) continue;
            nextControl.addListener(37, (Listener)this);
        }
    }

    private IDrawableSlaveView getDrawbleSlaveView() {
        return this.m_workbenchView instanceof IDrawableSlaveView ? (IDrawableSlaveView)this.m_workbenchView : null;
    }

    private IViewWithZoom getViewWithZoom() {
        return this.m_workbenchView instanceof IViewWithZoom && ((IViewWithZoom)this.m_workbenchView).supportMouseWheelZoom() ? (IViewWithZoom)this.m_workbenchView : null;
    }

    private Point translate(IDrawableSlaveView drawableSlaveView, int x, int y) {
        assert (drawableSlaveView != null) : "Parameter 'drawableSlaveView' of method 'translate' must not be null";
        double zoom = drawableSlaveView.getZoomLevel();
        Point location = drawableSlaveView.getFigureCanvas().getViewport().getViewLocation();
        return new Point(x + location.x, y + location.y).scale(1.0 / zoom);
    }

    private List<Element> getSelectedElementsOfWorkbenchView() {
        List<Element> selected = this.m_workbenchView.getSelectedElements();
        boolean containsInvalidElement = false;
        for (Element nextElement : selected) {
            if (nextElement.isValid()) continue;
            LOGGER.warn("Invalid element in selection received from view: " + String.valueOf(nextElement) + " [" + String.valueOf(this.m_workbenchView) + "]");
            containsInvalidElement = true;
        }
        return containsInvalidElement ? Collections.emptyList() : selected;
    }

    private void finishGesture() {
        if (this.m_inGesture) {
            Shell shell;
            if (this.m_gestureInProgress == Gesture.MOVE_ELEMENT_COMPOSITE || this.m_gestureInProgress == Gesture.MOVE_ELEMENT_SIMPLE) {
                assert (this.m_startPositionInElementMove != null) : "'m_startElementMovePosition' of method 'finishGesture' must not be null";
                IDrawableSlaveView drawableSlaveView = this.getDrawbleSlaveView();
                assert (drawableSlaveView != null) : "'drawableSlaveView' of method 'finishGesture' must not be null";
                boolean needsCancel = true;
                if (this.m_mouseUpEvent != null) {
                    List<Element> selected = this.getSelectedElementsOfWorkbenchView();
                    if (!selected.isEmpty()) {
                        Widget source = this.m_mouseUpEvent.widget;
                        assert (source instanceof Control) : "Unexpected class: " + String.valueOf(source);
                        drawableSlaveView.finishElementsMoveInteraction(this.m_gestureInProgress, selected, this.m_startPositionInElementMove, this.translate(drawableSlaveView, this.m_mouseUpEvent.x, this.m_mouseUpEvent.y));
                        needsCancel = false;
                        LOGGER.debug("Finish gesture: " + String.valueOf((Object)this.m_gestureInProgress) + " [" + String.valueOf(this.m_workbenchView) + "]");
                    } else {
                        LOGGER.warn("Finish gesture: " + String.valueOf((Object)this.m_gestureInProgress) + " (cancelled because selection has been lost) [" + String.valueOf(this.m_workbenchView) + "]");
                    }
                } else {
                    LOGGER.warn("Finish gesture: " + String.valueOf((Object)this.m_gestureInProgress) + " (cancelled because no mouse up event received) [" + String.valueOf(this.m_workbenchView) + "]");
                }
                if (needsCancel) {
                    drawableSlaveView.cancelElementsMoveInteraction(this.m_gestureInProgress);
                }
            } else {
                LOGGER.debug("Finish gesture: " + String.valueOf(this.m_gestureInProgress != null ? this.m_gestureInProgress : "No gesture detected") + " [" + String.valueOf(this.m_workbenchView) + "]");
            }
            if ((shell = this.m_workbenchView.getShell()) != null) {
                shell.setCursor(null);
            }
            this.m_startPositionInElementMove = null;
            this.m_previousMouseLocationInViewMove = null;
            this.m_dragDetected = false;
            this.m_mouseDownEvent = null;
            this.m_mouseUpEvent = null;
            this.m_gestureInProgress = null;
            this.m_inGesture = false;
            this.m_workbenchView.finishedGesture();
        }
    }

    private boolean aggregateSelection(Event event) {
        assert (event != null) : "Parameter 'event' of method 'aggregateSelection' must not be null";
        if (!Gesture.shiftKeyPressed(event.stateMask)) {
            return Gesture.primaryModifierKeyPressed(event.stateMask);
        }
        return false;
    }

    private Gesture getMoveElementGesture(Event event) {
        assert (event != null) : "Parameter 'event' of method 'getMoveElementGesture' must not be null";
        if (Gesture.shiftKeyPressed(event.stateMask)) {
            return Gesture.primaryModifierKeyPressed(event.stateMask) ? Gesture.MOVE_ELEMENT_COMPOSITE : Gesture.MOVE_ELEMENT_SIMPLE;
        }
        return null;
    }

    private void notifyClearSelectionIfNecessary() {
        TableItem tableItem;
        assert (this.m_mouseDownEvent != null) : "Parameter 'm_mouseDownEvent' of method 'notifyClearSelectionIfNecessary' must not be null";
        Widget source = this.m_mouseDownEvent.widget;
        assert (source instanceof Control) : "Unexpected class: " + String.valueOf(source);
        Control sourceControl = (Control)source;
        boolean selectionCleared = false;
        if (sourceControl instanceof Tree) {
            TreeItem treeItem;
            if (!Platform.isMac() && (treeItem = ((Tree)sourceControl).getItem(new org.eclipse.swt.graphics.Point(this.m_mouseDownEvent.x, this.m_mouseDownEvent.y))) == null) {
                selectionCleared = true;
            }
        } else if (sourceControl instanceof Table && (tableItem = ((Table)sourceControl).getItem(new org.eclipse.swt.graphics.Point(this.m_mouseDownEvent.x, this.m_mouseDownEvent.y))) == null) {
            selectionCleared = true;
        }
        if (selectionCleared) {
            this.finishGesture();
            this.m_workbenchView.clearSelection(sourceControl);
        }
    }

    private void processMouseDownEvent(boolean cancelOnDragDetected) {
        try {
            if (this.m_mouseDownEvent == null) {
                return;
            }
            if (cancelOnDragDetected && this.m_dragDetected) {
                LOGGER.debug("Processing last mouse down: cancelled - drag detected [" + String.valueOf(this.m_workbenchView.getViewId()) + "]");
                return;
            }
            if (this.m_isEnabled && this.m_workbenchView.isActive() && this.m_workbenchView.isReady()) {
                List<Element> selectedElements = this.getSelectedElementsOfWorkbenchView();
                IDrawableSlaveView drawableSlaveView = this.getDrawbleSlaveView();
                if (drawableSlaveView != null) {
                    boolean adjustSelection = true;
                    if (this.m_dragDetected || this.m_mouseDownEvent.button == 3 || Platform.isMac() && this.m_mouseDownEvent.button == 1 && Gesture.ctrlKeyPressed(this.m_mouseDownEvent.stateMask)) {
                        Element elementAtPosition = drawableSlaveView.getElementAt(this.m_mouseDownEvent.x, this.m_mouseDownEvent.y);
                        if (elementAtPosition == null && selectedElements.isEmpty()) {
                            adjustSelection = false;
                        } else if (elementAtPosition != null && selectedElements.contains(elementAtPosition)) {
                            adjustSelection = false;
                        }
                    }
                    if (adjustSelection) {
                        drawableSlaveView.adjustSelection(this.m_mouseDownEvent.x, this.m_mouseDownEvent.y, this.aggregateSelection(this.m_mouseDownEvent));
                        selectedElements = this.getSelectedElementsOfWorkbenchView();
                    }
                }
                if (!(this.m_mouseDownEvent.button != 1 || Platform.isMac() && Gesture.ctrlKeyPressed(this.m_mouseDownEvent.stateMask))) {
                    if (drawableSlaveView != null) {
                        if (Gesture.shiftKeyPressed(this.m_mouseDownEvent.stateMask) && this.m_gestureInProgress == null) {
                            Gesture gesture;
                            Shell shell = drawableSlaveView.getShell();
                            if (selectedElements.isEmpty() || drawableSlaveView.startViewMove(selectedElements)) {
                                if (shell != null) {
                                    shell.setCursor(UiResourceManager.getInstance().getCursor(UiResourceManager.CursorId.OPEN_HAND));
                                }
                                this.setGestureInProgress(Gesture.MOVE_VIEW);
                            }
                            if (!selectedElements.isEmpty() && (gesture = this.getMoveElementGesture(this.m_mouseDownEvent)) != null && drawableSlaveView.startElementsMoveInteraction(gesture, selectedElements)) {
                                if (shell != null) {
                                    switch (gesture) {
                                        case MOVE_ELEMENT_SIMPLE: {
                                            shell.setCursor(UiResourceManager.getInstance().getCursor(UiResourceManager.CursorId.OPEN_HAND));
                                            break;
                                        }
                                        case MOVE_ELEMENT_COMPOSITE: {
                                            shell.setCursor(UiResourceManager.getInstance().getCursor(2));
                                            break;
                                        }
                                        default: {
                                            assert (false) : "Unhandled gesture: " + String.valueOf((Object)gesture);
                                            break;
                                        }
                                    }
                                }
                                this.setGestureInProgress(gesture);
                                this.m_startPositionInElementMove = this.translate(drawableSlaveView, this.m_mouseDownEvent.x, this.m_mouseDownEvent.y);
                            }
                        }
                    } else if (!selectedElements.isEmpty()) {
                        this.notifyClearSelectionIfNecessary();
                    }
                } else {
                    this.finishGesture();
                }
            }
        }
        finally {
            this.m_dragDetected = false;
            this.m_mouseDownEvent = null;
        }
    }

    private void setGestureInProgress(Gesture gesture) {
        assert (gesture != null) : "Parameter 'gesture' of method 'setGestureInProgress' must not be null";
        assert (this.m_gestureInProgress == null) : "'m_gestureInProgress' of method 'setGestureInProgress' must be null: " + String.valueOf((Object)this.m_gestureInProgress);
        this.m_gestureInProgress = gesture;
        LOGGER.debug("Gesture detected: " + String.valueOf((Object)gesture) + " [" + String.valueOf(this.m_workbenchView) + "]");
    }

    private void handleMouseDoubleClick(Element element) {
        assert (element != null) : "Parameter 'element' of method 'handleMouseDoubleClick' must not be null";
        Pair doubleClickTarget = null;
        block0: for (IViewId nextViewId : WorkbenchRegistry.getInstance().getAvailableViewIds()) {
            ShowInView showInView;
            SupportsShowInView nextSupportsShowInView;
            if (nextViewId == this.m_workbenchView.getViewId() || (nextSupportsShowInView = nextViewId.getSupportsShowInView(this.m_workbenchView.getViewId())) == null || !nextSupportsShowInView.isPotentialDoubleClickTarget() || (showInView = nextSupportsShowInView.supportsShowInViewFor(Collections.singletonList(element), this.m_workbenchView.getAdditionalShowInViewOptions(), null)) == null) continue;
            ShowInViewNodeLeafDetector leafDetector = new ShowInViewNodeLeafDetector();
            for (ShowInViewNode nextShowInViewNode : showInView.getRootNodes()) {
                nextShowInViewNode.accept(leafDetector);
                ShowInViewNode leaf = leafDetector.getLeaf();
                if (leaf == null) continue;
                doubleClickTarget = new Pair((Object)nextViewId, (Object)leaf);
                break block0;
            }
        }
        if (doubleClickTarget != null) {
            IViewId viewId = (IViewId)doubleClickTarget.getFirst();
            assert (viewId != null) : "Parameter 'viewId' of method 'handleMouseDoubleClick' must not be null";
            ShowInViewNode showInViewNode = (ShowInViewNode)((Object)doubleClickTarget.getSecond());
            assert (showInViewNode != null) : "Parameter 'showInViewNode' of method 'handleMouseDoubleClick' must not be null";
            ShowInViewSelectionAdapter.showInView(this.m_workbenchView, viewId, showInViewNode.getSecondaryId(), showInViewNode.getOptions(), showInViewNode.getElements(), false);
        }
    }

    private void handleMouseMove(Event event) {
        assert (event != null) : "Parameter 'event' of method 'handleMouseMove' must not be null";
        this.processMouseDownEvent(false);
        if (this.m_gestureInProgress == Gesture.MOVE_VIEW) {
            IDrawableSlaveView drawableSlaveView = this.getDrawbleSlaveView();
            assert (drawableSlaveView != null) : "'drawableSlaveView' of method 'handleMouseMove' must not be null";
            if (this.m_previousMouseLocationInViewMove == null) {
                this.m_previousMouseLocationInViewMove = new Point(event.x, event.y);
                return;
            }
            int deltaX = event.x - this.m_previousMouseLocationInViewMove.x;
            int deltaY = event.y - this.m_previousMouseLocationInViewMove.y;
            Point currentLocation = drawableSlaveView.getFigureCanvas().getViewport().getViewLocation();
            Point newLocation = new Point(currentLocation.x - deltaX, currentLocation.y - deltaY);
            drawableSlaveView.getFigureCanvas().getViewport().setViewLocation(newLocation);
            this.m_previousMouseLocationInViewMove = new Point(event.x, event.y);
        } else if (this.m_gestureInProgress == Gesture.MOVE_ELEMENT_COMPOSITE || this.m_gestureInProgress == Gesture.MOVE_ELEMENT_SIMPLE) {
            assert (this.m_startPositionInElementMove != null) : "'m_startPositionInElementMove' of method 'handleMouseMove' must not be null";
            IDrawableSlaveView drawableSlaveView = this.getDrawbleSlaveView();
            assert (drawableSlaveView != null) : "'drawableSlaveView' of method 'handleMouseMove' must not be null";
            List<Element> selected = this.getSelectedElementsOfWorkbenchView();
            if (!selected.isEmpty()) {
                drawableSlaveView.inElementsMoveInteraction(this.m_gestureInProgress, selected, this.m_startPositionInElementMove, this.translate(drawableSlaveView, event.x, event.y));
            } else {
                this.finishGesture();
            }
        }
    }

    public void handleEvent(Event event) {
        assert (event != null) : "Parameter 'event' of method 'handleEvent' must not be null";
        if (this.m_isEnabled && this.m_workbenchView.isActive() && this.m_workbenchView.isReady()) {
            switch (event.type) {
                case 3: {
                    this.finishGesture();
                    this.m_mouseDownEvent = event;
                    this.m_inGesture = true;
                    LOGGER.debug("Gesture started [" + String.valueOf(this.m_workbenchView) + "]");
                    this.m_workbenchView.startGesture(new org.eclipse.swt.graphics.Point(event.x, event.y), event.button, event.stateMask);
                    break;
                }
                case 4: {
                    if (!this.m_inGesture) break;
                    this.m_mouseUpEvent = event;
                    this.processMouseDownEvent(true);
                    this.finishGesture();
                    break;
                }
                case 8: {
                    Element selectedElement;
                    List<Element> selectedElements;
                    if (!this.m_inGesture || this.m_gestureInProgress != null) break;
                    this.setGestureInProgress(Gesture.DOUBLE_CLICK);
                    this.processMouseDownEvent(true);
                    if (!this.m_disabledGestures.contains((Object)Gesture.DOUBLE_CLICK) && (selectedElements = this.getSelectedElementsOfWorkbenchView()).size() == 1 && !this.m_workbenchView.doubleClicked(selectedElement = selectedElements.get(0))) {
                        this.handleMouseDoubleClick(selectedElement);
                    }
                    this.finishGesture();
                    break;
                }
                case 5: {
                    if (!this.m_inGesture) break;
                    this.handleMouseMove(event);
                    break;
                }
                case 37: {
                    IViewWithZoom viewWithZoom;
                    this.processMouseDownEvent(true);
                    this.finishGesture();
                    if (Gesture.shiftKeyPressed(event.stateMask) || !Gesture.primaryModifierKeyPressed(event.stateMask) || (viewWithZoom = this.getViewWithZoom()) == null) break;
                    this.m_inGesture = true;
                    this.m_workbenchView.startGesture(new org.eclipse.swt.graphics.Point(event.x, event.y), -1, 0);
                    this.setGestureInProgress(Gesture.ZOOM);
                    if (event.count > 0) {
                        viewWithZoom.zoomIn(new org.eclipse.swt.graphics.Point(event.x, event.y));
                    } else if (event.count < 0) {
                        viewWithZoom.zoomOut(new org.eclipse.swt.graphics.Point(event.x, event.y));
                    }
                    this.finishGesture();
                    break;
                }
                case 29: {
                    if (!this.m_inGesture || this.m_dragDetected || this.m_gestureInProgress != null) break;
                    this.m_dragDetected = true;
                    break;
                }
                default: {
                    assert (false) : "Unhandled event: " + String.valueOf(event);
                    break;
                }
            }
        }
    }

    @Override
    public void aboutToShowContextMenu(Menu menu, Control onControl, IContextMenuInteractionListener listener) {
        assert (menu != null) : "Parameter 'menu' of method 'fillContextMenu' must not be null";
        assert (onControl != null) : "Parameter 'onControl' of method 'aboutToShowContextMenu' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'fillContextMenu' must not be null";
        if (this.m_isEnabled && this.m_workbenchView.isActive() && this.m_workbenchView.isReady()) {
            if (this.m_inGesture) {
                this.processMouseDownEvent(true);
            }
            this.m_inGesture = true;
            Display display = WorkbenchRegistry.getInstance().getDisplay();
            this.m_workbenchView.startGesture(display.map(null, onControl, display.getCursorLocation()), 3, 0);
            LOGGER.debug("Gesture started [" + String.valueOf(this.m_workbenchView) + "]");
            this.setGestureInProgress(Gesture.CONTEXT_MENU);
            this.finishGesture();
            this.m_contextMenuCreator.populate(menu, listener, this.m_workbenchView, this.getSelectedElementsOfWorkbenchView());
        }
    }

    public boolean dragAndDropStarted() {
        if (this.m_mouseDownEvent != null && !Gesture.shiftKeyPressed(this.m_mouseDownEvent.stateMask) && !Gesture.primaryModifierKeyPressed(this.m_mouseDownEvent.stateMask)) {
            Event event = this.m_mouseDownEvent;
            this.processMouseDownEvent(false);
            this.finishGesture();
            this.m_inGesture = true;
            this.m_workbenchView.startGesture(new org.eclipse.swt.graphics.Point(event.x, event.y), event.button, event.stateMask);
            LOGGER.debug("Gesture started [" + String.valueOf(this.m_workbenchView) + "]");
            this.setGestureInProgress(Gesture.DRAG_AND_DROP);
            return true;
        }
        return false;
    }

    public void dragAndDropFinished() {
        this.finishGesture();
    }

    public void disable() {
        LOGGER.debug("[" + String.valueOf(this.m_workbenchView.getViewId()) + "] Disable");
        this.finishGesture();
        this.m_isEnabled = false;
    }

    public void enable() {
        LOGGER.debug("[" + String.valueOf(this.m_workbenchView.getViewId()) + "] Enable");
        this.finishGesture();
        this.m_isEnabled = true;
    }

    public String toString() {
        return this.m_workbenchView.toString();
    }
}

