/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DuplicateCodeBlocksViewShowInViewSupport
extends SupportsShowInView {
    DuplicateCodeBlocksViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    private List<Element> getElementsForShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'select' must not be null";
        if (!elements.isEmpty()) {
            ArrayList<Element> relevantElements = new ArrayList<Element>(elements.size());
            for (Element element : elements) {
                if (element instanceof IIssueDiff) {
                    IIssueDiff issueDiff = (IIssueDiff)element;
                    if (issueDiff.getCurrent() == null) continue;
                    element = issueDiff.getCurrent();
                } else if (element instanceof IssueRank) {
                    element = ((IssueRank)element).getRankedElement();
                }
                if (element instanceof Issue) {
                    Issue selectedIssue = (Issue)element;
                    element = selectedIssue.getAffectedElement();
                }
                if (!(element instanceof DuplicateCodeBlock)) {
                    return Collections.emptyList();
                }
                relevantElements.add(element);
            }
            return relevantElements;
        }
        return Collections.emptyList();
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        List<Element> elementsForShowInView;
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        if (CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.DUPLICATE_CODE) && !(elementsForShowInView = this.getElementsForShowInView(selectedElements)).isEmpty()) {
            return new ShowInView(new ShowInViewNode(elementsForShowInView, this.getViewPresentationName(), this.getImageName(), true));
        }
        return null;
    }
}

