/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.draw2d.FigureCanvas;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.SWTGraphics;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CreateRepresentationCommand;
import com.hello2morrow.sonargraph.core.command.system.ExtendFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.RemoveFromFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.RemoveRepresentationFromModelCommand;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationRemovedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.CreateRepresentationMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusProperties;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElementGroup;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationViewData;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.CollectionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableWidgetListener;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IDrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.view.INavigationStateLifeCycleListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithHome;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveViewFigureBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableViewNavigationStateWrapper;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableViewStatusBar;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ImageExtension;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.RepresentationViewDeadStateInfoProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import jakarta.inject.Inject;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrawableSlaveView
extends WorkbenchSlaveView
implements IDrawableSlaveView,
IDrawableWidgetListener,
INavigationStateLifeCycleListener,
IViewWithHome {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawableSlaveView.class);
    private static final String AUTOZOOM_PERSISTENCE_KEY = "Autozoom";
    private static final String SHOW_ONLY_EDGES_OF_SELECTED_NODES_PERSISTENCE_KEY = "ShowOnlyEdgesOfSelectedNodes";
    private static final String SHOW_ONLY_VIOLATIONS_PERSISTENCE_KEY = "ShowOnlyViolations";
    private static final String HIDE_SELF_ACS_PERSISTENCE_KEY = "HideSelfArcs";
    private static final List<NavigationState.Type> OPERATIONS_MODIFYING_PROGRAMMING_ELEMENTS = Arrays.asList(NavigationState.Type.CONTENT_EXPANDED_DEPENDENCY_TO_COMPONENTS, NavigationState.Type.CONTENT_FOCUSED, NavigationState.Type.CONTENT_EXTENDED_FOCUS_WITH_DEPENDENCIES);
    private static final RepresentationViewDeadStateInfoProvider DEAD_STATE_INFO_PROVIDER = new RepresentationViewDeadStateInfoProvider();
    private DrawableSlaveViewFigureBasedTextSearchHandler m_textSearchProvider;
    private boolean m_showOnlyViolations = false;
    @Inject
    private IEventBroker m_eventBroker;
    private boolean m_isViewReady = false;
    private boolean m_onlyVisible = false;
    private MHandledMenuItem m_highlightInputItem;
    private MHandledMenuItem m_autoZoomItem;
    private MHandledMenuItem m_showOnlyDependenciesOfSelectedNodesItem;
    private MHandledMenuItem m_showOnlyViolationsItem;
    private MHandledMenuItem m_hideSelfArcs;
    private DrawableViewStatusBar m_statusBar;

    @Override
    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    @Override
    protected final boolean supportsSleep() {
        return false;
    }

    public abstract DrawableWidget getDrawableWidget();

    protected final void disableView() {
        DrawableWidget drawableWidget = this.getDrawableWidget();
        if (drawableWidget != null && !drawableWidget.isDisposed()) {
            this.getElementInteractor().disable();
            this.m_isViewReady = false;
            this.m_textSearchProvider.requestNewFindInfo();
            drawableWidget.startDraw();
        }
    }

    protected final void enableView() {
        DrawableWidget drawableWidget = this.getDrawableWidget();
        if (drawableWidget != null && !drawableWidget.isDisposed()) {
            drawableWidget.finishDraw(this);
            this.m_textSearchProvider.requestNewFindInfo();
            this.refreshUIElements();
            this.m_isViewReady = true;
            this.getElementInteractor().enable();
        }
    }

    @Override
    public StructureMode getStructureMode() {
        PresentationMode presentationMode = this.getDrawableWidget().getPresentationMode();
        if (presentationMode != null) {
            switch (presentationMode) {
                case FLAT: {
                    return StructureMode.NON_RECURSIVE;
                }
                case HIERARCHICAL: 
                case MIXED: {
                    return StructureMode.RECURSIVE;
                }
            }
            assert (false) : "Unhandled presentation mode: " + String.valueOf(presentationMode);
            return StructureMode.RECURSIVE;
        }
        return StructureMode.UNSPECIFIED;
    }

    @Override
    public final List<Control> getViewComponents() {
        return Collections.singletonList(this.getDrawableWidget());
    }

    protected void finishNonUndoRedoRepresentationCreation(NodeAndEdgeRepresentation representation, DrawableViewNavigationStateWrapper state) {
        assert (representation != null) : "Parameter 'representation' of method 'finishNonUndoRedoRepresentationCreation' must not be null";
        assert (state != null) : "Parameter 'state' of method 'finishNonUndoRedoRepresentationCreation' must not be null";
    }

    protected final void onRepresentationModified(NodeAndEdgeRepresentation representation, boolean modelRecreated, boolean fromUndoRedo) {
        assert (representation != null) : "Parameter 'representation' of method 'onRepresentationModified' must not be null";
        this.disableView();
        if (modelRecreated) {
            NavigationState currentNavigationState = ViewNavigationManager.getInstance().clear(this.getViewId(), this.getSecondaryId());
            EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.noneOf(DrawableWidget.ShowOption.class);
            if (this.autozoomEnabled()) {
                showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
            }
            this.getDrawableWidget().showRepresentation(representation, showOptions, Collections.emptyMap());
            if (!fromUndoRedo) {
                if (currentNavigationState == null) {
                    LOGGER.warn("No 'current' navigation state was available: " + String.valueOf(this.getViewId()));
                } else {
                    DrawableViewNavigationStateWrapper state = new DrawableViewNavigationStateWrapper(currentNavigationState, this.getElementResolver());
                    representation.createDelta(state.getNavigationState().getId(), true);
                    ViewNavigationManager.getInstance().addNavigationState(state.getNavigationState());
                    this.applyNavigationState(state, !showOptions.contains((Object)DrawableWidget.ShowOption.FIT_TO_VIEW), CreateRepresentationMode.UPDATE);
                    this.finishNonUndoRedoRepresentationCreation(representation, state);
                }
            }
        } else {
            this.getDrawableWidget().revalidateNodesAndEdges();
        }
        this.enableView();
    }

    protected boolean createStatusBar() {
        return true;
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        String hideSelfArcsHandledItemId;
        String showOnlyViolationsHandledItemId;
        String showOnlyDependenciesOfSelectedNodesHandledItemId;
        String autozoomHandledItemId;
        Composite mainComposite = new Composite(viewContentArea, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        mainComposite.setLayout((Layout)gridLayout);
        this.createDrawableWidget(mainComposite);
        this.getDrawableWidget().setLayoutData(new GridData(4, 4, true, true, 1, 1));
        if (this.createStatusBar()) {
            this.m_statusBar = new DrawableViewStatusBar(mainComposite, this.supportsDependencyTypeFocus());
            this.m_statusBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        }
        this.m_textSearchProvider = new DrawableSlaveViewFigureBasedTextSearchHandler(this.getDrawableWidget(), this.getViewId().getPresentationName());
        EventManager.getInstance().attach((EventHandler)new EventHandler<RepresentationModifiedEvent>(RepresentationModifiedEvent.class, (Object)this){

            public void handleEvent(RepresentationModifiedEvent event) {
                if (DrawableSlaveView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    Representation representation = event.getRepresentation();
                    NodeAndEdgeRepresentation previousRepresentation = DrawableSlaveView.this.getDrawableWidget().getUnderlyingRepresentation();
                    if (previousRepresentation != null && previousRepresentation.getId() == representation.getId()) {
                        if (!$assertionsDisabled && !(representation instanceof NodeAndEdgeRepresentation)) {
                            throw new AssertionError((Object)("Unexpected class in method 'handleEvent': " + String.valueOf(representation)));
                        }
                        if (!$assertionsDisabled && !representation.isValid()) {
                            throw new AssertionError((Object)"'representation' must be valid");
                        }
                        DrawableSlaveView.this.onRepresentationModified((NodeAndEdgeRepresentation)representation, event.modelRecreated(), event.fromUndoRedo());
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<RepresentationRemovedEvent>(RepresentationRemovedEvent.class, (Object)this){

            public void handleEvent(RepresentationRemovedEvent event) {
                if (DrawableSlaveView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    Representation removedRepresentation = event.getRepresentation();
                    NodeAndEdgeRepresentation currentRepresentation = DrawableSlaveView.this.getDrawableWidget().getUnderlyingRepresentation();
                    if (currentRepresentation != null && currentRepresentation.getId() == removedRepresentation.getId()) {
                        DrawableSlaveView.this.hideView();
                    }
                }
            }
        });
        String highlightOrigibalSelectionItemId = this.getHighlightOriginalSelectionHandledItemId();
        if (highlightOrigibalSelectionItemId != null) {
            this.m_highlightInputItem = RcpUtility.findUniqueModelElement(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), highlightOrigibalSelectionItemId, MHandledMenuItem.class);
            assert (this.m_highlightInputItem != null) : "'m_highlightInputItem' of method 'updateViewOptions' must not be null";
        }
        if ((autozoomHandledItemId = this.getAutozoomHandledItemId()) != null) {
            this.m_autoZoomItem = RcpUtility.findUniqueModelElement(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), autozoomHandledItemId, MHandledMenuItem.class);
            assert (this.m_autoZoomItem != null) : "'m_autoZoomItem' of method 'createViewContent' must not be null";
        }
        if ((showOnlyDependenciesOfSelectedNodesHandledItemId = this.getShowOnlyDependenciesOfSelectedNodesHandledItemId()) != null) {
            this.m_showOnlyDependenciesOfSelectedNodesItem = RcpUtility.findUniqueModelElement(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), showOnlyDependenciesOfSelectedNodesHandledItemId, MHandledMenuItem.class);
            assert (this.m_showOnlyDependenciesOfSelectedNodesItem != null) : "'showOnlyDependenciesOfSelectedNodesItem' of method 'updateViewOptions' must not be null";
        }
        if ((showOnlyViolationsHandledItemId = this.getShowOnlyViolationsHandledItemId()) != null) {
            this.m_showOnlyViolationsItem = RcpUtility.findUniqueModelElement(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), showOnlyViolationsHandledItemId, MHandledMenuItem.class);
            assert (this.m_showOnlyViolationsItem != null) : "'showOnlyViolationsItem' of method 'updateViewOptions' must not be null";
        }
        if ((hideSelfArcsHandledItemId = this.getHideSelfArcsHandledItemId()) != null) {
            this.m_hideSelfArcs = RcpUtility.findUniqueModelElement(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), hideSelfArcsHandledItemId, MHandledMenuItem.class);
            assert (this.m_hideSelfArcs != null) : "'hideSelfArcs' of method 'updateViewOptions' must not be null";
        }
        IEclipsePreferences settings = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", this.getViewId());
        this.loadPersistedViewOptionsValues(settings);
        this.updateViewOptions();
    }

    protected abstract void createDrawableWidget(Composite var1);

    @Override
    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (this.m_isViewReady) {
            boolean isArchitectureRepresentation;
            DrawableWidget widget = this.getDrawableWidget();
            IDomainRoot.Domain domain = widget == null ? null : widget.getUnderlyingRepresentation().getDomain();
            boolean bl = isArchitectureRepresentation = domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL;
            if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED) && !isArchitectureRepresentation) {
                this.disableView();
                this.getDrawableWidget().revalidateNodesAndEdges();
                this.enableView();
            }
        }
        super.analyzerModification(modification, analyzerId);
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.m_isViewReady = false;
    }

    protected final void setViewReady(boolean ready) {
        this.m_isViewReady = ready;
        if (this.m_isViewReady) {
            this.getElementInteractor().enable();
        } else {
            this.getElementInteractor().disable();
        }
    }

    @Override
    public final boolean isReady() {
        return this.m_isViewReady;
    }

    @Override
    protected void destroyViewContent() {
        EventManager.getInstance().detach(RepresentationModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(RepresentationRemovedEvent.class, (Object)this);
        this.removeRepresentationInWidgetFromModel(true, true);
        super.destroyViewContent();
    }

    @Override
    public final void viewOptionsChanged() {
        super.viewOptionsChanged();
        this.getDrawableWidget().setRedraw(false);
        this.updateViewOptions();
        IEclipsePreferences settings = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt", this.getViewId());
        this.persistViewOptionsValues(settings);
        this.getDrawableWidget().setRedraw(true);
    }

    protected void updateViewOptions() {
        String hideSelfArcsHandledItemId;
        String showOnlyViolationsHandledItemId;
        String autozoomHandledItemId = this.getAutozoomHandledItemId();
        if (autozoomHandledItemId != null) {
            assert (this.m_autoZoomItem != null) : " 'm_autoZoomItem' of method 'updateViewOptions' must not be null";
            this.getDrawableWidget().autozoomEnabled(this.m_autoZoomItem.isSelected());
        }
        if (this.m_showOnlyDependenciesOfSelectedNodesItem != null) {
            this.getDrawableWidget().showOnlyDependenciesOfSelectedNodes(this.m_showOnlyDependenciesOfSelectedNodesItem.isSelected());
        }
        if ((showOnlyViolationsHandledItemId = this.getShowOnlyViolationsHandledItemId()) != null) {
            assert (this.m_showOnlyViolationsItem != null) : "'showOnlyViolationsItem' of method 'updateViewOptions' must not be null";
            boolean previous = this.m_showOnlyViolations;
            this.m_showOnlyViolations = this.m_showOnlyViolationsItem.isSelected();
            this.getDrawableWidget().showOnlyViolations(this.m_showOnlyViolations);
            if (this.m_showOnlyViolations != previous) {
                this.m_eventBroker.send("WorkbenchAuxiliaryViewOptionChanged", (Object)this);
            }
        }
        if ((hideSelfArcsHandledItemId = this.getHideSelfArcsHandledItemId()) != null) {
            assert (this.m_hideSelfArcs != null) : "'hideSelfArcs' of method 'updateViewOptions' must not be null";
            this.getDrawableWidget().hideSelfArcs(this.m_hideSelfArcs.isSelected());
        }
    }

    protected void persistViewOptionsValues(IEclipsePreferences settings) {
        String hideSelfArcsHandledItemId;
        String showOnlyViolationsHandledItemId;
        assert (settings != null) : "'settings' of method 'persistFilterValues' must not be null";
        if (this.getAutozoomHandledItemId() != null) {
            assert (this.m_autoZoomItem != null) : "'m_autoZoomItem' of method 'persistViewOptionsValues' must not be null";
            settings.putBoolean(AUTOZOOM_PERSISTENCE_KEY, this.m_autoZoomItem.isSelected());
        }
        if (this.getShowOnlyDependenciesOfSelectedNodesHandledItemId() != null) {
            assert (this.m_showOnlyDependenciesOfSelectedNodesItem != null) : "'showOnlyDependenciesOfSelectedNodesItem' of method 'updateViewOptions' must not be null";
            settings.putBoolean(SHOW_ONLY_EDGES_OF_SELECTED_NODES_PERSISTENCE_KEY, this.m_showOnlyDependenciesOfSelectedNodesItem.isSelected());
        }
        if ((showOnlyViolationsHandledItemId = this.getShowOnlyViolationsHandledItemId()) != null) {
            assert (this.m_showOnlyViolationsItem != null) : "'showOnlyViolationsItem' of method 'updateViewOptions' must not be null";
            settings.putBoolean(SHOW_ONLY_VIOLATIONS_PERSISTENCE_KEY, this.m_showOnlyViolationsItem.isSelected());
        }
        if ((hideSelfArcsHandledItemId = this.getHideSelfArcsHandledItemId()) != null) {
            assert (this.m_hideSelfArcs != null) : "'hideSelfArcs' of method 'updateViewOptions' must not be null";
            settings.putBoolean(HIDE_SELF_ACS_PERSISTENCE_KEY, this.m_hideSelfArcs.isSelected());
        }
        PreferencesUtility.save(settings);
    }

    protected void loadPersistedViewOptionsValues(IEclipsePreferences settings) {
        assert (settings != null) : "parameter 'settings' of method 'persistFilterValues' must not be null";
        if (this.getAutozoomHandledItemId() != null) {
            assert (this.m_autoZoomItem != null) : "'m_autoZoomItem' of method 'loadPersistedViewOptionsValues' must not be null";
            this.loadHandledMenuItemValue(settings, this.m_autoZoomItem, AUTOZOOM_PERSISTENCE_KEY, true);
        }
        if (this.getShowOnlyDependenciesOfSelectedNodesHandledItemId() != null) {
            this.loadHandledMenuItemValue(settings, this.m_showOnlyDependenciesOfSelectedNodesItem, SHOW_ONLY_EDGES_OF_SELECTED_NODES_PERSISTENCE_KEY, false);
        }
        if (this.getShowOnlyViolationsHandledItemId() != null) {
            this.loadHandledMenuItemValue(settings, this.m_showOnlyViolationsItem, SHOW_ONLY_VIOLATIONS_PERSISTENCE_KEY, false);
        }
        if (this.getHideSelfArcsHandledItemId() != null) {
            this.loadHandledMenuItemValue(settings, this.m_hideSelfArcs, HIDE_SELF_ACS_PERSISTENCE_KEY, this.getHideSelfArcsDefaultValue());
        }
    }

    protected final void loadHandledMenuItemValue(IEclipsePreferences settings, MHandledMenuItem handledMenuItem, String key, boolean defaultValue) {
        assert (settings != null) : "Parameter 'settings' of method 'loadHandledMenuItemValue' must not be null";
        assert (handledMenuItem != null) : "Parameter 'handledMenuItem' of method 'loadHandledMenuItemValue' must not be null";
        assert (key != null) : "Parameter 'key' of method 'loadHandledMenuItemValue' must not be null";
        if (defaultValue) {
            if (!settings.getBoolean(key, true)) {
                handledMenuItem.setSelected(false);
            }
        } else if (settings.getBoolean(key, false)) {
            handledMenuItem.setSelected(true);
        }
    }

    @Override
    public final boolean mayRequestHome() {
        NavigationState initialViewNavigationState = ViewNavigationManager.getInstance().getInitialViewNavigationState(this.getViewId(), this.getSecondaryId());
        return initialViewNavigationState != null && ViewNavigationManager.getInstance().getCurrentNavigationState() != initialViewNavigationState && this.representationContainsNodes();
    }

    protected boolean supportsCreationWithEmptyInput() {
        return false;
    }

    protected final void removeRepresentationFromModel(NodeAndEdgeRepresentation representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations) {
        if (representation != null && representation.isValid()) {
            RemoveRepresentationFromModelCommand cmd = new RemoveRepresentationFromModelCommand(this.getSoftwareSystemProvider(), (Representation)representation, fireRepresentationRemovedEvent, removeSlaveRepresentations);
            UserInterfaceAdapter.getInstance().run((Command)cmd);
        }
    }

    protected final void removeRepresentationInWidgetFromModel(boolean fireRepresentationEvent, boolean removeSlaveRepresentations) {
        if (this.getDrawableWidget() != null) {
            this.removeRepresentationFromModel(this.getDrawableWidget().getUnderlyingRepresentation(), fireRepresentationEvent, removeSlaveRepresentations);
        }
    }

    @Override
    public FigureCanvas getFigureCanvas() {
        DrawableWidget drawableWidget = this.getDrawableWidget();
        assert (drawableWidget != null) : " 'drawableWidget' of method 'getFigureCanvas' must not be null";
        return drawableWidget.getFigureCanvas();
    }

    public final boolean representationContainsNodes() {
        NodeAndEdgeRepresentation representation;
        DrawableWidget widget = this.getDrawableWidget();
        if (widget != null && (representation = widget.getUnderlyingRepresentation()) != null) {
            return representation.getOriginalNodes().size() > 0;
        }
        return false;
    }

    public final void setOnlyVisible(boolean onlyVisible) {
        this.m_onlyVisible = onlyVisible;
    }

    public final void focus(FocusSelectionType selectionType, FocusProperties focusProperties) {
        assert (focusProperties != null) : "Parameter 'focusProperties' of method 'focus' must not be null";
        FocusMode mode = focusProperties.getFocusMode();
        EnumSet properties = focusProperties.getProperties();
        if (this.m_onlyVisible) {
            properties.add(NodeAndEdgeRepresentation.RepresentationProperty.ONLY_VISIBLE);
        }
        Set dependencyTypes = focusProperties.getParserDependencyTypesForEdges();
        List<RepresentationNode> elements = this.getNamedElementsForFocus(selectionType);
        this.m_textSearchProvider.requestNewFindInfo();
        this.focusRepresentationInView(elements, dependencyTypes, mode, properties);
    }

    protected final List<RepresentationNode> getNamedElementsForFocus(FocusSelectionType selectionType) {
        List<Object> elementsForFocus = null;
        switch (selectionType) {
            case SELECTED: {
                elementsForFocus = this.getDrawableWidget().getSelectedElements().stream().filter(RepresentationNode.class::isInstance).map(RepresentationNode.class::cast).collect(Collectors.toList());
                break;
            }
            case UNSELECTED: {
                elementsForFocus = this.getDrawableWidget().getUnselectedElements().stream().filter(RepresentationNode.class::isInstance).map(RepresentationNode.class::cast).collect(Collectors.toList());
                break;
            }
            case NONE: {
                elementsForFocus = Collections.emptyList();
                break;
            }
            default: {
                assert (false) : "Unexpected value for 'focusMode' in method 'focus'";
                break;
            }
        }
        return elementsForFocus;
    }

    public boolean enableFocusTransitively() {
        return true;
    }

    public boolean enableFocusWithOnlyVisible() {
        return true;
    }

    public boolean enableFocusWithOnlyInternal() {
        return true;
    }

    public boolean supportsDependencyTypeFocus() {
        return true;
    }

    public final boolean atLeastOneNodeSelected() {
        List<Element> selectedElements = this.getSelectedElements();
        if (selectedElements.isEmpty()) {
            return false;
        }
        for (Element element : selectedElements) {
            if (element instanceof RepresentationNode) continue;
            return false;
        }
        return true;
    }

    public final boolean atLeastOneNodeUnselected() {
        List<Element> selectedElements = this.getSelectedElements();
        for (RepresentationNode representationNode : this.getDrawableWidget().getUnderlyingRepresentation().getNodes()) {
            if (selectedElements.contains(representationNode)) continue;
            return true;
        }
        return false;
    }

    protected final List<IParserDependencyType> getDefaultDependencyTypesForEdges() {
        return Arrays.asList(CoreParserDependencyType.values());
    }

    public final void highlightOriginalInput() {
        this.getDrawableWidget().setRedraw(false);
        this.getDrawableWidget().highlightOriginalInput();
        this.getDrawableWidget().setRedraw(true);
        this.refreshUIElements();
    }

    public final void unhighlightOriginalSelection() {
        this.getDrawableWidget().setRedraw(false);
        this.getDrawableWidget().unhighlightOriginalInput();
        this.getDrawableWidget().setRedraw(true);
        this.refreshUIElements();
    }

    public final boolean isOriginalSelectionHighlighted() {
        return this.getDrawableWidget().isHighlightOriginalInputEnabled();
    }

    public final boolean isHighlightInputMenuItemSelected() {
        return this.m_highlightInputItem != null && this.m_highlightInputItem.isSelected();
    }

    protected final void updateHandledMenuItemState(String itemId, boolean activate) {
        MHandledMenuItem handledItem;
        MUIElement parent;
        List menus;
        MPart part;
        if (itemId != null && !itemId.isEmpty() && (part = this.getPart()) != null && (menus = part.getMenus()) != null && menus.size() > 0 && (parent = (MUIElement)menus.get(0)) != null && (handledItem = RcpUtility.findUniqueModelElement(this.getEclipseContext(), parent, itemId, MHandledMenuItem.class)) != null) {
            handledItem.setSelected(activate);
        }
    }

    @Override
    public final void zoomIn(Point point) {
        if (this.getDrawableWidget().getUnderlyingRepresentation() != null) {
            this.getDrawableWidget().zoomIn();
        }
    }

    @Override
    public final void zoomOut(Point point) {
        if (this.getDrawableWidget().getUnderlyingRepresentation() != null) {
            this.getDrawableWidget().zoomOut();
        }
    }

    @Override
    public final void zoomPerformed() {
        if (this.getDrawableWidget().getUnderlyingRepresentation() != null) {
            this.saveViewState(this.getDrawableWidget(), NavigationState.Type.CONTENT_ZOOM_CHANGED);
            if (this.getAutozoomHandledItemId() != null) {
                this.updateHandledMenuItemState(this.getAutozoomHandledItemId(), false);
                this.getDrawableWidget().autozoomEnabled(false);
            }
        }
    }

    @Override
    public final double getZoomLevel() {
        return this.getDrawableWidget().getZoomLevel();
    }

    protected boolean fitToView() {
        return false;
    }

    public boolean autozoomEnabled() {
        return this.getDrawableWidget().autozoomEnabled();
    }

    protected String getAutozoomHandledItemId() {
        return null;
    }

    public final void changePresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'flatten' must not be null";
        final CreateRepresentationCommand<? extends NodeAndEdgeRepresentation> command = this.getCommandForPresentationModification(this.getDrawableWidget().getUnderlyingRepresentation(), presentationMode);
        this.m_textSearchProvider.requestNewFindInfo();
        if (command.isEnabled().isSuccess()) {
            UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null && DrawableSlaveView.this.getDrawableWidget() != null && !DrawableSlaveView.this.getDrawableWidget().isDisposed()) {
                        DrawableWidget widget = DrawableSlaveView.this.getDrawableWidget();
                        widget.removeListeners();
                        widget.setRedraw(false);
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.noneOf(DrawableWidget.ShowOption.class);
                        if (DrawableSlaveView.this.autozoomEnabled() && DrawableSlaveView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        widget.show(command.getRepresentation(), showOptions);
                        DrawableSlaveView.this.getSelectionProviderAdapter().handleSelectionChanged();
                        if (DrawableSlaveView.this.isHighlightInputMenuItemSelected()) {
                            DrawableSlaveView.this.getDrawableWidget().highlightOriginalInput();
                        }
                        DrawableSlaveView.this.saveViewState(DrawableSlaveView.this.getDrawableWidget(), NavigationState.Type.CONTENT_FLATTENED);
                        DrawableSlaveView.this.updateHandledMenuItemState(DrawableSlaveView.this.getHighlightOriginalSelectionHandledItemId(), DrawableSlaveView.this.isOriginalSelectionHighlighted());
                        DrawableSlaveView.this.refreshUIElements();
                        widget.setRedraw(true);
                        widget.addListeners(DrawableSlaveView.this);
                    }
                }
            });
        }
    }

    public boolean mayChangePresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'mayChangePresentationMode' must not be null";
        if (this.getDrawableWidget() != null && this.getDrawableWidget().getUnderlyingRepresentation() != null) {
            PresentationMode current = this.getDrawableWidget().getPresentationMode();
            assert (current != null) : "'current' of method 'mayChangePresentationMode' must not be null";
            switch (current) {
                case HIERARCHICAL: {
                    return true;
                }
                case MIXED: {
                    return presentationMode == PresentationMode.FLAT;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected final void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreNavigationState' must not be null";
        if (DrawableViewNavigationStateWrapper.isProcessable((INavigationState)state)) {
            DrawableViewNavigationStateWrapper internalState = new DrawableViewNavigationStateWrapper(state, this.getElementResolver());
            boolean needsRepresentationCreation = this.needsRepresentationCreation(internalState);
            if (!state.isInvolvedInUndoRedoOperation() && (viewCreated || needsRepresentationCreation)) {
                Collection mainPathElements = internalState.getMainNodes();
                if (!(mainPathElements.isEmpty() && !this.supportsCreationWithEmptyInput() || internalState.getNavigationState().isDeadState(this.getElementResolver()) || this.getDrawableWidget().getUnderlyingRepresentation() == null)) {
                    this.finishCreateRepresentationForNavigation(internalState);
                } else {
                    this.removeRepresentationInWidgetFromModel(false, false);
                    this.hideView();
                }
            } else {
                this.removeListeners();
                this.setRedraw(false);
                this.applyNavigationState(internalState, true, CreateRepresentationMode.NAVIGATION);
                this.setRedraw(true);
                this.addListeners();
            }
            DrawableWidget drawableWidget = this.getDrawableWidget();
            if (drawableWidget != null) {
                HashSet<CoreParserDependencyType> dependencyTypesForEdges = new HashSet<CoreParserDependencyType>(state.getConstants((IStateData)RepresentationViewData.DEPENDENCY_TYPES_FOR_EDGES));
                FocusMode mode = (FocusMode)state.getConstant((IStateData)RepresentationViewData.FOCUS_MODE);
                assert (mode != null) : "'mode' of method 'restoreNavigationState' must not be null";
                Set constants = state.getConstants((IStateData)RepresentationViewData.PROPERTIES);
                EnumSet<Object> properties = constants.isEmpty() ? EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class) : EnumSet.copyOf(constants);
                this.updateStatusWidget(dependencyTypesForEdges, mode, properties);
                NodeAndEdgeRepresentation representation = drawableWidget.getUnderlyingRepresentation();
                if (representation != null) {
                    representation.navigationStateRestored(state.getId());
                }
            }
        }
    }

    @Override
    public void navigationStatesRemoved(List<NavigationState> states) {
        assert (states != null) : "Parameter 'state' of method 'navigationStateRemoved' must not be null";
        if (this.isReady()) {
            NodeAndEdgeRepresentation representation = this.getDrawableWidget().getUnderlyingRepresentation();
            assert (representation != null) : "'representation' of method 'navigationStateRemoved' must not be null";
            List idsToRemove = CollectionUtility.map(states, (boolean)false, navigationState -> navigationState.getId());
            representation.navigationStatesRemoved(idsToRemove);
        }
    }

    @Override
    public void navigationStateAdded(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'navigationStateAdded' must not be null";
        if (state.isInvolvedInUndoRedoOperation() || this.isReady()) {
            NodeAndEdgeRepresentation representation = this.getDrawableWidget().getUnderlyingRepresentation();
            assert (representation != null) : "'representation' of method 'saveViewState' must not be null";
            representation.navigationStateAdded(state.getId(), OPERATIONS_MODIFYING_PROGRAMMING_ELEMENTS.contains((Object)state.getType()));
        }
    }

    protected abstract void finishCreateRepresentationForNavigation(DrawableViewNavigationStateWrapper var1);

    protected abstract boolean needsRepresentationCreation(DrawableViewNavigationStateWrapper var1);

    protected final void removeListeners() {
        this.getDrawableWidget().removeListeners();
    }

    protected final void addListeners() {
        this.getDrawableWidget().addListeners(this);
    }

    protected final void setRedraw(boolean redraw) {
        this.getDrawableWidget().setRedraw(redraw);
    }

    protected abstract void applyNavigationState(DrawableViewNavigationStateWrapper var1, boolean var2, CreateRepresentationMode var3);

    protected final void updateStatusWidget(Set<CoreParserDependencyType> dependencyTypesForEdges, FocusMode mode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties) {
        if (this.m_statusBar != null) {
            assert (mode != null) : "Parameter 'mode' of method 'updateFocusToolbar' must not be null";
            assert (properties != null) : "Parameter 'properties' of method 'updateFocusToolbar' must not be null";
            boolean includeTransitive = this.enableFocusTransitively() ? properties.contains(NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE) : false;
            boolean onlyInternal = this.enableFocusWithOnlyInternal() ? properties.contains(NodeAndEdgeRepresentation.RepresentationProperty.ONLY_INTERNAL) : true;
            this.m_statusBar.update(mode, includeTransitive, onlyInternal, this.supportsDependencyTypeFocus() ? dependencyTypesForEdges : null);
        }
    }

    protected final void saveViewState(DrawableWidget widget, NavigationState.Type type) {
        assert (widget != null) : "Parameter 'widget' of method 'saveViewState' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), type);
        this.createNavigationState(widget, state);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    protected final void performFinishShowInView(boolean secondaryIdReused) {
        this.enableView();
        this.setViewReady(true);
        WorkbenchRegistry.getInstance().selectView(this);
        if (secondaryIdReused) {
            this.saveViewState(this.getDrawableWidget(), NavigationState.Type.CONTENT_VIEW_INSTANCE_REUSED);
        } else {
            this.saveViewState(this.getDrawableWidget(), NavigationState.Type.CONTENT_MODIFIED);
        }
    }

    protected NavigationState.IDeadStateInfoProvider getDeadStateInfoProvider() {
        return DEAD_STATE_INFO_PROVIDER;
    }

    protected final <T extends Enum<T>> NavigationState createNavigationState(DrawableWidget widget, NavigationState state) {
        FocusMode mode;
        Set highlighted;
        Collection<? extends RepresentationDependency> dependencies;
        Set<RepresentationElement> selected;
        Collection<NamedElement> additionals;
        assert (widget != null) : "Parameter 'widget' of method 'createNavigationState' must not be null";
        assert (state != null) : "Parameter 'state' of method 'createNavigationState' must not be null";
        state.setDeadStateInfoProvider(this.getDeadStateInfoProvider());
        NodeAndEdgeRepresentation representation = widget.getUnderlyingRepresentation();
        state.addElementsInformation((IElementGroup)RepresentationElementGroup.REPRESENTATION, NavigationState.getDescriptors(Arrays.asList(representation), this.getElementResolver()));
        Collection<NamedElement> mainPathNodes = widget.getMainNodes();
        if (mainPathNodes != null) {
            state.addElementsInformation((IElementGroup)RepresentationElementGroup.MAIN_NODES, NavigationState.getDescriptors(mainPathNodes, this.getElementResolver()));
        }
        if ((additionals = widget.getAdditionalElements()) != null) {
            state.addElementsInformation((IElementGroup)RepresentationElementGroup.ADDITIONAL_ELEMENTS, NavigationState.getDescriptors(additionals, this.getElementResolver()));
        }
        if ((selected = widget.getSelectedElements()) != null) {
            state.addElementsInformation((IElementGroup)RepresentationElementGroup.SELECTION, NavigationState.getDescriptors(this.getElementsFromNodes(selected), this.getElementResolver()));
        }
        if ((dependencies = widget.getSelectedRepresentationDependencies()) != null) {
            state.addDependenciesInformation((IElementGroup)RepresentationElementGroup.ENDPOINTS_SELECTION, RepresentationDependency.getDescriptors(dependencies, (IElementResolver)this.getElementResolver()));
        }
        if ((highlighted = widget.getUnderlyingRepresentation().getOriginalNodes()) != null) {
            state.addElementsInformation((IElementGroup)RepresentationElementGroup.ORIGINAL_INPUT, NavigationState.getDescriptors(highlighted, this.getElementResolver()));
        }
        if ((mode = widget.getFocusMode()) != null) {
            state.addConstant((IStateData)RepresentationViewData.FOCUS_MODE, mode);
        }
        state.addConstant((IStateData)RepresentationViewData.DOMAIN, widget.getUnderlyingRepresentation().getDomain());
        Set<CoreParserDependencyType> dependencyTypesForEdges = widget.getParserDependencyTypesForEdges();
        if (dependencyTypesForEdges != null) {
            state.addConstants((IStateData)RepresentationViewData.DEPENDENCY_TYPES_FOR_EDGES, dependencyTypesForEdges);
        }
        PresentationMode presentationMode = widget.getPresentationMode();
        assert (presentationMode != null) : "'presentationMode' of method 'createNavigationState' must not be null";
        state.addConstant((IStateData)RepresentationViewData.PRESENTATION_MODE, presentationMode);
        state.addConstants((IStateData)RepresentationViewData.PROPERTIES, representation.getRepresentationProperties());
        state.addDouble((IStateData)RepresentationViewData.ZOOM_LEVEL, this.getZoomLevel());
        this.completeNavigationState(state);
        return state;
    }

    @Override
    protected final void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        if (this.isReady()) {
            this.createNavigationState(this.getDrawableWidget(), state);
        }
    }

    protected void completeNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeNavigationState' must not be null";
    }

    protected Collection<RepresentationNode> getSelectedRepresentationNodes() {
        List<Element> selectedElements = this.getSelectedElements();
        if (selectedElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RepresentationNode> selectedRepresenationNodes = new ArrayList<RepresentationNode>();
        for (Element element : selectedElements) {
            if (!(element instanceof RepresentationNode)) continue;
            selectedRepresenationNodes.add((RepresentationNode)element);
        }
        return selectedRepresenationNodes;
    }

    public Collection<RepresentationNode> getNodeListFromElements(Collection<? extends Element> elements) {
        ArrayList<RepresentationNode> nodes = new ArrayList<RepresentationNode>(elements.size());
        for (Element element : elements) {
            RepresentationNode node;
            if (!(element instanceof NamedElement) || (node = this.getDrawableWidget().getUnderlyingRepresentation().getNode((NamedElement)element)) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    protected final List<NamedElement> getElementsFromNodes(Collection<? extends RepresentationElement> selected) {
        if (selected != null) {
            ArrayList<NamedElement> selectedElements = new ArrayList<NamedElement>(selected.size());
            for (RepresentationElement representationElement : selected) {
                if (!(representationElement instanceof RepresentationNode)) continue;
                selectedElements.add(((RepresentationNode)representationElement).getUnderlyingObject());
            }
            return selectedElements;
        }
        return null;
    }

    public void setSelection(Collection<NamedElement> elementsToSelect, boolean notify) {
        assert (elementsToSelect != null) : "Parameter 'elementsToSelect' of method 'setSelection' must not be null";
        ArrayList<IDrawableFigure> figures = new ArrayList<IDrawableFigure>();
        for (NamedElement namedElement : elementsToSelect) {
            IDrawableNode node = this.getDrawableWidget().getNode(namedElement);
            if (node == null) continue;
            figures.add(node);
        }
        this.getDrawableWidget().selected(figures, false, notify);
    }

    public void setSelection(Collection<NamedElement> elementsToSelect) {
        this.setSelection(elementsToSelect, true);
    }

    public void refreshSelection() {
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)new StructuredSelection(this.getDrawableWidget().getSelectedElements().toArray()));
    }

    @Override
    public Element getElementAt(int x, int y) {
        return this.getDrawableWidget().getElementAt(x, y);
    }

    @Override
    public final void adjustSelection(int x, int y, boolean aggregateSelection) {
        this.getDrawableWidget().adjustSelection(x, y, aggregateSelection);
    }

    private Image createImage(Shell shell, IFigure figure) {
        assert (shell != null) : "Parameter 'shell' of method 'createImage' must not be null";
        assert (figure != null) : "Parameter 'figure' of method 'createImage' must not be null";
        Rectangle figureBounds = figure.getBounds();
        Image image = new Image((Device)shell.getDisplay(), figureBounds.width, figureBounds.height);
        GC gc = new GC((Drawable)image);
        gc.setAntialias(1);
        try {
            SWTGraphics graphics = new SWTGraphics(gc);
            graphics.translate(-figureBounds.x, -figureBounds.y);
            try {
                figure.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    private void writeImageData(Image image, int format, TFileOutputStream os) {
        assert (image != null) : "Parameter 'image' of method 'writeImageData' must not be null";
        assert (os != null) : "Parameter 'os' of method 'writeAndReturnImageData' must not be null";
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        imageLoader.save((OutputStream)os, format);
    }

    @Override
    public final boolean supportsImageExport() {
        return true;
    }

    @Override
    public final OperationResult exportToImage(TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportImage' must not be null";
        OperationResult result = new OperationResult("Export image");
        boolean validExtension = false;
        int i = 0;
        while (i < ImageExtension.values().length) {
            if (FileUtility.getExtension((TFile)targetFile).equals(ImageExtension.values()[i].getExtension())) {
                validExtension = true;
                break;
            }
            ++i;
        }
        assert (validExtension) : "Invalid image extension: " + targetFile.getAbsolutePath();
        String targetFileExtension = FileUtility.getExtension((TFile)targetFile);
        int imageType = ImageExtension.getSwtImageType(targetFileExtension);
        Image image = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try (TFileOutputStream outputStream = new TFileOutputStream((File)targetFile);){
                    image = this.createImage(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), this.getFigureForImageExport());
                    this.writeImageData(image, imageType, outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_FILE, e, "Failed to export image.", new Object[0]);
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
        return result;
    }

    protected final void refreshUIElements() {
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    @Override
    public final Search supportsSearch() {
        return this.isReady() ? Search.FIND_TEXT : Search.NONE;
    }

    @Override
    protected final ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    @Override
    public final NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        NamedElement elementForLink = null;
        if (element instanceof RepresentationNode) {
            RepresentationNode node = (RepresentationNode)element;
            elementForLink = node.getElement();
        }
        if (elementForLink instanceof IArchitectureAssignmentElement) {
            elementForLink = ((IArchitectureAssignmentElement)elementForLink).getRepresentedElement();
        }
        return elementForLink;
    }

    protected String getHideSelfArcsHandledItemId() {
        return null;
    }

    protected boolean getHideSelfArcsDefaultValue() {
        return false;
    }

    public final void extendFocus(List<Element> selection, boolean onlyVisible) {
        assert (selection != null) : "Parameter 'selection' of method 'extendFocus' must not be null";
        final DrawableWidget drawableWidget = this.getDrawableWidget();
        assert (drawableWidget != null) : "Parameter 'drawableWidget' of method 'extendFocus' must not be null";
        NodeAndEdgeRepresentation currentRepresentation = drawableWidget.getUnderlyingRepresentation();
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'extendFocus' must not be null";
        final ExtendFocusCommand<? extends NodeAndEdgeRepresentation> command = this.getExtendFocusCommand(WorkbenchRegistry.getInstance().getProvider(), drawableWidget.getUnderlyingRepresentation(), selection, onlyVisible);
        UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (exception == null && !drawableWidget.isDisposed()) {
                    drawableWidget.removeListeners();
                    drawableWidget.setRedraw(false);
                    NodeAndEdgeRepresentation representation = command.getRepresenstation();
                    drawableWidget.show(representation, EnumSet.noneOf(DrawableWidget.ShowOption.class));
                    DrawableSlaveView.this.getSelectionProviderAdapter().handleSelectionChanged();
                    DrawableSlaveView.this.getDrawableWidget().highlightOriginalInput();
                    DrawableSlaveView.this.updateHandledMenuItemState(DrawableSlaveView.this.getHighlightOriginalSelectionHandledItemId(), DrawableSlaveView.this.isOriginalSelectionHighlighted());
                    DrawableSlaveView.this.saveViewState(drawableWidget, NavigationState.Type.CONTENT_EXTENDED_FOCUS_WITH_DEPENDENCIES);
                    DrawableSlaveView.this.refreshSelection();
                    drawableWidget.setRedraw(true);
                    drawableWidget.addListeners(DrawableSlaveView.this);
                    DrawableSlaveView.this.refreshUIElements();
                } else {
                    DrawableSlaveView.this.removeRepresentationFromModel(command.getRepresenstation(), false, false);
                    DrawableSlaveView.this.hideView();
                }
            }
        });
    }

    public final void removeFromFocus(List<Element> selection) {
        assert (selection != null) : "Parameter 'selection' of method 'removeFromFocus' must not be null";
        final DrawableWidget drawableWidget = this.getDrawableWidget();
        assert (drawableWidget != null) : "Parameter 'drawableWidget' of method 'removeFromFocus' must not be null";
        NodeAndEdgeRepresentation currentRepresentation = drawableWidget.getUnderlyingRepresentation();
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'removeFromFocus' must not be null";
        final RemoveFromFocusCommand<? extends NodeAndEdgeRepresentation> command = this.getRemoveFromFocusCommand(WorkbenchRegistry.getInstance().getProvider(), drawableWidget.getUnderlyingRepresentation(), selection);
        UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (exception == null && !drawableWidget.isDisposed()) {
                    drawableWidget.removeListeners();
                    drawableWidget.setRedraw(false);
                    NodeAndEdgeRepresentation representation = command.getRepresenstation();
                    drawableWidget.show(representation, EnumSet.noneOf(DrawableWidget.ShowOption.class));
                    DrawableSlaveView.this.getSelectionProviderAdapter().handleSelectionChanged();
                    DrawableSlaveView.this.getDrawableWidget().highlightOriginalInput();
                    DrawableSlaveView.this.updateHandledMenuItemState(DrawableSlaveView.this.getHighlightOriginalSelectionHandledItemId(), DrawableSlaveView.this.isOriginalSelectionHighlighted());
                    DrawableSlaveView.this.saveViewState(drawableWidget, NavigationState.Type.CONTENT_EXTENDED_FOCUS_WITH_DEPENDENCIES);
                    DrawableSlaveView.this.refreshSelection();
                    drawableWidget.setRedraw(true);
                    drawableWidget.addListeners(DrawableSlaveView.this);
                    DrawableSlaveView.this.refreshUIElements();
                } else {
                    DrawableSlaveView.this.removeRepresentationFromModel(command.getRepresenstation(), false, false);
                    DrawableSlaveView.this.hideView();
                }
            }
        });
    }

    protected abstract ExtendFocusCommand<? extends NodeAndEdgeRepresentation> getExtendFocusCommand(ISoftwareSystemProvider var1, NodeAndEdgeRepresentation var2, List<Element> var3, boolean var4);

    protected abstract RemoveFromFocusCommand<? extends NodeAndEdgeRepresentation> getRemoveFromFocusCommand(ISoftwareSystemProvider var1, NodeAndEdgeRepresentation var2, List<Element> var3);

    @Override
    public abstract void requestHome();

    protected abstract void focusRepresentationInView(Collection<RepresentationNode> var1, Set<CoreParserDependencyType> var2, FocusMode var3, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> var4);

    protected abstract IFigure getFigureForImageExport();

    protected abstract CreateRepresentationCommand<? extends NodeAndEdgeRepresentation> getCommandForPresentationModification(NodeAndEdgeRepresentation var1, PresentationMode var2);

    protected String getHighlightOriginalSelectionHandledItemId() {
        return null;
    }

    protected String getShowOnlyDependenciesOfSelectedNodesHandledItemId() {
        return null;
    }

    protected String getShowOnlyViolationsHandledItemId() {
        return null;
    }

    protected String getOnlyVisibleHandledItemId() {
        return null;
    }

    public static enum FocusSelectionType {
        SELECTED,
        UNSELECTED,
        NONE;

    }
}

