/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class ContextMenuContributionInfo {
    private final String m_commandId;
    private final MMenuItem m_menuItem;
    private final IContextMenuContributor m_contributor;

    ContextMenuContributionInfo(String commandId, MMenuItem menuItem, IContextMenuContributor contributor) {
        assert (commandId != null && commandId.length() > 0) : "Parameter 'commandId' of method 'ContextMenuContributionInfo' must not be empty";
        assert (menuItem != null) : "Parameter 'menuItem' of method 'ContextMenuContributionInfo' must not be null";
        assert (contributor != null) : "Parameter 'contributor' of method 'ContextMenuContributionInfo' must not be null";
        this.m_commandId = commandId;
        this.m_menuItem = menuItem;
        this.m_contributor = contributor;
    }

    public String getCommandId() {
        return this.m_commandId;
    }

    public String getLabel() {
        return this.m_menuItem.getLabel();
    }

    private String getImageResourceName(String imageUri) {
        assert (imageUri != null && imageUri.length() > 0) : "Parameter 'imageResourcePath' of method 'getImageResourceName' must not be empty";
        int pos = imageUri.lastIndexOf(47);
        if (pos != -1) {
            imageUri = imageUri.substring(pos + 1);
        }
        if ((pos = imageUri.lastIndexOf(46)) != -1) {
            imageUri = imageUri.substring(0, pos);
        }
        return imageUri;
    }

    public String getImageResourceName() {
        String nextIconURI = this.m_menuItem.getIconURI();
        if (nextIconURI != null && !nextIconURI.isEmpty()) {
            return this.getImageResourceName(nextIconURI);
        }
        return null;
    }

    public MMenuItem getMenuItem() {
        return this.m_menuItem;
    }

    public IContextMenuContributor getContributor() {
        return this.m_contributor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_commandId.hashCode();
        result = 31 * result + this.m_menuItem.hashCode();
        result = 31 * result + this.m_contributor.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContextMenuContributionInfo other = (ContextMenuContributionInfo)obj;
        return this.m_commandId.equals(other.m_commandId) && this.m_menuItem.equals(other.m_menuItem) && this.m_contributor.equals(other.m_contributor);
    }

    public String toString() {
        return "ContextMenuContributionInfo [m_commandId=" + this.m_commandId + ", m_menuItem=" + String.valueOf(this.m_menuItem) + "]";
    }
}

