/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeContributionButton;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public final class ComboWithImages
extends Composite
implements SelectionListener,
DisposeListener {
    private final List<Object> m_items = new ArrayList<Object>();
    private final CLabel m_currentItemLabel;
    private final Menu m_availableItemsMenu;
    private final CompositeContributionButton m_availableItemsButton;
    private final ILabelProvider m_labelProvider;
    private ControlDecoration m_decoration;
    private IItemSelectionListener m_itemSelectionListener;
    private Object m_selectedItem;

    public ComboWithImages(Composite parent, int width, String availableItemsButtonTooltip, ILabelProvider labelProvider, boolean useDefaultBackground) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'ComboWithImages' must not be null";
        assert (availableItemsButtonTooltip != null) : "Parameter 'availableItemsButtonTooltip' of method 'ComboWithImages' must not be null";
        assert (labelProvider != null) : "Parameter 'labelProvider' of method 'ComboWithImages' must not be null";
        this.m_labelProvider = labelProvider;
        GridLayout comboGridLayout = new GridLayout(2, false);
        comboGridLayout.marginTop = 0;
        comboGridLayout.marginBottom = 0;
        comboGridLayout.marginHeight = 0;
        comboGridLayout.marginWidth = 0;
        comboGridLayout.horizontalSpacing = 0;
        comboGridLayout.verticalSpacing = 0;
        this.setLayout((Layout)comboGridLayout);
        Image dropDown = UiResourceManager.getInstance().getImage("DropDown");
        Point dropDownSize = CompositeContributionButton.computeSize(dropDown);
        this.m_currentItemLabel = new CLabel((Composite)this, 0);
        GridData itemLabelGridData = new GridData(4, 2, true, false);
        if (width != -1) {
            itemLabelGridData.widthHint = width;
        }
        itemLabelGridData.heightHint = dropDownSize.y;
        this.m_currentItemLabel.setLayoutData((Object)itemLabelGridData);
        if (useDefaultBackground) {
            this.m_currentItemLabel.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        }
        this.m_currentItemLabel.setMargins(1, 1, 1, 0);
        this.m_availableItemsButton = new CompositeContributionButton(this, dropDown);
        this.m_availableItemsButton.setEnabled(true);
        this.m_availableItemsButton.setLayoutData(new GridData(1, 2, false, false));
        this.m_availableItemsButton.addSelectionListener(this);
        if (!availableItemsButtonTooltip.isEmpty()) {
            this.m_availableItemsButton.setToolTipText(availableItemsButtonTooltip);
        }
        Shell shell = this.m_availableItemsButton.getShell();
        this.m_availableItemsMenu = new Menu((Decorations)shell, 8);
        shell.addDisposeListener((DisposeListener)this);
    }

    public ComboWithImages(Composite parent, int width, String availableItemsButtonTooltip, ILabelProvider labelProvider) {
        this(parent, width, availableItemsButtonTooltip, labelProvider, true);
    }

    public void clearDecoration() {
        if (this.m_decoration != null) {
            this.m_decoration.setDescriptionText("");
            this.m_decoration.hide();
        }
    }

    public void updateDecoration(ValidationResult result) {
        Shell shell;
        assert (result != null) : "Parameter 'result' of method 'updateDecoration' must not be null";
        if (result.isFailure() || result.hasWarnings()) {
            if (this.m_currentItemLabel != null && !this.m_currentItemLabel.isDisposed()) {
                if (this.m_decoration == null) {
                    this.m_decoration = new ControlDecoration((Control)this.m_currentItemLabel, 16512);
                }
                if (result.isFailure()) {
                    this.m_decoration.setImage(UiResourceManager.getInstance().getImage("ErrorMarker"));
                } else {
                    this.m_decoration.setImage(UiResourceManager.getInstance().getImage("WarningMarker"));
                }
                this.m_decoration.setDescriptionText(result.toFormattedString());
                this.m_decoration.show();
            }
        } else {
            this.clearDecoration();
        }
        if (Platform.isMac() && (shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setRedraw(false);
            shell.setBounds(shell.getBounds());
            shell.layout(true, true);
            shell.setRedraw(true);
        }
    }

    public void setSelected(Object select) {
        this.m_currentItemLabel.setText(select != null ? this.m_labelProvider.getText(select) : "");
        this.m_currentItemLabel.setToolTipText(select != null ? this.m_labelProvider.getToolTipText(select) : null);
        this.m_currentItemLabel.setImage(select != null ? this.m_labelProvider.getImage(select) : null);
        this.m_selectedItem = select;
    }

    public void removeItems() {
        this.m_items.clear();
        MenuItem[] menuItemArray = this.m_availableItemsMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem nextMenuItem = menuItemArray[n2];
            nextMenuItem.dispose();
            ++n2;
        }
        this.m_currentItemLabel.setText("");
        this.m_currentItemLabel.setImage(null);
        this.m_selectedItem = null;
    }

    public void setItems(Collection<? extends Object> items, Object select) {
        assert (items != null) : "Parameter 'items' of method 'setItems' must not be null";
        if (!this.m_items.equals(items)) {
            this.removeItems();
            this.m_items.addAll(items);
        }
        if (select == null && this.m_selectedItem != null || select != null && this.m_selectedItem == null || select != null && this.m_selectedItem != null && !select.equals(this.m_selectedItem)) {
            this.m_selectedItem = null;
            if (select == null) {
                if (!this.m_items.isEmpty()) {
                    select = this.m_items.get(0);
                }
            } else {
                boolean exists = false;
                for (Object object : this.m_items) {
                    if (!select.equals(object)) continue;
                    exists = true;
                    break;
                }
                if (!exists) assert (false) : String.valueOf(select) + " is not contained in 'items'";
            }
        }
        this.setSelected(select);
    }

    public Object getSelectedItem() {
        return this.m_selectedItem;
    }

    public void widgetSelected(SelectionEvent event) {
        Display display = this.m_availableItemsButton.getDisplay();
        if (display != null && !display.isDisposed()) {
            MenuItem[] menuItemArray = this.m_availableItemsMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem nextMenuItem = menuItemArray[n2];
                nextMenuItem.dispose();
                ++n2;
            }
            if (this.m_items != null) {
                final ComboWithImages source = this;
                for (final Object nextItem : this.m_items) {
                    MenuItem nextMenuItem = new MenuItem(this.m_availableItemsMenu, 8);
                    nextMenuItem.setText(this.m_labelProvider.getText(nextItem));
                    nextMenuItem.setImage(this.m_labelProvider.getImage(nextItem));
                    nextMenuItem.setEnabled(!nextItem.equals(this.m_selectedItem));
                    nextMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ComboWithImages.this.setSelected(nextItem);
                            if (ComboWithImages.this.m_itemSelectionListener != null) {
                                ComboWithImages.this.m_itemSelectionListener.itemSelected(source, nextItem);
                            }
                        }
                    });
                }
            }
            Point loc = this.m_availableItemsButton.getLocation();
            Rectangle rect = this.m_availableItemsButton.getBounds();
            Point mLoc = new Point(loc.x - 1, loc.y + rect.height);
            this.m_availableItemsMenu.setLocation(display.map((Control)this.m_availableItemsButton.getParent(), null, mLoc));
            this.m_availableItemsMenu.setVisible(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setSelectionListener(IItemSelectionListener selectionListener) {
        this.m_itemSelectionListener = selectionListener;
    }

    public void setEnabled(boolean enabled) {
        this.m_availableItemsButton.setEnabled(enabled);
        this.m_currentItemLabel.setEnabled(enabled);
        super.setEnabled(enabled);
        this.redraw();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.m_availableItemsButton.removeSelectionListener(this);
    }

    public static interface IItemSelectionListener {
        public void itemSelected(ComboWithImages var1, Object var2);
    }

    public static interface ILabelProvider {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public Image getImage(Object var1);

        public String getText(Object var1);

        default public String getToolTipText(Object item) {
            assert (item != null) : "Parameter 'item' of method 'getToolTipText' must not be null";
            return null;
        }
    }
}

