/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkbenchViewSelection {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchViewSelection.class);
    private final IWorkbenchView m_workbenchView;
    private final List<Element> m_elements;

    public WorkbenchViewSelection(IWorkbenchView workbenchView, List<Element> elements) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'WorkbenchViewSelection' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'WorkbenchViewSelection' must not be null";
        this.m_workbenchView = workbenchView;
        this.m_elements = new ArrayList<Element>(elements);
    }

    public IWorkbenchView getWorkbenchView() {
        return this.m_workbenchView;
    }

    public List<Element> getElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        Iterator<Element> iter = this.m_elements.iterator();
        while (iter.hasNext()) {
            Element next = iter.next();
            if (next == null) {
                LOGGER.debug("Remove null element from selection (" + this.m_workbenchView.getClass().getName() + ": " + String.valueOf(this.m_workbenchView.getViewId()) + ")");
                iter.remove();
                continue;
            }
            if (!next.isValid()) {
                LOGGER.debug("Remove invalid element from selection: " + next.getShortName() + "[" + next.getClass().getName() + "] (" + this.m_workbenchView.getClass().getName() + ": " + String.valueOf(this.m_workbenchView.getViewId()) + ")");
                iter.remove();
                continue;
            }
            elements.add(next);
        }
        elements.trimToSize();
        return elements;
    }

    public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    public int size() {
        return this.getElements().size();
    }

    public String toString() {
        return "WorkbenchViewSelection [m_workbenchView=" + String.valueOf(this.m_workbenchView) + ", m_elements=" + String.valueOf(this.getElements()) + "]";
    }
}

