/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

final class TreeViewerTextFilter<T>
extends ViewerFilter {
    private final Set<T> m_matches = new HashSet<T>();
    private final Set<T> m_notMatched = new HashSet<T>();
    private final Set<Option> m_options;
    private final List<ILabelProvider> m_labelProviders;
    private final Predicate<String> m_filterPredicate;
    private final Predicate<T> m_leafPredicate;
    private final Function<T, Collection<T>> m_childrenFunction;
    private final Class<T> m_clazz;

    TreeViewerTextFilter(Class<T> clazz, String filterText, Set<Option> options, List<ILabelProvider> labelProviders, Predicate<T> leafPredicate, Function<T, Collection<T>> childrenSupplier) {
        String text = filterText.toLowerCase();
        this.m_filterPredicate = s -> s != null && s.toLowerCase().contains(text);
        this.m_options = options;
        this.m_labelProviders = labelProviders;
        this.m_leafPredicate = leafPredicate;
        this.m_childrenFunction = childrenSupplier;
        this.m_clazz = clazz;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.m_clazz.isAssignableFrom(element.getClass())) {
            Object node = element;
            return this.anyNodeMatches(node, this.m_filterPredicate);
        }
        return true;
    }

    private boolean anyNodeMatches(T node, Predicate<String> predicate) {
        if (this.m_matches.contains(node)) {
            return true;
        }
        if (this.m_notMatched.contains(node)) {
            return false;
        }
        if (this.anyColumnMatches(node, predicate)) {
            if (this.m_options.contains((Object)Option.FILTER_LEAFS_ONLY)) {
                if (this.m_leafPredicate.test(node)) {
                    this.m_matches.add(node);
                    return true;
                }
            } else {
                this.m_matches.add(node);
                for (T next : this.m_childrenFunction.apply(node)) {
                    if (!this.anyNodeMatches(next, n -> true)) continue;
                    this.m_matches.add(next);
                }
                return true;
            }
        }
        for (T next : this.m_childrenFunction.apply(node)) {
            if (!this.anyNodeMatches(next, predicate)) continue;
            this.m_matches.add(node);
            return true;
        }
        this.m_notMatched.add(node);
        return false;
    }

    private boolean anyColumnMatches(T node, Predicate<String> predicate) {
        for (ILabelProvider next : this.m_labelProviders) {
            if (!predicate.test(next.getText(node))) continue;
            return true;
        }
        return false;
    }

    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        return super.filter(viewer, parentPath, elements);
    }

    public boolean hasFilteredElements() {
        return !this.m_notMatched.isEmpty();
    }

    public static enum Option {
        FILTER_LEAFS_ONLY;

    }
}

