/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.AbstractLayout;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Layer;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Control;

public abstract class DrawableViewLayout
extends AbstractLayout
implements ControlListener {
    private NodeAllocation m_nodeAllocation = NodeAllocation.HORIZONTAL_AND_VERTICAL;
    private Dimension m_currentNeededSize = new Dimension();
    private Control m_displayingControl;
    private Layer m_nodesLayer;
    private Layer m_bottomLayer;
    private boolean m_layoutInitialized;

    protected DrawableViewLayout() {
    }

    protected final boolean layoutInitialized() {
        return this.m_layoutInitialized;
    }

    protected void connect(Control displayingControl, Layer bottomLayer, Layer edgesLayer, Layer nodesLayer, Layer topLayer) {
        assert (displayingControl != null) : "Parameter 'displayingControl' of method 'connect' must not be null";
        assert (bottomLayer != null) : "Parameter 'bottomLayer' of method 'connect' must not be null";
        assert (edgesLayer != null) : "Parameter 'edgesLayer' of method 'connect' must not be null";
        assert (nodesLayer != null) : "Parameter 'nodesLayer' of method 'connect' must not be null";
        assert (topLayer != null) : "Parameter 'topLayer' of method 'connect' must not be null";
        assert (this.m_displayingControl == null) : "Parameter 'm_displayingControl' of method 'connect' must be null";
        this.m_displayingControl = displayingControl;
        assert (this.m_nodesLayer == null) : "'m_nodesLayer' of method 'connect' must be null";
        this.m_nodesLayer = nodesLayer;
        assert (this.m_bottomLayer == null) : "'m_bottomLayer' of method 'connect' must be null";
        this.m_bottomLayer = bottomLayer;
    }

    void dispose() {
        if (this.m_layoutInitialized) {
            assert (this.m_displayingControl != null) : "'m_displayingControl' of method 'dispose' must not be null";
            this.m_displayingControl.removeControlListener((ControlListener)this);
            this.m_displayingControl = null;
        }
    }

    protected final Control getDisplayingControl() {
        assert (this.m_displayingControl != null) : "'m_displayingControl' of method 'getDisplayingControl' must not be null";
        return this.m_displayingControl;
    }

    protected abstract NodeAllocation getDefaultNodeAllocation();

    protected abstract Dimension layout(List<IDrawableNode> var1, NodeAllocation var2);

    protected void finishNodeCreation(NodeAdapter nodeAdapter, IDrawableNode node) {
        assert (nodeAdapter != null) : "Parameter 'nodeAdapter' of method 'finishNodeCreation' must not be null";
        assert (node != null) : "Parameter 'node' of method 'finishNodeCreation' must not be null";
    }

    protected void clear() {
        this.m_nodeAllocation = NodeAllocation.HORIZONTAL_AND_VERTICAL;
        this.m_layoutInitialized = false;
        this.m_displayingControl.removeControlListener((ControlListener)this);
    }

    public final void controlMoved(ControlEvent event) {
    }

    public final void controlResized(ControlEvent event) {
        assert (this.m_nodesLayer != null) : "'m_nodesLayer' of method 'controlResized' must not be null";
        this.layout(this.m_nodesLayer);
    }

    void home() {
        assert (this.m_nodesLayer != null) : "'m_nodesLayer' of method 'home' must not be null";
        this.m_nodeAllocation = NodeAllocation.HORIZONTAL_AND_VERTICAL;
        this.layout(this.m_nodesLayer);
        this.m_nodeAllocation = this.getDefaultNodeAllocation();
    }

    void reLayout() {
        assert (this.m_nodesLayer != null) : "'m_nodesLayer' of method 'reLayout' must not be null";
        this.layout(this.m_nodesLayer);
    }

    private List<IDrawableNode> getNodes(List rawNodes) {
        assert (rawNodes != null) : "Parameter 'rawNodes' of method 'orderNodes' must not be null";
        if (rawNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IDrawableNode> nodes = new ArrayList<IDrawableNode>(rawNodes.size());
        for (Object nextNode : rawNodes) {
            assert (nextNode != null && nextNode instanceof IDrawableNode) : "Unexpected class in method 'getNodes': " + String.valueOf(nextNode);
            nodes.add((IDrawableNode)nextNode);
        }
        return nodes;
    }

    @Override
    public final void layout(IFigure container) {
        Dimension size;
        assert (container != null) : "Parameter 'container' of method 'layout' must not be null";
        assert (this.m_displayingControl != null) : "'m_displayingControl' of method 'layout' must not be null";
        List<IDrawableNode> nodes = this.getNodes(container.getChildren());
        if (nodes.isEmpty()) {
            size = new Dimension();
        } else {
            size = this.layout(nodes, this.m_nodeAllocation);
            if (!this.m_layoutInitialized) {
                this.m_nodeAllocation = this.getDefaultNodeAllocation();
                this.m_displayingControl.addControlListener((ControlListener)this);
                this.m_layoutInitialized = true;
            }
        }
        this.setNeededSize(size);
    }

    @Override
    protected final Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        assert (container != null) : "Parameter 'container' of method 'calculatePreferredSize' must not be null";
        List<IDrawableNode> nodes = this.getNodes(container.getChildren());
        Dimension size = nodes.isEmpty() ? new Dimension() : this.layout(nodes, NodeAllocation.NONE);
        if (wHint != -1) {
            size.width = wHint;
        }
        if (hHint != -1) {
            size.height = hHint;
        }
        size.expand(container.getInsets().getWidth(), container.getInsets().getHeight());
        size.union(this.getBorderPreferredSize(container));
        this.setNeededSize(size);
        return size;
    }

    public final Dimension getNeededSize() {
        assert (this.m_currentNeededSize != null) : "'m_currentNeededSize' of method 'getNeededSize' must not be null";
        return this.m_currentNeededSize;
    }

    protected final void setNeededSize(Dimension size) {
        assert (size != null) : "Parameter 'size' of method 'setNeededSize' must not be null";
        this.m_currentNeededSize = size;
    }

    public static enum NodeAllocation {
        NONE,
        HORIZONTAL,
        VERTICAL,
        HORIZONTAL_AND_VERTICAL;

    }
}

