/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.AbstractConnectionAnchor;
import com.hello2morrow.draw2d.AnchorListener;
import com.hello2morrow.draw2d.ArrowLocator;
import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.ConnectionAnchor;
import com.hello2morrow.draw2d.ConnectionRouter;
import com.hello2morrow.draw2d.DelegatingLayout;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.PolygonDecoration;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.RotatableDecoration;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.foundation.utilities.ByteBitFieldUtil;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import org.eclipse.swt.graphics.Color;

public abstract class DrawableEdge<T extends IDrawableNode>
extends Figure
implements IDrawableNode.IDrawableEdge<T>,
Connection,
AnchorListener {
    protected static final int SPACING = 4;
    protected static final int MAX_LINE_WIDTH = 5;
    private static final int MIN_LINE_WIDTH = 1;
    private static final int STEP_1 = 5;
    private static final int STEP_2 = 25;
    private static final int STEP_3 = 125;
    private final IDrawableFigure.IDrawableFigureListener m_figureListener;
    private final AbstractConnectionAnchor m_sourceAnchor;
    private final AbstractConnectionAnchor m_targetAnchor;
    private final int m_weight;
    private int m_violationWeight;
    private final RepresentationEdge<? extends RepresentationNode> m_edge;
    private final PolygonDecoration m_decoration;
    private final PointList m_pointList = new PointList();
    private EdgeAdapter.ArchitectureViolationMode m_architectureViolationMode;
    private Color m_activeLineColor = UiResourceManager.getInstance().getDisabledColor();
    private byte m_state;

    public DrawableEdge(IDrawableFigure.IDrawableFigureListener listener, RepresentationEdge<? extends RepresentationNode> edge, AbstractConnectionAnchor fromAnchor, AbstractConnectionAnchor toAnchor, boolean directed, boolean architectureEnabled) {
        assert (listener != null) : "Parameter 'listener' of method 'PolylineBasedEdge' must not be null";
        assert (edge != null) : "Parameter 'edge' of method 'DrawableEdge' must not be null";
        assert (fromAnchor != null) : "Parameter 'fromAnchor' of method 'PolylineBasedEdge' must not be null";
        assert (toAnchor != null) : "Parameter 'toAnchor' of method 'PolylineBasedEdge' must not be null";
        this.m_figureListener = listener;
        this.m_sourceAnchor = fromAnchor;
        this.m_targetAnchor = toAnchor;
        this.m_weight = edge.getWeight();
        this.m_violationWeight = edge.getNumberOfViolatingParserDependencies();
        this.setLayoutManager(new DelegatingLayout());
        if (directed) {
            PointList decorationPointList = new PointList();
            Point one = new Point(0, 0);
            Point two = new Point(-2, 2);
            Point tree = new Point(-2, -2);
            this.translateToAbsolute(one);
            this.translateToAbsolute(two);
            this.translateToAbsolute(tree);
            decorationPointList.addPoint(one);
            decorationPointList.addPoint(two);
            decorationPointList.addPoint(tree);
            this.m_decoration = new PolygonDecoration();
            this.m_decoration.setTemplate(decorationPointList);
            this.add((IFigure)this.m_decoration, new ArrowLocator(this, 3));
        } else {
            this.m_decoration = null;
        }
        this.m_edge = edge;
        this.setArchitectureEnabled(architectureEnabled);
        this.updateColorForArchitectureViolations();
    }

    @Override
    public final void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        this.m_sourceAnchor.addAnchorListener(this);
        this.m_targetAnchor.addAnchorListener(this);
    }

    @Override
    public final void removeNotify() {
        this.m_sourceAnchor.removeAnchorListener(this);
        this.m_targetAnchor.removeAnchorListener(this);
        this.getConnectionRouter().remove(this);
        super.removeNotify();
    }

    private void updateColorForArchitectureViolations() {
        if (this.architectureEnabled()) {
            this.m_architectureViolationMode = this.m_edge.getArchitectureViolationMode();
            this.m_violationWeight = this.m_edge.getNumberOfViolatingParserDependencies();
        } else {
            this.m_architectureViolationMode = EdgeAdapter.ArchitectureViolationMode.ARCHITECTURE_NOT_ENABLED;
            this.m_violationWeight = 0;
        }
        switch (this.m_architectureViolationMode) {
            case ARCHITECTURE_NOT_ENABLED: {
                this.m_activeLineColor = UiResourceManager.getInstance().getDisabledColor();
                break;
            }
            case NO_VIOLATIONS: {
                this.m_activeLineColor = UiResourceManager.getInstance().getNoneViolatingConnectionColor();
                break;
            }
            case PARTIAL_VIOLATION: {
                this.m_activeLineColor = UiResourceManager.getInstance().getMixedConnectionColor();
                break;
            }
            case FULL_VIOLATION: {
                this.m_activeLineColor = UiResourceManager.getInstance().getViolatingConnectionColor();
                break;
            }
            case NOT_RELEVANT_FOR_ARCHITECTURE: {
                this.m_activeLineColor = UiResourceManager.getInstance().getDisabledColor();
                break;
            }
            default: {
                assert (false) : "Unexpected architecture violation mode " + String.valueOf(this.m_edge.getArchitectureViolationMode());
                this.m_activeLineColor = null;
            }
        }
        this.invalidate();
    }

    protected final int computeLineWidth() {
        int weight = this.paintViolationsOnly() ? this.getViolationWeight() : this.getWeight();
        int width = 1;
        if (this.isSelected()) {
            ++width;
        }
        if (weight <= 5) {
            return width;
        }
        if (weight <= 25) {
            return width + 1;
        }
        if (weight <= 125) {
            return width + 2;
        }
        return width + 3;
    }

    @Override
    public final int getWeight() {
        return this.m_weight;
    }

    protected final int getViolationWeight() {
        return this.m_violationWeight;
    }

    protected final boolean shouldHideOnPaintViolationsOnly() {
        return this.m_architectureViolationMode != EdgeAdapter.ArchitectureViolationMode.ARCHITECTURE_NOT_ENABLED && this.paintViolationsOnly() && this.getViolationWeight() == 0;
    }

    @Override
    public final T getFrom() {
        return (T)((IDrawableNode)this.getSourceAnchor().getOwner());
    }

    @Override
    public final T getTo() {
        return (T)((IDrawableNode)this.getTargetAnchor().getOwner());
    }

    protected final Color getInactiveLineColor() {
        return UiResourceManager.getInstance().getColor(UiResourceManager.VERY_LIGHT_GREY);
    }

    protected final Color getActiveLineColor() {
        return this.m_activeLineColor;
    }

    public PointList getPointList() {
        return this.m_pointList;
    }

    public final boolean isHighlighted() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.IS_HIGHLIGHTED.ordinal())));
    }

    @Override
    public final IDrawableFigure.IDrawableFigureListener getListener() {
        return this.m_figureListener;
    }

    public RotatableDecoration getDecoration() {
        return this.m_decoration;
    }

    @Override
    public final void setSelected(boolean selected) {
        this.m_state = selected ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.IS_SELECTED.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.IS_SELECTED.ordinal())));
        this.invalidate();
    }

    @Override
    public final void setHighlight(boolean highlight) {
        this.m_state = highlight ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.IS_HIGHLIGHTED.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.IS_HIGHLIGHTED.ordinal())));
        this.invalidate();
    }

    @Override
    public final void setPaintViolationsOnly(boolean paintViolationsOnly) {
        this.m_state = paintViolationsOnly ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.PAINT_VIOLATIONS_ONLY.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.PAINT_VIOLATIONS_ONLY.ordinal())));
        this.invalidate();
    }

    protected final boolean paintViolationsOnly() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.PAINT_VIOLATIONS_ONLY.ordinal())));
    }

    @Override
    public void setHideSelfArcs(boolean hideSelfArcs) {
        this.m_state = hideSelfArcs ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.HIDE_SELF_ARCS.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.HIDE_SELF_ARCS.ordinal())));
        this.invalidate();
    }

    protected final boolean hideSelfArcs() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.HIDE_SELF_ARCS.ordinal())));
    }

    @Override
    public final boolean isSelected() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.IS_SELECTED.ordinal())));
    }

    private final void setArchitectureEnabled(boolean architectureEnabled) {
        this.m_state = architectureEnabled ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.ARCHITECTURE_ENABLED.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.ARCHITECTURE_ENABLED.ordinal())));
        this.invalidate();
    }

    private final boolean architectureEnabled() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << EdgeProperty.ARCHITECTURE_ENABLED.ordinal())));
    }

    @Override
    public final ConnectionRouter getConnectionRouter() {
        return ConnectionRouter.NULL;
    }

    @Override
    public final void setConnectionRouter(ConnectionRouter router) {
        assert (false) : "'setConnectionRouter' not supported";
    }

    @Override
    public final ConnectionAnchor getSourceAnchor() {
        return this.m_sourceAnchor;
    }

    @Override
    public final ConnectionAnchor getTargetAnchor() {
        return this.m_targetAnchor;
    }

    @Override
    public final Object getRoutingConstraint() {
        return ConnectionRouter.NULL.getConstraint(this);
    }

    @Override
    public final void setRoutingConstraint(Object constraint) {
        ConnectionRouter.NULL.setConstraint(this, constraint);
    }

    @Override
    public final void setSourceAnchor(ConnectionAnchor anchor) {
        assert (false) : "Method 'setSourceAnchor' must not be used";
    }

    @Override
    public final void setTargetAnchor(ConnectionAnchor anchor) {
        assert (false) : "Method 'setTargetAnchor' must not be used";
    }

    @Override
    public final PointList getPoints() {
        return this.m_pointList;
    }

    @Override
    public final void revalidate() {
        super.revalidate();
        ConnectionRouter.NULL.invalidate(this);
    }

    @Override
    public final void repaint() {
        this.updateColorForArchitectureViolations();
        super.repaint();
    }

    @Override
    public final void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            ConnectionRouter.NULL.route(this);
        }
        Rectangle oldBounds = this.bounds;
        super.layout();
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent(oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.m_decoration != null) {
            this.m_decoration.setVisible(visible);
        }
    }

    public final RepresentationEdge<? extends RepresentationNode> getRepresentationElement() {
        return this.m_edge;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DrawableEdge for: ");
        sb.append(this.getRepresentationElement());
        return sb.toString();
    }

    public static enum EdgeProperty {
        IS_SELECTED,
        IS_HIGHLIGHTED,
        PAINT_VIOLATIONS_ONLY,
        HIDE_SELF_ARCS,
        ARCHITECTURE_ENABLED;

    }
}

