/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.GraphicsSource;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.SWTGraphics;
import com.hello2morrow.draw2d.UpdateManager;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public final class DrawUpdateManager
extends UpdateManager {
    private final Set<IFigure> m_addedFigures = new THashSet();
    private final List<IFigure> m_invalidFigures = new ArrayList<IFigure>();
    private Map<IFigure, Rectangle> m_dirtyRegions = new THashMap();
    private Rectangle m_damage;
    private GraphicsSource m_graphicsSource;
    private IFigure m_root;
    private RunnableChain m_afterUpdate;
    private boolean m_updateQueued;
    private boolean m_updating;
    private boolean m_validating;

    DrawUpdateManager() {
    }

    @Override
    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        if (w == 0 || h == 0 || !figure.isShowing()) {
            return;
        }
        Rectangle rect = this.m_dirtyRegions.get(figure);
        if (rect == null) {
            this.m_dirtyRegions.put(figure, new Rectangle(x, y, w, h));
        } else {
            rect.union(x, y, w, h);
        }
        this.queueWork();
    }

    @Override
    public synchronized void addInvalidFigure(IFigure figure) {
        if (this.m_addedFigures.add(figure)) {
            this.queueWork();
            this.m_invalidFigures.add(figure);
        }
    }

    private Graphics getGraphics(Rectangle region) {
        if (this.m_graphicsSource == null) {
            return null;
        }
        return this.m_graphicsSource.getGraphics(region);
    }

    private void releaseGraphics(Graphics graphics) {
        graphics.dispose();
        this.m_graphicsSource.flushGraphics(this.m_damage);
    }

    @Override
    protected void paint(GC gc) {
        if (!this.m_validating) {
            SWTGraphics graphics = new SWTGraphics(gc);
            if (!this.m_updating) {
                Rectangle rect = graphics.getClip(new Rectangle());
                THashMap map = new THashMap();
                map.put(this.m_root, rect);
                this.firePainting(rect, (Map)map);
            }
            this.performValidation();
            this.m_root.paint(graphics);
            graphics.dispose();
        } else {
            this.addDirtyRegion(this.m_root, new Rectangle(gc.getClipping()));
        }
    }

    private void repairDirtyRegions() {
        if (!this.m_dirtyRegions.isEmpty()) {
            Graphics graphics;
            this.m_damage = new Rectangle();
            for (Map.Entry<IFigure, Rectangle> nextEntry : this.m_dirtyRegions.entrySet()) {
                IFigure figure = nextEntry.getKey();
                IFigure walker = figure.getParent();
                Rectangle contribution = nextEntry.getValue();
                contribution.intersect(figure.getBounds());
                while (!contribution.isEmpty() && walker != null) {
                    walker.translateToParent(contribution);
                    contribution.intersect(walker.getBounds());
                    walker = walker.getParent();
                }
                this.m_damage.union(contribution);
            }
            Map<IFigure, Rectangle> oldRegions = this.m_dirtyRegions;
            this.m_dirtyRegions = new THashMap();
            this.firePainting(this.m_damage, oldRegions);
            if (!this.m_damage.isEmpty() && (graphics = this.getGraphics(this.m_damage)) != null) {
                this.m_root.paint(graphics);
                this.releaseGraphics(graphics);
            }
            this.m_damage = null;
        }
    }

    @Override
    public synchronized void performUpdate() {
        if (this.isDisposed() || this.m_updating) {
            return;
        }
        this.m_updating = true;
        try {
            this.performValidation();
            this.m_updateQueued = false;
            this.repairDirtyRegions();
            if (this.m_afterUpdate != null) {
                RunnableChain chain = this.m_afterUpdate;
                this.m_afterUpdate = null;
                chain.run();
                if (this.m_afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        finally {
            this.m_updating = false;
        }
    }

    @Override
    public synchronized void performValidation() {
        if (this.m_invalidFigures.isEmpty() || this.m_validating) {
            return;
        }
        try {
            this.m_validating = true;
            this.fireValidating();
            int i = 0;
            while (i < this.m_invalidFigures.size()) {
                IFigure fig = this.m_invalidFigures.get(i);
                this.m_invalidFigures.set(i, null);
                this.m_addedFigures.remove(fig);
                fig.validate();
                ++i;
            }
        }
        finally {
            this.m_invalidFigures.clear();
            this.m_addedFigures.clear();
            this.m_validating = false;
        }
    }

    @Override
    public synchronized void performUpdate(Rectangle exposed) {
        this.addDirtyRegion(this.m_root, exposed);
        this.performUpdate();
    }

    private void queueWork() {
        if (!this.m_updateQueued) {
            this.sendUpdateRequest();
            this.m_updateQueued = true;
        }
    }

    private void sendUpdateRequest() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new SWTException(22);
        }
        display.asyncExec((Runnable)new UpdateRequest());
    }

    @Override
    public synchronized void runWithUpdate(Runnable runnable) {
        this.m_afterUpdate = new RunnableChain(runnable, this.m_afterUpdate);
        if (!this.m_updating) {
            this.queueWork();
        }
    }

    @Override
    public void setGraphicsSource(GraphicsSource gs) {
        this.m_graphicsSource = gs;
    }

    @Override
    public void setRoot(IFigure figure) {
        this.m_root = figure;
    }

    private static class RunnableChain {
        RunnableChain m_next;
        Runnable m_run;

        RunnableChain(Runnable run, RunnableChain next) {
            this.m_run = run;
            this.m_next = next;
        }

        void run() {
            if (this.m_next != null) {
                this.m_next.run();
            }
            this.m_run.run();
        }
    }

    private class UpdateRequest
    implements Runnable {
        UpdateRequest() {
        }

        @Override
        public void run() {
            DrawUpdateManager.this.performUpdate();
        }
    }
}

