/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeHandler
extends CommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandHandler.class);

    @Override
    public final IContextMenuContributor createContextMenuContributor() {
        return new CompositeHandlerContextMenuContributor();
    }

    protected abstract String getCorrespondingMenuItem();

    protected abstract boolean opensDialog();

    protected abstract CompositeCommandAdapter.Type getType();

    private boolean showInContextMenuInternal(IWorkbenchView workbenchView, List<Element> elements) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenuInternal' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'showInContextMenuInternal' must not be null";
        for (CompositeCommandAdapter nextAdapter : CompositeCommandRegistry.getInstance().get(this.getType())) {
            ISoftwareSystemProvider provider;
            CompositeCommandAdapter.Applicable applicable = nextAdapter.applicable(provider = WorkbenchRegistry.getInstance().getProvider(), elements);
            if (applicable == null) continue;
            return nextAdapter.showInContextMenu(workbenchView, elements);
        }
        return false;
    }

    private String getContextMenuLabelInternal(IWorkbenchView workbenchView, List<Element> elements, String defaultLabel) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'getContextMenuLabelInternal' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getContextMenuLabelInternal' must not be null";
        assert (defaultLabel != null && defaultLabel.length() > 0) : "Parameter 'defaultLabel' of method 'getContextMenuLabelInternal' must not be empty";
        for (CompositeCommandAdapter nextAdapter : CompositeCommandRegistry.getInstance().get(this.getType())) {
            ISoftwareSystemProvider provider;
            CompositeCommandAdapter.Applicable applicable = nextAdapter.applicable(provider = WorkbenchRegistry.getInstance().getProvider(), elements);
            if (applicable == null) continue;
            return applicable.getContextMenuLabel(this.getType(), this.opensDialog());
        }
        return defaultLabel;
    }

    protected final CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        List<CompositeCommandAdapter> adapters = CompositeCommandRegistry.getInstance().get(this.getType());
        SoftwareSystem softwareSystem = provider.hasSoftwareSystem() ? provider.getSoftwareSystem() : null;
        CompositeCommandAdapter.Applicable isApplicable = null;
        for (CompositeCommandAdapter nextAdapter : adapters) {
            CompositeCommandAdapter.Applicable nextApplicable;
            if (!SonargraphCommand.isAvailable((ICommandId)nextAdapter.getCorrespondingCommandId(), (SoftwareSystem)softwareSystem) || (nextApplicable = nextAdapter.applicable(provider, elements)) == null) continue;
            if (isApplicable != null) {
                LOGGER.warn("Command adapter conflict: " + String.valueOf(isApplicable) + "/" + String.valueOf(nextApplicable));
                continue;
            }
            isApplicable = nextApplicable;
        }
        return isApplicable;
    }

    protected final void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        List<CompositeCommandAdapter> adapters = CompositeCommandRegistry.getInstance().get(this.getType());
        SoftwareSystem softwareSystem = provider.hasSoftwareSystem() ? provider.getSoftwareSystem() : null;
        boolean applied = false;
        for (CompositeCommandAdapter nextAdapter : adapters) {
            CompositeCommandAdapter.Applicable isApplicable;
            if (!SonargraphCommand.isAvailable((ICommandId)nextAdapter.getCorrespondingCommandId(), (SoftwareSystem)softwareSystem) || (isApplicable = nextAdapter.applicable(provider, elements)) == null) continue;
            nextAdapter.apply(provider, elements);
            applied = true;
            break;
        }
        assert (applied) : "Not applied";
    }

    @CanExecute
    public final boolean canExecute(IEclipseContext eclipseContext, @Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection, @Optional MMenuItem menuItem) {
        if (menuItem == null) {
            MMenuItem found = RcpUtility.findUniqueModelElement(eclipseContext, (MUIElement)WorkbenchRegistry.getInstance().getMainApplicationWindow().getMainMenu(), this.getCorrespondingMenuItem(), MMenuItem.class);
            assert (found != null) : "'found' of method 'canExecute' must not be null";
            menuItem = found;
        }
        menuItem.setLabel(this.getType().getPresentationName());
        if (SonargraphCommand.isAvailable((SonargraphCategory)SonargraphCategory.SYSTEM_MODIFICATION, (SoftwareSystem)WorkbenchRegistry.getInstance().getSoftwareSystem())) {
            ISoftwareSystemProvider provider;
            CompositeCommandAdapter.Applicable applicable;
            CompositeHandler.setVisibility(menuItem, true);
            if (WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED) && (applicable = this.applicable(provider = WorkbenchRegistry.getInstance().getProvider(), selection != null ? selection.getElements() : Collections.emptyList())) != null) {
                menuItem.setLabel(applicable.getMenuLabel(this.getType(), this.opensDialog()));
                return true;
            }
        } else {
            CompositeHandler.setVisibility(menuItem, false);
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        this.apply(WorkbenchRegistry.getInstance().getProvider(), selection != null ? selection.getElements() : Collections.emptyList());
    }

    private final class CompositeHandlerContextMenuContributor
    implements IContextMenuContributor {
        private CompositeHandlerContextMenuContributor() {
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof CompositeHandlerContextMenuContributor;
        }

        @Override
        public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> elements) {
            assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
            assert (elements != null) : "Parameter 'elements' of method 'showInContextMenu' must not be null";
            return CompositeHandler.this.showInContextMenuInternal(workbenchView, elements);
        }

        @Override
        public String getLabel(IWorkbenchView workbenchView, List<Element> elements, String defaultLabel) {
            assert (workbenchView != null) : "Parameter 'workbenchView' of method 'getLabel' must not be null";
            assert (elements != null) : "Parameter 'elements' of method 'getLabel' must not be null";
            assert (defaultLabel != null && defaultLabel.length() > 0) : "Parameter 'defaultLabel' of method 'getLabel' must not be empty";
            return CompositeHandler.this.getContextMenuLabelInternal(workbenchView, elements, defaultLabel);
        }
    }
}

