/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.WildcardAutoCompleteField;
import com.hello2morrow.sonargraph.ui.swt.base.WildcardContentProposalProvider;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class ValidatingTextWidget
extends ValidatingTextOrComboWidget {
    private final Text m_textField;
    private WildcardAutoCompleteField m_autoCompletionField;

    private ValidatingTextWidget(Composite parent, ITextValidator validator, ValidatingTextOrComboWidget.IConsumer consumer, List<String> proposals, Set<WildcardContentProposalProvider.WildcardPosition> wildcardPositions, String value, boolean validateAtCreation, boolean isMultiLine, int swtFlags) {
        super(parent, validator, consumer, value);
        assert (wildcardPositions != null) : "Parameter 'wildcardPositions' of method 'ValidatingTextWidget' must not be null";
        this.m_textField = SwtUtility.createTextFieldForGridLayout(this, isMultiLine, swtFlags);
        if (value != null) {
            this.m_textField.setText(value);
        }
        if (validateAtCreation) {
            this.validate(false);
        }
        if (proposals != null) {
            this.m_autoCompletionField = new WildcardAutoCompleteField((Control)this.m_textField, (IControlContentAdapter)new TextContentAdapter(), proposals.toArray(new String[proposals.size()]), wildcardPositions);
        }
        this.m_textField.addModifyListener((ModifyListener)this);
    }

    public boolean setFocus() {
        return this.m_textField.setFocus();
    }

    @Override
    public Control getControl() {
        return this.m_textField;
    }

    public void updateProposals(String[] proposals) {
        assert (proposals != null) : "Parameter 'proposals' of method 'updateProposals' must not be null";
        assert (this.m_autoCompletionField != null) : "Not autocompletion enabled";
        this.m_autoCompletionField.setProposals(proposals);
        if (proposals.length == 0) {
            this.m_textField.setText("");
        } else {
            this.m_textField.setText(proposals[0]);
        }
    }

    public ValidatingTextWidget(Composite parent, ITextValidator validator, ValidatingTextOrComboWidget.IConsumer consumer, String value, boolean validateAtCreation, boolean isMultiLine, int swtFlags) {
        this(parent, validator, consumer, null, EnumSet.noneOf(WildcardContentProposalProvider.WildcardPosition.class), value, validateAtCreation, isMultiLine, swtFlags);
    }

    public ValidatingTextWidget(Composite parent, ITextValidator validator, ValidatingTextOrComboWidget.IConsumer consumer, String value, int swtFlags) {
        this(parent, validator, consumer, value, true, false, swtFlags);
    }

    public ValidatingTextWidget(Composite parent, ITextValidator validator, ValidatingTextOrComboWidget.IConsumer consumer) {
        this(parent, validator, consumer, null, 0);
    }

    public ValidatingTextWidget(Composite parent, ITextValidator validator, ValidatingTextOrComboWidget.IConsumer consumer, String value, List<String> proposals, Set<WildcardContentProposalProvider.WildcardPosition> wildcardPositions) {
        this(parent, validator, consumer, proposals, wildcardPositions, value, true, false, 0);
    }

    @Override
    public String getText() {
        return this.m_textField.getText();
    }

    @Override
    public void setText(String text) {
        assert (text != null) : "Parameter 'text' of method 'setText' must not be null";
        this.m_textField.setText(text);
    }

    public void setEditable(boolean editable) {
        this.m_textField.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        if (super.getEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.m_textField.setEnabled(enabled);
        this.clearDecoration((Control)this.m_textField);
    }

    public void dispose() {
        this.m_textField.removeModifyListener((ModifyListener)this);
        super.dispose();
    }

    public Text getTextField() {
        return this.m_textField;
    }
}

