/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public final class LinkWithImage
extends Composite
implements Listener {
    private final CLabel m_linkWithImage;
    private final Color m_enabledColor;
    private final Color m_disabledColor;

    public LinkWithImage(Composite parent, String text, String image, Color enabledColor) {
        super(parent, 0);
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'LinkWithImage' must not be empty";
        assert (image != null && image.length() > 0) : "Parameter 'image' of method 'LinkWithImage' must not be empty";
        assert (enabledColor != null) : "Parameter 'enabledColor' of method 'LinkWithImage' must not be null";
        this.setLayout((Layout)new FillLayout());
        this.m_linkWithImage = new CLabel((Composite)this, 0);
        this.m_linkWithImage.setText(text);
        this.m_linkWithImage.setImage(UiResourceManager.getInstance().getImage(image));
        this.m_enabledColor = enabledColor;
        this.m_disabledColor = this.m_linkWithImage.getForeground();
        this.m_linkWithImage.setForeground(enabledColor);
        this.m_linkWithImage.addListener(6, (Listener)this);
        this.m_linkWithImage.addListener(7, (Listener)this);
    }

    public LinkWithImage(Composite parent, String text, String image) {
        this(parent, text, image, UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE));
    }

    public void setText(String text) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'setText' must not be empty";
        this.m_linkWithImage.setText(text);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.m_linkWithImage.setForeground(this.m_enabledColor);
        } else {
            this.m_linkWithImage.setForeground(this.m_disabledColor);
        }
        this.m_linkWithImage.setEnabled(enabled);
    }

    public void handleEvent(Event event) {
        assert (event != null) : "Parameter 'event' of method 'handleEvent' must not be null";
        switch (event.type) {
            case 6: {
                this.m_linkWithImage.setCursor(UiResourceManager.getInstance().getCursor(21));
                break;
            }
            case 7: {
                this.m_linkWithImage.setCursor(null);
                break;
            }
            default: {
                assert (false) : "Unhandled event type: " + event.type;
                break;
            }
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.m_linkWithImage.addListener(eventType, listener);
    }

    public void setToolTipText(String text) {
        this.m_linkWithImage.setToolTipText(text);
    }
}

