/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class CompositeContributionButton
extends Canvas {
    private static final int IMAGE_OFFSET = 2;
    private final List<SelectionListener> m_selectionListeners = new ArrayList<SelectionListener>(2);
    private final Image m_image;
    private final Image m_disabledImage;
    private final Point m_size;
    private Rectangle m_bounds;

    public static Point computeSize(Image image) {
        assert (image != null) : "Parameter 'image' of method 'computeSize' must not be null";
        Rectangle bounds = image.getBounds();
        return new Point(bounds.width + 4, bounds.height + 4);
    }

    public CompositeContributionButton(Composite parent, Image image) {
        super(parent, 0);
        assert (image != null) : "Parameter 'image' of method 'CompositeContributionButton' must not be null";
        this.m_image = image;
        this.m_disabledImage = new Image(this.m_image.getDevice(), this.m_image, 1);
        this.m_size = CompositeContributionButton.computeSize(image);
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (CompositeContributionButton.this.processEvent(event) != null) {
                    SelectionEvent selectionEvent = new SelectionEvent(event);
                    for (SelectionListener next : CompositeContributionButton.this.m_selectionListeners) {
                        next.widgetSelected(selectionEvent);
                    }
                }
            }
        });
        if (!Platform.isMac()) {
            this.addListener(6, new Listener(){

                public void handleEvent(Event event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                    }
                    CompositeContributionButton.this.m_bounds = CompositeContributionButton.this.processEvent(event);
                    CompositeContributionButton.this.redraw();
                }
            });
            this.addListener(7, new Listener(){

                public void handleEvent(Event event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                    }
                    CompositeContributionButton.this.m_bounds = null;
                    CompositeContributionButton.this.redraw();
                }
            });
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                CompositeContributionButton.this.paint(event);
            }
        });
        this.addDisposeListener(event -> {
            if (this.m_disabledImage != null) {
                this.m_disabledImage.dispose();
            }
        });
    }

    private Rectangle processEvent(Event event) {
        assert (event != null) : "Parameter 'event' of method 'onButton' must not be null";
        if (this.isEnabled()) {
            Rectangle bounds = this.getBounds();
            if (event.x >= 0 && event.x <= bounds.width && event.y >= 0 && event.y <= bounds.height) {
                return new Rectangle(0, 0, bounds.width - 1, bounds.height - 1);
            }
        }
        return null;
    }

    private void paint(PaintEvent event) {
        assert (event != null) : "Parameter 'event' of method 'paint' must not be null";
        if (this.isEnabled()) {
            event.gc.drawImage(this.m_image, 2, 2);
        } else {
            event.gc.drawImage(this.m_disabledImage, 2, 2);
        }
        if (this.m_bounds != null) {
            event.gc.setForeground(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY));
            event.gc.drawRectangle(this.m_bounds);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.m_size;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        assert (selectionListener != null) : "Parameter 'selectionListener' of method 'addSelectionListener' must not be null";
        if (!this.m_selectionListeners.contains(selectionListener)) {
            this.m_selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        assert (selectionListener != null) : "Parameter 'selectionListener' of method 'addSelectionListener' must not be null";
        this.m_selectionListeners.remove(selectionListener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }
}

