/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorTable.class);
    private static final float BRIGHTNESS = 1.0f;
    private static final float SATURATION_MIN = 0.08f;
    private static final float SATURATION_MAX = 0.92f;
    private static final int SATURATION_STEPS = 4;
    private static final float SATURATION_INCREMENT = 0.28f;
    private static final float HUE_START = 210.0f;
    private final Display m_display;
    private ArrayList<Color> m_colors;

    ColorTable(Display display) {
        assert (display != null) : "Parameter 'display' of method 'ColorTable' must not be null";
        this.m_display = display;
    }

    public void clear() {
        if (this.m_colors != null) {
            this.m_colors.forEach(c -> c.dispose());
            this.m_colors.clear();
            this.m_colors = null;
        }
    }

    public List<Color> generate(int size) {
        assert (size > 0) : "'size' must be greater than 0";
        this.clear();
        this.m_colors = new ArrayList(size);
        int numberOfColors = size / 4 + 1;
        float[] hues = new float[numberOfColors];
        float hueIncrement = 360 / numberOfColors;
        float currentHue = 210.0f;
        int i = 0;
        while (i < numberOfColors) {
            hues[i] = currentHue;
            if ((currentHue += hueIncrement) > 360.0f) {
                currentHue -= 360.0f;
            }
            ++i;
        }
        int currentColorIndex = 0;
        float currentSaturation = 0.08f;
        int i2 = 0;
        while (i2 < size) {
            float nextHue = hues[currentColorIndex];
            LOGGER.debug("HUE/SAT: " + nextHue + "/" + currentSaturation);
            RGB nextRGB = new RGB(nextHue, currentSaturation, 1.0f);
            Color nextColor = new Color((Device)this.m_display, nextRGB);
            this.m_colors.add(nextColor);
            currentSaturation += 0.28f;
            if (currentSaturation > 0.92f) {
                currentSaturation = 0.08f;
                ++currentColorIndex;
            }
            ++i2;
        }
        return this.m_colors;
    }
}

