/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractBorder;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Insets;
import org.eclipse.swt.graphics.Color;

public class LineBorder
extends AbstractBorder {
    private int width = 1;
    private Color color;
    private int style = 1;

    public LineBorder(Color color, int width, int style) {
        this.setColor(color);
        this.setWidth(width);
        this.setStyle(style);
    }

    public LineBorder(Color color, int width) {
        this(color, width, 1);
    }

    public LineBorder(Color color) {
        this(color, 1);
    }

    public LineBorder(int width) {
        this(null, width);
    }

    public LineBorder() {
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth());
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(LineBorder.getPaintRectangle(figure, insets));
        if (this.getWidth() % 2 == 1) {
            --LineBorder.tempRect.width;
            --LineBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRectangle(tempRect);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setWidth(int width) {
        if (width > 0) {
            this.width = width;
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

