/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.systemdiff;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class OpenBaselineReportDialog
extends StandardDialog {
    private final List<BaselineInfo> m_recentlyUsedList;
    private TFile m_baselineReport;
    private TableViewer m_tableViewer;
    private ValidatingPathWidget m_pathWidget;
    private StyledText m_descriptionText;

    public OpenBaselineReportDialog(Shell shell, List<BaselineInfo> recentlyUsedList) {
        super(shell, "Select Baseline Report");
        assert (recentlyUsedList != null) : "Parameter 'recentlyUsedList' of method 'OpenBaselineReportDialog' must not be null";
        this.m_recentlyUsedList = recentlyUsedList;
        this.m_baselineReport = this.m_recentlyUsedList.isEmpty() ? null : this.m_recentlyUsedList.get(0).getFile();
    }

    @Override
    protected IDialogId getDialogId() {
        return UiSwtDialogId.OPEN_BASELINE_DIALOG;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_pathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            @Override
            public void setPath(TFile input, boolean inputModified) {
                if (inputModified) {
                    OperationResultWithOutcome baselineInfoResult;
                    OpenBaselineReportDialog.this.m_tableViewer.setSelection(null);
                    OpenBaselineReportDialog.this.m_baselineReport = input;
                    OpenBaselineReportDialog.this.inputModified();
                    String contextInfo = input != null ? ((baselineInfoResult = ((ISystemDiffProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(ISystemDiffProvider.class)).getBaselineInfo(OpenBaselineReportDialog.this.m_baselineReport)).isSuccess() ? ((BaselineInfo)baselineInfoResult.getOutcome()).getDescription() : "") : "";
                    OpenBaselineReportDialog.this.m_descriptionText.setText(contextInfo);
                }
            }
        }, (IPathValidator)new StandardFilePathValidator((IFileType)CoreFileType.REPORT_XML), 1, this.m_baselineReport, false);
        this.m_pathWidget.setLayoutData(new GridData(4, 4, true, false));
        this.m_pathWidget.setFilterExtensions(new String[]{"*" + CoreFileType.REPORT_XML.getDefaultExtension()});
        SwtUtility.placeHorizontalSeparator(composite, 1);
        Group group = new Group(composite, 0);
        group.setText("Recently used Baseline Reports");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)group, 512);
        this.m_tableViewer = new TableViewer((Composite)sashForm, 68356);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, (int)2);
        TableViewerColumn fileColumn = new TableViewerColumn(this.m_tableViewer, 0);
        fileColumn.getColumn().setText("Path");
        fileColumn.getColumn().setWidth(350);
        fileColumn.getColumn().setResizable(true);
        fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof BaselineInfo)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(element)));
                }
                return ((BaselineInfo)element).getFile().getNormalizedAbsolutePath();
            }

            public Image getImage(Object element) {
                return UiResourceManager.getInstance().getImage("File");
            }
        });
        TableViewerColumn timestampColumn = new TableViewerColumn(this.m_tableViewer, 0);
        timestampColumn.getColumn().setText("Timestamp");
        timestampColumn.getColumn().setWidth(130);
        timestampColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof BaselineInfo)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(element)));
                }
                return Iso8601DateFormat.formatDateAndTime((Date)((BaselineInfo)element).getCreationTime());
            }
        });
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_descriptionText = new StyledText((Composite)sashForm, 2122);
        this.m_descriptionText.setEditable(false);
        this.m_descriptionText.setCaret(null);
        sashForm.setWeights(new int[]{80, 20});
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    OpenBaselineReportDialog.this.m_baselineReport = null;
                    OpenBaselineReportDialog.this.m_descriptionText.setText("");
                } else {
                    BaselineInfo baseline = (BaselineInfo)selection.getFirstElement();
                    OpenBaselineReportDialog.this.m_baselineReport = baseline.getFile();
                    OpenBaselineReportDialog.this.m_pathWidget.setPath(OpenBaselineReportDialog.this.m_baselineReport.getNormalizedAbsolutePath());
                    OpenBaselineReportDialog.this.m_descriptionText.setText(baseline.getDescription());
                }
                OpenBaselineReportDialog.this.inputModified();
            }
        });
    }

    @Override
    public boolean hasValidData() {
        return this.m_baselineReport != null;
    }

    private void inputModified() {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    @Override
    protected Point getMinimumSize() {
        return new Point(600, 450);
    }

    @Override
    protected Point getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    protected void applyData() {
        this.m_tableViewer.setInput(this.m_recentlyUsedList);
        this.inputModified();
    }

    public TFile getBaselineReport() {
        return this.m_baselineReport;
    }
}

