/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.propertiesview;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.IPropertiesProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.AbstractHorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.HorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class PropertiesView
extends WorkbenchView
implements AbstractHorizontalSeparator.ILayoutListener,
IContextWorkbenchView {
    private static final String NO_SYSTEM_OPENED = "No System Opened";
    private HorizontalSeparator m_elementSeparator;
    private StyledText m_propertiesViewer;
    private IContextWorkbenchView.ContextAndElement<Element> m_currentlyShown;

    @Override
    public IViewId getViewId() {
        return ViewId.PROPERTIES_VIEW;
    }

    @Override
    public List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_propertiesViewer);
    }

    @Override
    public IContext getContext() {
        if (this.m_currentlyShown != null) {
            return this.m_currentlyShown.getContext();
        }
        return super.getContext();
    }

    private List<Pair<String, String>> getCurrentProperties() {
        List data = (List)this.m_propertiesViewer.getData();
        if (data != null) {
            return Collections.unmodifiableList(data);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean supportsCopy() {
        if (!this.m_propertiesViewer.getSelectionText().isEmpty()) {
            return true;
        }
        return !this.getCurrentProperties().isEmpty();
    }

    @Override
    public String getCopyLabelAddition() {
        if (!this.m_propertiesViewer.getSelectionText().isEmpty()) {
            return "Selection";
        }
        return "All";
    }

    @Override
    public String copy() {
        if (!this.m_propertiesViewer.getSelectionText().isEmpty()) {
            return this.m_propertiesViewer.getSelectionText().replace('\u00a0', ' ');
        }
        StringBuilder builder = new StringBuilder();
        for (Pair<String, String> next : this.getCurrentProperties()) {
            String nextKey = (String)next.getFirst();
            if (nextKey.isEmpty()) {
                builder.append("    ");
            } else {
                builder.append(nextKey.replace('\u00a0', ' ')).append(": ");
            }
            builder.append((String)next.getSecond()).append("\n");
        }
        return builder.toString();
    }

    private void handleElementSelectionChanged(IWorkbenchView workbenchView, List<Element> elements) {
        Element element;
        assert (elements != null) : "Parameter 'elements' of method 'handleSelectionChanged' must not be null";
        Element element2 = element = !elements.isEmpty() ? elements.get(0) : null;
        if (element == null || !element.isValid()) {
            element = this.getSoftwareSystem();
        }
        if (element != null && element.isValid()) {
            this.show(new IContextWorkbenchView.ContextAndElement<Element>(workbenchView != null ? workbenchView.getContext() : super.getContext(), element));
        } else {
            this.reset();
        }
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        Composite composite = new Composite(viewContentArea, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.m_elementSeparator = new HorizontalSeparator(composite, NO_SYSTEM_OPENED);
        this.m_elementSeparator.setLayoutData(new GridData(4, 0, true, false));
        this.m_propertiesViewer = new StyledText(composite, 584);
        this.m_propertiesViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_propertiesViewer.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_propertiesViewer.setLineSpacing(3);
        this.m_elementSeparator.setLayoutListener(this);
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (PropertiesView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && PropertiesView.this.m_currentlyShown != null && event.getModifiableFiles().contains(PropertiesView.this.m_currentlyShown.getElement())) {
                    PropertiesView.this.update();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ContextsModifiedEvent>(ContextsModifiedEvent.class, (Object)this){

            public void handleEvent(ContextsModifiedEvent event) {
                if (PropertiesView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && PropertiesView.this.m_currentlyShown != null && !PropertiesView.this.m_currentlyShown.isValid()) {
                    PropertiesView.this.update();
                }
            }
        });
        this.m_propertiesViewer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'keyPressed' must not be null");
                }
                if (!((event.stateMask & SWT.MOD1) != SWT.MOD1 || event.keyCode != 65 && event.keyCode != 97 || PropertiesView.this.m_propertiesViewer == null || PropertiesView.this.m_propertiesViewer.isDisposed())) {
                    PropertiesView.this.m_propertiesViewer.selectAll();
                }
            }
        });
    }

    @Override
    protected void destroyViewContent() {
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ContextsModifiedEvent.class, (Object)this);
        this.m_elementSeparator.setLayoutListener(null);
        super.destroyViewContent();
    }

    private void show(IContextWorkbenchView.ContextAndElement<Element> show) {
        assert (show != null) : "Parameter 'show' of method 'show' must not be null";
        this.m_currentlyShown = show;
        Element element = this.m_currentlyShown.getElement();
        List propertiesList = ((IPropertiesProvider)this.getInstallation().getExtension(IPropertiesProvider.class)).getProperties(this.m_currentlyShown.getContext(), element);
        List<Pair<String, String>> currentExpandedPropertiesList = this.getCurrentProperties();
        ArrayList<Pair> expandedPropertiesList = new ArrayList<Pair>();
        for (Pair nextPair : propertiesList) {
            String nextValue = (String)nextPair.getSecond();
            List lines = StringUtility.multiLineStringToList((String)nextValue);
            if (lines.size() == 1) {
                expandedPropertiesList.add(nextPair);
                continue;
            }
            String nextKey = (String)nextPair.getFirst();
            String value = lines.stream().collect(Collectors.joining("\n\t"));
            expandedPropertiesList.add(new Pair((Object)nextKey, (Object)value));
        }
        this.m_elementSeparator.set(element.getPresentationName(false), UiResourceManager.getInstance().getImage(element));
        if (!expandedPropertiesList.equals(currentExpandedPropertiesList)) {
            this.m_propertiesViewer.setRedraw(false);
            this.m_propertiesViewer.setText("");
            int longestKeyLength = 0;
            String longestKey = null;
            StringBuilder builder = new StringBuilder();
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            int currentOffset = 0;
            for (Pair next : expandedPropertiesList) {
                String nextKey = ((String)next.getFirst()).replace(' ', '\u00a0');
                String nextValue = (String)next.getSecond();
                int nextKeyLength = nextKey.length();
                if (nextKeyLength > longestKeyLength) {
                    longestKeyLength = nextKeyLength;
                    longestKey = nextKey;
                }
                StyleRange nextStyleRange = new StyleRange();
                nextStyleRange.start = currentOffset;
                nextStyleRange.length = nextKeyLength;
                nextStyleRange.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE);
                styleRanges.add(nextStyleRange);
                builder.append(nextKey);
                currentOffset += nextKeyLength;
                builder.append("\t");
                ++currentOffset;
                builder.append(nextValue);
                currentOffset += nextValue.length();
                builder.append("\n");
                ++currentOffset;
            }
            this.m_propertiesViewer.setText(longestKey + " ");
            int width = this.m_propertiesViewer.computeSize((int)-1, (int)-1).x;
            this.m_propertiesViewer.setTabStops(new int[]{width});
            this.m_propertiesViewer.setText(builder.toString());
            this.m_propertiesViewer.setData(expandedPropertiesList);
            this.m_propertiesViewer.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            this.m_propertiesViewer.setLineWrapIndent(0, this.m_propertiesViewer.getLineCount(), width);
            this.m_propertiesViewer.setRedraw(true);
        }
    }

    private void reset() {
        assert (this.m_propertiesViewer != null) : "'m_propertiesViewer' of method 'reset' must not be null";
        if (this.m_currentlyShown != null) {
            this.getSelectionProviderAdapter().handleSelectionChanged();
        }
        this.m_currentlyShown = null;
        this.m_elementSeparator.reset();
        this.m_propertiesViewer.setText("");
        this.m_propertiesViewer.setData(null);
    }

    private void update() {
        IContextWorkbenchView.ContextAndElement<SoftwareSystem> element = this.m_currentlyShown;
        if (element == null || !element.isValid()) {
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            IContextWorkbenchView.ContextAndElement<SoftwareSystem> contextAndElement = element = softwareSystem != null ? new IContextWorkbenchView.ContextAndElement<SoftwareSystem>(super.getContext(), softwareSystem) : null;
        }
        if (element != null) {
            this.show((IContextWorkbenchView.ContextAndElement<Element>)element);
        } else {
            this.reset();
        }
    }

    @Override
    protected void installationModified() {
        this.update();
        super.installationModified();
    }

    @Override
    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        WorkbenchViewSelection selection = this.getSelectionProviderAdapter().getCurrentWorkbenchViewSelection();
        if (selection != null) {
            this.handleElementSelectionChanged(selection.getWorkbenchView(), selection.getElements());
        } else {
            this.handleElementSelectionChanged(null, Collections.emptyList());
        }
        super.softwareSystemShow(mode);
    }

    @Override
    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        this.update();
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    @Override
    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        this.update();
        super.analyzerModification(modification, analyzerId);
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.reset();
    }

    @Override
    protected void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        if (!this.isAsleep()) {
            this.handleElementSelectionChanged(view, elements);
        }
    }

    @Override
    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_currentlyShown != null;
    }

    @Override
    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getProperties(this.m_currentlyShown.getContext(), this.m_currentlyShown.getElement());
    }

    @Override
    public void layoutAdapted() {
        if (this.isActive()) {
            this.getContentArea().layout(true, true);
        }
    }

    @Override
    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }
}

