/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewRepresentation;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewState;
import com.hello2morrow.sonargraph.core.model.graphview.IGraphViewProvider;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvas;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ElementInteractor;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.dependenciesview.DeadStateInfoProvider;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewColorManager;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewLayout;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeAddedDecorator;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeConnectionFigureRouter;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeConnectionFigureWeightDecorator;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewSourceNodeConnectionFigureAnchor;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewTargetNodeConnectionFigureAnchor;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphViewNodeAndConnectionFigureProvider
implements DrawNodeFigure.INodeFigureProvider<GraphViewNode>,
DrawConnectionFigure.IConnectionFigureProvider<GraphViewNode.GraphViewDependency>,
DrawNodeAndConnectionFigureCanvas.IListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphViewNodeAndConnectionFigureProvider.class);
    private final Set<GraphViewNodeFigure> m_selectedGraphViewNodeFigures = new LinkedHashSet<GraphViewNodeFigure>();
    private final Map<GraphViewNodeConnectionFigure, GraphViewNodeConnectionFigureWeightDecorator> m_selectedNodeConnectionFigureToDecorator = new LinkedHashMap<GraphViewNodeConnectionFigure, GraphViewNodeConnectionFigureWeightDecorator>();
    private final Map<GraphViewNodeFigure, GraphViewNodeAddedDecorator> m_nodeToAddedDecorator = new LinkedHashMap<GraphViewNodeFigure, GraphViewNodeAddedDecorator>();
    private final GraphViewNodeConnectionFigureRouter m_router = new GraphViewNodeConnectionFigureRouter();
    private final IViewId m_viewId;
    private final String m_secondaryId;
    private final DrawNodeAndConnectionFigureCanvas<GraphViewNode, GraphViewNode.GraphViewDependency, GraphViewLayout> m_canvas;
    private final IGraphViewProvider m_provider;
    private final GraphViewColorManager m_colorManager;
    private final SelectionProviderAdapter m_selectionProviderAdapter;
    private final ElementInteractor m_elementInteractor;
    private final GraphViewColorManager.IListener m_listener;
    private List<GraphViewNodeFigure> m_graphViewNodeFigures;

    public GraphViewNodeAndConnectionFigureProvider(IViewId viewId, String secondaryId, DrawNodeAndConnectionFigureCanvas<GraphViewNode, GraphViewNode.GraphViewDependency, GraphViewLayout> canvas, IGraphViewProvider provider, GraphViewColorManager colorManager, SelectionProviderAdapter selectionProviderAdapter, ElementInteractor elementInteractor, GraphViewColorManager.IListener listener) {
        assert (viewId != null) : "Parameter 'viewId' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        assert (secondaryId != null) : "Parameter 'secondaryId' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        assert (canvas != null) : "Parameter 'canvas' of method 'CycleViewNodeAndConnectionFigureProvider' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        assert (colorManager != null) : "Parameter 'colorManager' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        assert (selectionProviderAdapter != null) : "Parameter 'selectionProviderAdapter' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        assert (elementInteractor != null) : "Parameter 'elementInteractor' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'GraphViewNodeAndConnectionFigureProvider' must not be null";
        this.m_viewId = viewId;
        this.m_secondaryId = secondaryId;
        this.m_canvas = canvas;
        this.m_canvas.setListener(this);
        this.m_provider = provider;
        this.m_colorManager = colorManager;
        this.m_selectionProviderAdapter = selectionProviderAdapter;
        this.m_elementInteractor = elementInteractor;
        this.m_listener = listener;
    }

    List<GraphViewNodeFigure> getNodeFigures() {
        if (this.m_graphViewNodeFigures == null) {
            List<DrawNodeFigure<GraphViewNode>> nodeFigures = this.m_canvas.getNodeFigures();
            this.m_graphViewNodeFigures = new ArrayList<GraphViewNodeFigure>(nodeFigures.size());
            for (DrawNodeFigure<GraphViewNode> nextNodeFigure : nodeFigures) {
                assert (nextNodeFigure != null && nextNodeFigure instanceof GraphViewNodeFigure) : "Unexpected class in method 'getNodeFigures': " + String.valueOf(nextNodeFigure);
                this.m_graphViewNodeFigures.add((GraphViewNodeFigure)nextNodeFigure);
            }
            Collections.sort(this.m_graphViewNodeFigures, new Comparator<GraphViewNodeFigure>(){

                @Override
                public int compare(GraphViewNodeFigure f1, GraphViewNodeFigure f2) {
                    if (!$assertionsDisabled && f1 == null) {
                        throw new AssertionError((Object)"Parameter 'f1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && f2 == null) {
                        throw new AssertionError((Object)"Parameter 'f2' of method 'compare' must not be null");
                    }
                    Rectangle b1 = f1.getBounds();
                    Rectangle b2 = f2.getBounds();
                    int compared = b1.y - b2.y;
                    if (compared == 0 && (compared = b1.x - b2.x) == 0) {
                        compared = ((GraphViewNode)f1.getNode()).getFullyQualifiedName().compareTo(((GraphViewNode)f2.getNode()).getFullyQualifiedName());
                    }
                    return compared;
                }
            });
        }
        return this.m_graphViewNodeFigures;
    }

    private void addOutgoingDependency(Map<GraphViewNode, DrawNodeFigure<GraphViewNode>> graphViewNodeToNodeFigure, DrawNodeFigure<GraphViewNode> fromNodeFigure, GraphViewNode.GraphViewDependency outgoingDependency) {
        assert (graphViewNodeToNodeFigure != null) : "Parameter 'graphViewNodeToNodeFigure' of method 'addOutgoingDependency' must not be null";
        assert (fromNodeFigure != null) : "Parameter 'fromNodeFigure' of method 'addOutgoingDependency' must not be null";
        assert (outgoingDependency != null) : "Parameter 'outgoingDependency' of method 'addOutgoingDependency' must not be null";
        DrawNodeFigure<GraphViewNode> toNodeFigure = graphViewNodeToNodeFigure.get(outgoingDependency.getTo());
        assert (toNodeFigure != null) : "'toNodeFigure' of method 'addOutgoingDependency' must not be null: " + outgoingDependency.getTo().fullyQualifiedName();
        GraphViewNodeConnectionFigure nextConnectionFigure = new GraphViewNodeConnectionFigure(outgoingDependency, this, new GraphViewSourceNodeConnectionFigureAnchor((GraphViewNodeFigure)fromNodeFigure, (GraphViewNodeFigure)toNodeFigure), new GraphViewTargetNodeConnectionFigureAnchor((GraphViewNodeFigure)toNodeFigure, (GraphViewNodeFigure)fromNodeFigure), this.m_router);
        this.m_canvas.addConnectionFigure(nextConnectionFigure);
        this.finishNodeConnectionFigureCreation(nextConnectionFigure);
    }

    public void clear() {
        this.m_graphViewNodeFigures = null;
        this.m_nodeToAddedDecorator.clear();
        this.m_selectedNodeConnectionFigureToDecorator.clear();
        this.m_selectedGraphViewNodeFigures.clear();
    }

    private void finishNodeFigureCreation(GraphViewNodeFigure nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'finishNodeFigureCreation' must not be null";
        if (((GraphViewNode)nodeFigure.getNode()).isSelected()) {
            this.m_selectedGraphViewNodeFigures.add(nodeFigure);
        }
        if (((GraphViewNode)nodeFigure.getNode()).isAdded()) {
            GraphViewNodeAddedDecorator decorator = new GraphViewNodeAddedDecorator(nodeFigure);
            this.m_nodeToAddedDecorator.put(nodeFigure, decorator);
            this.m_canvas.addToAtticLayer(decorator);
        }
    }

    private void finishNodeConnectionFigureCreation(GraphViewNodeConnectionFigure connectionFigure) {
        assert (connectionFigure != null) : "Parameter 'connectionFigure' of method 'finishNodeConnectionFigureCreation' must not be null";
        if (((GraphViewNode.GraphViewDependency)connectionFigure.getConnection()).isSelected()) {
            GraphViewNodeConnectionFigureWeightDecorator decorator = new GraphViewNodeConnectionFigureWeightDecorator(connectionFigure);
            this.m_selectedNodeConnectionFigureToDecorator.put(connectionFigure, decorator);
            this.m_canvas.addToAtticLayer(decorator);
        }
    }

    public void createGraphView(GraphViewNode reveal, GraphViewRepresentation representation) {
        DrawNodeFigure figure;
        assert (representation != null) : "Parameter 'representation' of method 'createGraphView' must not be null";
        this.m_canvas.setRedraw(false);
        this.clear();
        this.m_canvas.clear();
        Map<NamedElement, Color> namedElementToColor = this.m_colorManager.getElementColoring(this.m_listener, this.m_provider.getNamedElements(representation));
        THashMap graphViewNodeToNodeFigure = new THashMap();
        List nodes = representation.getChildren(GraphViewNode.class);
        for (GraphViewNode next : nodes) {
            if (!next.isVisible()) continue;
            GraphViewNodeFigure nextNodeFigure = new GraphViewNodeFigure(next, this);
            nextNodeFigure.setBackgroundColor(namedElementToColor.get(next.getUnderlyingObject()));
            graphViewNodeToNodeFigure.put(next, nextNodeFigure);
            this.m_canvas.addNodeFigure(nextNodeFigure);
            this.finishNodeFigureCreation(nextNodeFigure);
            if (!next.isExpanded()) continue;
            for (GraphViewNode nextChild : next.getChildren(GraphViewNode.class)) {
                if (!nextChild.isVisible()) continue;
                GraphViewNodeFigure nextChildNodeFigure = new GraphViewNodeFigure(nextChild, this);
                nextChildNodeFigure.setBackgroundColor(namedElementToColor.get(nextChild.getUnderlyingObject()));
                graphViewNodeToNodeFigure.put(nextChild, nextChildNodeFigure);
                nextNodeFigure.addChildNodeFigure(nextChildNodeFigure);
                this.m_canvas.addNodeFigure(nextChildNodeFigure);
                this.finishNodeFigureCreation(nextChildNodeFigure);
            }
        }
        for (GraphViewNode nextNode : nodes) {
            if (!nextNode.isVisible()) continue;
            DrawNodeFigure nextFromNodeFigure = (DrawNodeFigure)graphViewNodeToNodeFigure.get(nextNode);
            assert (nextFromNodeFigure != null) : "'nextFromNodeFigure' of method 'createRepresentation' must not be null";
            for (GraphViewNode.GraphViewDependency nextOut : nextNode.getOutgoingDependencies()) {
                if (!nextOut.isVisible()) continue;
                this.addOutgoingDependency((Map<GraphViewNode, DrawNodeFigure<GraphViewNode>>)graphViewNodeToNodeFigure, nextFromNodeFigure, nextOut);
            }
            if (!nextNode.isExpanded()) continue;
            for (GraphViewNode nextChildNode : nextNode.getChildren(GraphViewNode.class)) {
                if (!nextChildNode.isVisible()) continue;
                DrawNodeFigure nextFromChildNodeFigure = (DrawNodeFigure)graphViewNodeToNodeFigure.get(nextChildNode);
                assert (nextFromChildNodeFigure != null) : "'nextFromChildNodeFigure' of method 'createRepresentation' must not be null";
                for (GraphViewNode.GraphViewDependency nextOut : nextChildNode.getOutgoingDependencies()) {
                    if (!nextOut.isVisible()) continue;
                    this.addOutgoingDependency((Map<GraphViewNode, DrawNodeFigure<GraphViewNode>>)graphViewNodeToNodeFigure, nextFromChildNodeFigure, nextOut);
                }
            }
        }
        this.m_canvas.forceUpdate();
        if (reveal != null && (figure = (DrawNodeFigure)graphViewNodeToNodeFigure.get(reveal)) != null) {
            this.m_canvas.revealNode(figure);
        }
        this.m_canvas.setRedraw(true);
    }

    private void createAndAddNavigationState(NavigationState.Type type, GraphViewNodeFigure topMostNodeFigure, GraphViewRepresentation representation) {
        assert (type != null) : "Parameter 'type' of method 'createAndAddNavigationState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createAndAddNavigationState' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.m_viewId, this.m_secondaryId, type);
        state.addViewData(GraphViewNavigationStateData.STATE, this.m_provider.createState(representation));
        if (topMostNodeFigure != null) {
            state.addString(GraphViewNavigationStateData.TOP_MOST_NODE, ((GraphViewNode)topMostNodeFigure.getNode()).getRelativePath());
        }
        state.setDeadStateInfoProvider(DeadStateInfoProvider.INSTANCE);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    @Override
    public void handleNoNodeOrConnectionClicked(DrawModifier modifier, Point location) {
        boolean modifiedSelection;
        assert (modifier != null) : "Parameter 'modifier' of method 'handleNoNodeOrConnectionClicked' must not be null";
        assert (location != null) : "Parameter 'location' of method 'handleNoNodeOrConnectionClicked' must not be null";
        LOGGER.debug("No node/connection clicked: " + String.valueOf(location));
        this.m_canvas.setRedraw(false);
        GraphViewNodeFigure clicked = null;
        for (GraphViewNodeFigure nextNodeFigure : this.getNodeFigures()) {
            GraphViewNode nextNode = (GraphViewNode)nextNodeFigure.getNode();
            if (!(nextNode instanceof GraphViewCycleGroupNode) || !((GraphViewCycleGroupNode)nextNode).isExpanded()) continue;
            Rectangle nextNodeFigureBounds = nextNodeFigure.getBounds();
            LOGGER.debug("Expanded cycle group '" + nextNode.getName() + ": " + String.valueOf(nextNodeFigureBounds));
            if (!nextNodeFigureBounds.contains(location)) continue;
            LOGGER.debug("Clicked");
            clicked = nextNodeFigure;
            break;
        }
        if (clicked != null) {
            this.clicked(clicked, modifier);
            modifiedSelection = true;
        } else {
            modifiedSelection = this.clearSelection(true);
        }
        this.m_canvas.setRedraw(true);
        if (modifiedSelection) {
            this.m_selectionProviderAdapter.handleSelectionChanged(this.getSelectedElements());
        }
    }

    boolean clearSelection(boolean updateModel) {
        boolean cleared = false;
        if (updateModel) {
            for (GraphViewNodeFigure graphViewNodeFigure : this.m_selectedGraphViewNodeFigures) {
                ((GraphViewNode)graphViewNodeFigure.getNode()).setSelected(false);
                graphViewNodeFigure.invalidate();
                cleared = true;
            }
        } else if (!this.m_selectedGraphViewNodeFigures.isEmpty()) {
            cleared = true;
        }
        this.m_selectedGraphViewNodeFigures.clear();
        if (!this.m_selectedNodeConnectionFigureToDecorator.isEmpty()) {
            for (Map.Entry entry : this.m_selectedNodeConnectionFigureToDecorator.entrySet()) {
                GraphViewNodeConnectionFigure nextNodeConnectionFigure = (GraphViewNodeConnectionFigure)entry.getKey();
                if (updateModel) {
                    nextNodeConnectionFigure.invalidate();
                    ((GraphViewNode.GraphViewDependency)nextNodeConnectionFigure.getConnection()).setSelected(false);
                }
                this.m_canvas.removeFromAtticLayer((IFigure)entry.getValue());
            }
            this.m_selectedNodeConnectionFigureToDecorator.clear();
            cleared = true;
        }
        return cleared;
    }

    private void clicked(GraphViewNodeFigure nodeFigure, DrawModifier modifier) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'clicked' must not be null";
        assert (modifier != null) : "Parameter 'modifier' of method 'clicked' must not be null";
        switch (modifier) {
            case NONE: {
                if (((GraphViewNode)nodeFigure.getNode()).isSelected()) {
                    return;
                }
                this.clearSelection(true);
                ((GraphViewNode)nodeFigure.getNode()).setSelected(!((GraphViewNode)nodeFigure.getNode()).isSelected());
                break;
            }
            case SHIFT: {
                this.clearSelection(true);
                ((GraphViewNode)nodeFigure.getNode()).setSelected(!((GraphViewNode)nodeFigure.getNode()).isSelected());
                break;
            }
            case PRIMARY: {
                if (((GraphViewNode)nodeFigure.getNode()).isSelected()) {
                    this.m_selectedGraphViewNodeFigures.remove(nodeFigure);
                }
                ((GraphViewNode)nodeFigure.getNode()).setSelected(!((GraphViewNode)nodeFigure.getNode()).isSelected());
                nodeFigure.invalidate();
                break;
            }
            default: {
                assert (false) : "Unhandled modifier: " + String.valueOf((Object)modifier);
                break;
            }
        }
        if (((GraphViewNode)nodeFigure.getNode()).isSelected()) {
            this.m_selectedGraphViewNodeFigures.add(nodeFigure);
        }
        this.createAndAddNavigationState(NavigationState.Type.CONTENT_SELECTED, (GraphViewNodeFigure)this.m_canvas.getTopMostVisibleNode(), (GraphViewRepresentation)((GraphViewNode)nodeFigure.getNode()).getParent(GraphViewRepresentation.class, ParentMode.FIRST_PARENT));
    }

    @Override
    public void clicked(DrawNodeFigure<GraphViewNode> nodeFigure, DrawModifier modifier, IFigure source) {
        assert (nodeFigure != null && nodeFigure instanceof GraphViewNodeFigure) : "Unexpected class in method 'clicked': " + String.valueOf(nodeFigure);
        this.m_canvas.setRedraw(false);
        GraphViewNodeFigure graphViewNodeFigure = (GraphViewNodeFigure)nodeFigure;
        LOGGER.debug("Clicked: " + ((GraphViewNode)graphViewNodeFigure.getNode()).getName());
        this.clicked(graphViewNodeFigure, modifier);
        this.m_canvas.setRedraw(true);
        this.m_selectionProviderAdapter.handleSelectionChanged(this.getSelectedElements());
    }

    @Override
    public void clicked(DrawConnectionFigure<GraphViewNode.GraphViewDependency> connectionFigure, DrawModifier modifier) {
        GraphViewNodeConnectionFigureWeightDecorator decorator;
        assert (connectionFigure != null && connectionFigure instanceof GraphViewNodeConnectionFigure) : "Unexpected class in method 'clicked': " + String.valueOf(connectionFigure);
        this.m_canvas.setRedraw(false);
        GraphViewNodeConnectionFigure graphViewNodeConnectionFigure = (GraphViewNodeConnectionFigure)connectionFigure;
        LOGGER.debug("Clicked: " + ((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).getName());
        switch (modifier) {
            case NONE: {
                if (((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).isSelected()) {
                    this.m_canvas.setRedraw(true);
                    return;
                }
                this.clearSelection(true);
                ((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).setSelected(!((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).isSelected());
                break;
            }
            case SHIFT: {
                this.clearSelection(true);
                ((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).setSelected(!((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).isSelected());
                break;
            }
            case PRIMARY: {
                if (((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).isSelected() && (decorator = this.m_selectedNodeConnectionFigureToDecorator.remove(graphViewNodeConnectionFigure)) != null) {
                    this.m_canvas.removeFromAtticLayer(decorator);
                }
                ((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).setSelected(!((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).isSelected());
                graphViewNodeConnectionFigure.invalidate();
                break;
            }
            default: {
                assert (false) : "Unhandled modifier: " + String.valueOf((Object)modifier);
                break;
            }
        }
        if (((GraphViewNode.GraphViewDependency)graphViewNodeConnectionFigure.getConnection()).isSelected()) {
            decorator = new GraphViewNodeConnectionFigureWeightDecorator(graphViewNodeConnectionFigure);
            this.m_selectedNodeConnectionFigureToDecorator.put(graphViewNodeConnectionFigure, decorator);
            this.m_canvas.addToAtticLayer(decorator);
        }
        this.m_canvas.setRedraw(true);
        this.m_selectionProviderAdapter.handleSelectionChanged(this.getSelectedElements());
    }

    @Override
    public void collapse(DrawNodeFigure<GraphViewNode> nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'collapse' must not be null";
        GraphViewRepresentation representation = (GraphViewRepresentation)nodeFigure.getNode().getParent(GraphViewRepresentation.class, ParentMode.FIRST_PARENT);
        assert (representation != null) : "Parameter 'representation' of method 'collapse' must not be null";
        this.m_elementInteractor.disable();
        this.m_provider.collapse(nodeFigure.getNode());
        this.createGraphView(null, representation);
        this.m_elementInteractor.enable();
        this.createAndAddNavigationState(NavigationState.Type.CONTENT_COLLAPSED, (GraphViewNodeFigure)this.m_canvas.getTopMostVisibleNode(), representation);
    }

    @Override
    public void expand(DrawNodeFigure<GraphViewNode> nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'expand' must not be null";
        GraphViewRepresentation representation = (GraphViewRepresentation)nodeFigure.getNode().getParent(GraphViewRepresentation.class, ParentMode.FIRST_PARENT);
        assert (representation != null) : "Parameter 'representation' of method 'expand' must not be null";
        this.m_elementInteractor.disable();
        this.m_provider.expand(nodeFigure.getNode());
        this.createGraphView(null, representation);
        this.m_elementInteractor.enable();
        this.createAndAddNavigationState(NavigationState.Type.CONTENT_EXPANDED, (GraphViewNodeFigure)this.m_canvas.getTopMostVisibleNode(), representation);
    }

    public void updated() {
        this.m_elementInteractor.disable();
        this.m_canvas.setRedraw(false);
        this.m_canvas.updateFromModel();
        this.m_canvas.setRedraw(true);
        this.m_elementInteractor.enable();
    }

    public void stateRestored(GraphViewNode reveal, GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'stateRestored' must not be null";
        this.m_elementInteractor.disable();
        this.m_canvas.setRedraw(false);
        this.createGraphView(reveal, representation);
        this.m_canvas.setRedraw(true);
        this.m_elementInteractor.enable();
    }

    public List<Element> getSelectedElements() {
        ArrayList<Element> elements = new ArrayList<Element>(this.m_selectedGraphViewNodeFigures.size() + this.m_selectedNodeConnectionFigureToDecorator.size());
        for (GraphViewNodeFigure graphViewNodeFigure : this.m_selectedGraphViewNodeFigures) {
            elements.add((Element)graphViewNodeFigure.getNode());
        }
        for (GraphViewNodeConnectionFigure graphViewNodeConnectionFigure : this.m_selectedNodeConnectionFigureToDecorator.keySet()) {
            elements.add((Element)graphViewNodeConnectionFigure.getConnection());
        }
        return elements;
    }

    @Override
    public void aboutToUpdate(DrawConnectionFigure<GraphViewNode.GraphViewDependency> connectionFigure) {
        assert (connectionFigure != null && connectionFigure instanceof GraphViewNodeConnectionFigure) : "Unexpected class in method 'aboutToUpdate': " + String.valueOf(connectionFigure);
        if (connectionFigure.getConnection().isSelected()) {
            GraphViewNodeConnectionFigureWeightDecorator decorator = new GraphViewNodeConnectionFigureWeightDecorator((GraphViewNodeConnectionFigure)connectionFigure);
            this.m_selectedNodeConnectionFigureToDecorator.put((GraphViewNodeConnectionFigure)connectionFigure, decorator);
            this.m_canvas.addToAtticLayer(decorator);
        }
    }

    @Override
    public void aboutToUpdate(DrawNodeFigure<GraphViewNode> nodeFigure) {
        assert (nodeFigure != null && nodeFigure instanceof GraphViewNodeFigure) : "Unexpected class in method 'aboutToUpdate': " + String.valueOf(nodeFigure);
        if (nodeFigure.getNode().isAdded()) {
            GraphViewNodeAddedDecorator decorator = new GraphViewNodeAddedDecorator((GraphViewNodeFigure)nodeFigure);
            this.m_nodeToAddedDecorator.put((GraphViewNodeFigure)nodeFigure, decorator);
            this.m_canvas.addToAtticLayer(decorator);
        } else {
            GraphViewNodeAddedDecorator removed = this.m_nodeToAddedDecorator.remove(nodeFigure);
            if (removed != null) {
                this.m_canvas.removeFromAtticLayer(removed);
            }
        }
    }

    public List<CycleGroup> getCycleGroups() {
        List<DrawNodeFigure<GraphViewNode>> nodeFigures = this.m_canvas.getNodeFigures();
        ArrayList<CycleGroup> cycleGroups = new ArrayList<CycleGroup>();
        for (DrawNodeFigure<GraphViewNode> next : nodeFigures) {
            if (!(next.getNode() instanceof GraphViewCycleGroupNode) || ((GraphViewCycleGroupNode)next.getNode()).getBasedOn() == null) continue;
            cycleGroups.add((CycleGroup)((GraphViewCycleGroupNode)next.getNode()).getBasedOn());
        }
        return cycleGroups;
    }

    public void select(Set<GraphViewNode.GraphViewDependency> dependencies) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'select' must not be null";
        LOGGER.debug("Select dependencies (" + dependencies.size() + ")");
        this.m_canvas.setRedraw(false);
        this.clearSelection(true);
        if (!dependencies.isEmpty()) {
            for (DrawConnectionFigure<GraphViewNode.GraphViewDependency> next : this.m_canvas.getConnectionFigures()) {
                if (!dependencies.contains(next.getConnection())) continue;
                next.getConnection().setSelected(true);
                next.update();
            }
        }
        this.m_canvas.setRedraw(true);
        LOGGER.debug("Select dependencies (" + dependencies.size() + ") - done");
    }

    public void updateColors(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateColors' must not be null";
        LOGGER.debug("Update colors");
        Map<NamedElement, Color> elementToColor = this.m_colorManager.getElementColoring(this.m_listener, this.m_provider.getNamedElements(representation));
        for (DrawNodeFigure<GraphViewNode> nextNodeFigure : this.m_canvas.getNodeFigures()) {
            assert (nextNodeFigure != null && nextNodeFigure instanceof GraphViewNodeFigure) : "Unexpected class in method 'updateColors': " + String.valueOf(nextNodeFigure);
            NamedElement nextUnderlyingObject = (NamedElement)nextNodeFigure.getNode().getUnderlyingObject();
            ((GraphViewNodeFigure)nextNodeFigure).setBackgroundColor(elementToColor.get(nextUnderlyingObject));
        }
        this.m_canvas.forceUpdate();
        LOGGER.debug("Update colors - done");
    }

    @Override
    public boolean hasSelection() {
        return !this.m_selectedGraphViewNodeFigures.isEmpty() || !this.m_selectedNodeConnectionFigureToDecorator.isEmpty();
    }

    int getFirstSelectedNodeFigureIndex() {
        int index = 0;
        if (!this.m_selectedGraphViewNodeFigures.isEmpty()) {
            index = this.getNodeFigures().indexOf(this.m_selectedGraphViewNodeFigures.iterator().next());
        }
        return index < 0 ? 0 : index;
    }

    void selectAndReveal(GraphViewNodeFigure graphViewNodeFigure) {
        assert (graphViewNodeFigure != null) : "Parameter 'graphViewNodeFigure' of method 'selectAndReveal' must not be null";
        this.m_canvas.setRedraw(false);
        this.clearSelection(true);
        ((GraphViewNode)graphViewNodeFigure.getNode()).setSelected(true);
        graphViewNodeFigure.invalidate();
        this.m_selectedGraphViewNodeFigures.add(graphViewNodeFigure);
        this.m_canvas.revealNode(graphViewNodeFigure);
        this.m_canvas.setRedraw(true);
    }

    public void completeState(NavigationState state, DrawNodeFigure<GraphViewNode> topMostNode, GraphViewRepresentation representation, boolean isInitialState) {
        assert (state != null) : "Parameter 'state' of method 'completeState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'completeState' must not be null";
        state.setMayBeReplacedByMoreDetailedState(!isInitialState);
        state.addViewData(GraphViewNavigationStateData.STATE, this.m_provider.createState(representation));
        if (topMostNode != null) {
            state.addString(GraphViewNavigationStateData.TOP_MOST_NODE, topMostNode.getNode().getRelativePath());
        }
    }

    public void restoreState(NavigationState state, GraphViewRepresentation representation) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'restoreState' must not be null";
        if (!state.isInvolvedInUndoRedoOperation()) {
            Object representationStateObject = state.getDataAsObject(GraphViewNavigationStateData.STATE);
            assert (representationStateObject != null && representationStateObject instanceof GraphViewState) : "Unexpected class in method 'restoreState': " + String.valueOf(representationStateObject);
            GraphViewState representationState = (GraphViewState)representationStateObject;
            String topmostNode = state.getString(GraphViewNavigationStateData.TOP_MOST_NODE);
            this.m_provider.restoreState(representationState, topmostNode, representation);
        } else {
            LOGGER.error("Ignore unexpected state 'isInvolvedInUndoRedoOperation': " + String.valueOf(state));
        }
    }

    public void home(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'home' must not be null";
        NavigationState initialNavigationState = ViewNavigationManager.getInstance().getInitialViewNavigationState(this.m_viewId, this.m_secondaryId);
        assert (initialNavigationState != null) : "'initialNavigationState' of method 'home' must not be null";
        if (ViewNavigationManager.getInstance().getCurrentNavigationState() != initialNavigationState) {
            ViewNavigationManager.getInstance().clear(this.m_viewId, this.m_secondaryId);
            ViewNavigationManager.getInstance().addNavigationState(initialNavigationState);
        }
        this.restoreState(initialNavigationState, representation);
    }

    private static enum GraphViewNavigationStateData implements IStateData
    {
        STATE,
        TOP_MOST_NODE;

    }
}

