/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawCache;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.IGraphViewCycleLayouter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraphViewCircularLayouter
implements IGraphViewCycleLayouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphViewCircularLayouter.class);
    private static final String KEY_CIRCLE_INFO = "CircleInfo";
    private static final String KEY_HEIGHT = "Height";
    private static final String KEY_MIN_WIDTH = "MinWidth";
    private static final String KEY_MAX_WIDTH = "MaxWidth";
    private static final int OFFSET_NODES = 15;

    GraphViewCircularLayouter() {
    }

    private CircleInfo calculateCircleInfo(List<GraphViewNodeFigure> nodes, int maxNodeWidth, int nodeHeight) {
        int diameter;
        int nodesDownwards;
        boolean isEven;
        assert (nodes != null && nodes.size() >= 2) : "Parameter 'nodes' of method 'calculateDiameterAndNodesVertically' must at least contain 2 nodes";
        int numberOfNodes = nodes.size();
        if (numberOfNodes % 2 == 0) {
            isEven = true;
            nodesDownwards = numberOfNodes / 2 + 1;
            diameter = (nodesDownwards - 1) * nodeHeight + (nodesDownwards - 1) * 15;
        } else {
            isEven = false;
            nodesDownwards = (numberOfNodes + 1) / 2;
            diameter = (nodesDownwards - 1) * nodeHeight + (nodesDownwards - 1) * 15 + 15;
        }
        int requiredWidth = diameter + 2 * maxNodeWidth + 30;
        int requiredHeight = diameter + nodeHeight + 30;
        return new CircleInfo(numberOfNodes, diameter, nodesDownwards, requiredWidth, requiredHeight, isEven);
    }

    @Override
    public Dimension getPreferredSize(List<GraphViewNodeFigure> nodes, DrawCache cache) {
        int requiredHeight;
        int requiredWidth;
        assert (nodes != null && nodes.size() >= 2) : "Parameter 'nodes' of method 'getPreferredSize' must at least contain 2 nodes";
        assert (cache != null) : "Parameter 'cache' of method 'getPreferedSize' must not be null";
        int minWidth = Integer.MAX_VALUE;
        int maxWidth = 0;
        for (GraphViewNodeFigure nextNode : nodes) {
            int nextWidth = nextNode.getPreferredSize().width;
            minWidth = Math.min(minWidth, nextWidth);
            maxWidth = Math.max(maxWidth, nextWidth);
        }
        minWidth = (int)((double)minWidth + (double)(maxWidth - minWidth) / 4.0);
        cache.put(KEY_MIN_WIDTH, minWidth);
        cache.put(KEY_MAX_WIDTH, maxWidth);
        int height = nodes.get((int)0).getPreferredSize().height;
        cache.put(KEY_HEIGHT, height);
        if (nodes.size() == 2) {
            requiredWidth = maxWidth + 30;
            requiredHeight = 2 * height + 60;
        } else {
            CircleInfo circleInfo = this.calculateCircleInfo(nodes, maxWidth, height);
            requiredWidth = circleInfo.getRequiredWidth();
            requiredHeight = circleInfo.getRequiredHeight();
            cache.put(KEY_CIRCLE_INFO, circleInfo);
        }
        return new Dimension(requiredWidth, requiredHeight);
    }

    private void setBoundingBox(GraphViewNodeFigure nodeFigure, int x, int y, int minWidth, int offsetX, int offsetY, Position position) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'setBoundingBox' must not be null";
        assert (position != null) : "Parameter 'position' of method 'setBoundingBox' must not be null";
        Dimension dimension = nodeFigure.getPreferredSize();
        int preferredWidth = dimension.width;
        int preferredHeight = dimension.height;
        int width = Math.max(minWidth, preferredWidth);
        Rectangle boundingBox = Rectangle.SINGLETON;
        switch (position) {
            case CENTER: {
                boundingBox.x = x - width / 2 + offsetX;
                break;
            }
            case RIGHT: {
                boundingBox.x = x + offsetX;
                break;
            }
            case LEFT: {
                boundingBox.x = x - width + offsetX;
                break;
            }
            default: {
                assert (false) : "Unhandled position: " + String.valueOf((Object)position);
                break;
            }
        }
        boundingBox.y = y - preferredHeight / 2 + offsetY;
        boundingBox.width = width;
        boundingBox.height = preferredHeight;
        nodeFigure.setBounds(boundingBox);
    }

    @Override
    public void layout(int offsetX, int offsetY, List<GraphViewNodeFigure> nodes, DrawCache cache) {
        assert (nodes != null && nodes.size() >= 2) : "Parameter 'nodes' of method 'layout' must at least contain 2 nodes";
        assert (cache != null) : "Parameter 'cache' of method 'layout' must not be null";
        LOGGER.debug("Layout");
        int minWidth = cache.get(KEY_MIN_WIDTH, Integer.class);
        int maxWidth = cache.get(KEY_MAX_WIDTH, Integer.class);
        int height = cache.get(KEY_HEIGHT, Integer.class);
        if (nodes.size() == 2) {
            int currentX = offsetX + 15;
            int currentY = offsetY + 15;
            for (GraphViewNodeFigure nextNode : nodes) {
                Dimension nodePreferredSize = nextNode.getPreferredSize();
                int deltaX = maxWidth - nodePreferredSize.width;
                Rectangle boundingBox = Rectangle.SINGLETON;
                boundingBox.x = currentX + (deltaX == 0 ? 0 : deltaX / 2);
                boundingBox.y = currentY;
                boundingBox.width = nodePreferredSize.width;
                boundingBox.height = nodePreferredSize.height;
                nextNode.setBounds(boundingBox);
                currentY += 30 + height;
            }
        } else {
            int referenceWidth;
            int x;
            int b;
            int c;
            GraphViewNodeFigure nextNode;
            CircleInfo circleInfo = cache.get(KEY_CIRCLE_INFO, CircleInfo.class);
            LOGGER.debug("Circle info: " + String.valueOf(circleInfo));
            int numberOfNodes = circleInfo.getNumberOfNodes();
            int numberOfNodesRight = circleInfo.getNumberOfNodesRight();
            int numberOfNodesLeft = circleInfo.getNumberOfNodesLeft();
            int radius = circleInfo.getRadius();
            int centerX = circleInfo.getCenterX();
            int centerY = circleInfo.getCenterY();
            int currentY = centerY - radius;
            GraphViewNodeFigure firstNode = nodes.get(0);
            this.setBoundingBox(firstNode, centerX, currentY, minWidth, offsetX, offsetY, Position.CENTER);
            if (circleInfo.isEven()) {
                indexNodeRight = 1;
                while (indexNodeRight < numberOfNodesRight - 1) {
                    nextNode = nodes.get(indexNodeRight);
                    c = radius;
                    b = centerY - (currentY += height + 15);
                    x = centerX + (int)Math.round(Math.sqrt(c * c - b * b));
                    this.setBoundingBox(nextNode, x, currentY, minWidth, offsetX, offsetY, Position.RIGHT);
                    ++indexNodeRight;
                }
                this.setBoundingBox(nodes.get(numberOfNodesRight - 1), centerX, currentY += height + 15, minWidth, offsetX, offsetY, Position.CENTER);
                currentY -= height + 15;
            } else {
                indexNodeRight = 1;
                while (indexNodeRight < numberOfNodesRight) {
                    nextNode = nodes.get(indexNodeRight);
                    c = radius;
                    b = centerY - (currentY += height + 15);
                    x = centerX + (int)Math.round(Math.sqrt(c * c - b * b));
                    this.setBoundingBox(nextNode, x, currentY, minWidth, offsetX, offsetY, Position.RIGHT);
                    ++indexNodeRight;
                }
            }
            int indexNodeLeft = numberOfNodes - 1;
            while (indexNodeLeft > numberOfNodesRight - 1) {
                nextNode = nodes.get(indexNodeLeft);
                c = radius;
                b = centerY - currentY;
                x = centerX - (int)Math.round(Math.sqrt(c * c - b * b));
                this.setBoundingBox(nextNode, x, currentY, minWidth, offsetX, offsetY, Position.LEFT);
                currentY -= height + 15;
                --indexNodeLeft;
            }
            int distanceTop = nodes.get((int)1).getBounds().getLeft().x - nodes.get((int)(numberOfNodes - 1)).getBounds().getRight().x;
            int distanceBottom = circleInfo.isEven() ? nodes.get((int)(numberOfNodesRight - 2)).getBounds().getLeft().x - nodes.get((int)(numberOfNodes - numberOfNodesLeft)).getBounds().getRight().x : nodes.get((int)(numberOfNodesRight - 1)).getBounds().getLeft().x - nodes.get((int)(numberOfNodes - numberOfNodesLeft)).getBounds().getRight().x;
            int distance = Math.min(distanceTop, distanceBottom);
            int diff = distance - (referenceWidth = circleInfo.isEven() ? Math.min(nodes.get((int)0).getBounds().width, nodes.get((int)(numberOfNodesRight - 1)).getBounds().width) : nodes.get((int)0).getBounds().width);
            if (diff > 0) {
                int startNodeLeft;
                int correctX = diff / 2;
                LOGGER.debug("Correction distance x: " + correctX);
                int nodesRight = circleInfo.isEven() ? numberOfNodesRight - 1 : numberOfNodesRight;
                int indexNodeRight = 1;
                while (indexNodeRight < nodesRight) {
                    GraphViewNodeFigure nextNode2 = nodes.get(indexNodeRight);
                    nextNode2.getBounds().x -= correctX;
                    ++indexNodeRight;
                }
                int indexNodeLeft2 = startNodeLeft = circleInfo.isEven() ? nodesRight + 1 : nodesRight;
                while (indexNodeLeft2 < numberOfNodes) {
                    GraphViewNodeFigure nextNode3 = nodes.get(indexNodeLeft2);
                    nextNode3.getBounds().x += correctX;
                    ++indexNodeLeft2;
                }
            }
        }
        LOGGER.debug("Layout - done");
    }

    static final class CircleInfo {
        private final int m_nodes;
        private final int m_diameter;
        private final int m_nodesRight;
        private final int m_requiredWidth;
        private final int m_requiredHeight;
        private final boolean m_isEven;

        CircleInfo(int nodes, int diameter, int nodesRight, int requiredWidth, int requiredHeight, boolean isEven) {
            this.m_nodes = nodes;
            this.m_diameter = diameter;
            this.m_nodesRight = nodesRight;
            this.m_requiredWidth = requiredWidth;
            this.m_requiredHeight = requiredHeight;
            this.m_isEven = isEven;
        }

        int getNumberOfNodes() {
            return this.m_nodes;
        }

        int getDiameter() {
            return this.m_diameter;
        }

        int getNumberOfNodesRight() {
            return this.m_nodesRight;
        }

        int getNumberOfNodesLeft() {
            return this.m_nodes - this.m_nodesRight;
        }

        int getRequiredWidth() {
            return this.m_requiredWidth;
        }

        int getRequiredHeight() {
            return this.m_requiredHeight;
        }

        int getRadius() {
            return this.m_diameter / 2;
        }

        int getCenterX() {
            return this.m_requiredWidth / 2;
        }

        int getCenterY() {
            return this.m_requiredHeight / 2;
        }

        boolean isEven() {
            return this.m_isEven;
        }

        public String toString() {
            return "Nodes=" + this.m_nodes + ", diameter=" + this.m_diameter + ", nodes left=" + this.getNumberOfNodesLeft() + ", nodes right=" + this.m_nodesRight + ", required width=" + this.m_requiredWidth + ", required height=" + this.m_requiredHeight + "]" + (this.m_isEven ? " <even>" : " <odd>");
        }
    }

    static enum Position {
        CENTER,
        RIGHT,
        LEFT;

    }
}

