/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog.feedback;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public abstract class FeedbackComposite
extends Composite {
    private static final String FEEDBACK_SALUTATION = "Feedback_Salutation";
    public static final String FEEDBACK_CONTACT_NAME = "Feedback_Contact_Name";
    public static final String FEEDBACK_EMAIL = "Feedback_Email";
    public static final String FEEDBACK_PHONE = "Feedback_Phone";
    public static final String DONT_ATTACH_LOGFILE = "Feedback_Dont_Attach_Logfile";
    public static final String DEFAULT_INTRO_TEXT = "Your feedback will be forwarded to support@hello2morrow.com. We will try to get back to you as quickly as possible.";
    private final ValidatingTextWidget m_contactNameText;
    private final ValidatingTextWidget m_emailText;
    private final Text m_phoneText;
    private final ValidatingTextWidget m_contextText;
    private final ValidatingTextWidget m_subjectText;
    private final ModifyListener m_phoneModifyListener;
    private final IListener m_listener;
    private final TFile m_logFile;
    private final Composite m_connectionConfigurationOrInfo;
    private ConnectionMode m_connectionMode;
    private Feedback.Salutation m_salutation;
    private String m_contactName = "";
    private String m_email = "";
    private String m_phone = "";
    private String m_subject = "";
    private String m_contextInfo = "";
    private String m_bundleId;

    public FeedbackComposite(Composite parent, IListener listener, final IProxySettingsProvider proxyProvider, int style, int columns, final String introText, TFile logFile, boolean showSubject, String bundleId) {
        super(parent, style);
        assert (listener != null) : "Parameter 'listener' of method 'FeedbackComposite' must not be null";
        assert (proxyProvider != null) : "Parameter 'proxyProvider' of method 'FeedbackComposite' must not be null";
        assert (introText != null && introText.length() > 0) : "Parameter 'introText' of method 'FeedbackComposite' must not be empty";
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'FeedbackComposite' must not be empty";
        this.m_listener = listener;
        this.m_connectionMode = ConnectionDialog.getConnectionMode(proxyProvider);
        this.m_bundleId = bundleId;
        this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin(columns));
        IEclipsePreferences settings = PreferencesUtility.getPreferences(bundleId, UiSwtDialogId.FEEDBACK_DIALOG);
        assert (settings != null) : "settings must not be null";
        this.m_contactName = settings.get(FEEDBACK_CONTACT_NAME, "");
        this.m_email = settings.get(FEEDBACK_EMAIL, "");
        this.m_phone = settings.get(FEEDBACK_PHONE, "");
        this.m_salutation = FeedbackComposite.initSalutationFromPreferences(settings);
        this.m_connectionConfigurationOrInfo = new Composite((Composite)this, 0);
        GridLayout connectionConfigurationLayout = new GridLayout(1, false);
        connectionConfigurationLayout.marginBottom = 0;
        connectionConfigurationLayout.marginLeft = 0;
        connectionConfigurationLayout.marginRight = 0;
        connectionConfigurationLayout.marginTop = 0;
        connectionConfigurationLayout.marginWidth = 0;
        this.m_connectionConfigurationOrInfo.setLayout((Layout)connectionConfigurationLayout);
        final Label note = new Label(this.m_connectionConfigurationOrInfo, 0);
        if (this.m_connectionMode == ConnectionMode.OFFLINE) {
            note.setFont(UiResourceManager.getInstance().getFont(1));
            note.setText("No internet connection detected!");
        } else {
            note.setFont(UiResourceManager.getInstance().getFont(0));
            note.setText(introText);
        }
        note.setLayoutData((Object)new GridData(0, 0x1000008, false, false));
        Link link = new Link(this.m_connectionConfigurationOrInfo, 16384);
        link.setText("<a>Configure Internet Connection</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedbackComposite.this.m_connectionMode = ConnectionDialog.getOrConfigureConnectionMode(FeedbackComposite.this.getShell(), false, true, proxyProvider);
                if (FeedbackComposite.this.m_connectionMode == ConnectionMode.ONLINE) {
                    Composite parent = FeedbackComposite.this.m_connectionConfigurationOrInfo.getParent();
                    if (FeedbackComposite.this.m_connectionMode == ConnectionMode.OFFLINE) {
                        note.setFont(UiResourceManager.getInstance().getFont(1));
                        note.setText("No internet connection detected: ");
                    } else {
                        note.setFont(UiResourceManager.getInstance().getFont(0));
                        note.setText(introText);
                    }
                    parent.layout(true, true);
                    FeedbackComposite.this.m_listener.modified();
                }
            }
        });
        link.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        this.m_connectionConfigurationOrInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns, 1));
        Label salutationLabel = new Label((Composite)this, 0);
        salutationLabel.setText("Salutation:");
        final Combo salutationCombo = new Combo((Composite)this, 0x800808);
        salutationCombo.setLayoutData((Object)new GridData(1, 128, false, false));
        salutationCombo.setItems(this.getSalutations());
        salutationCombo.select(this.m_salutation.ordinal());
        salutationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedbackComposite.this.m_salutation = Feedback.Salutation.fromPresentationName((String)salutationCombo.getText());
                if (!$assertionsDisabled && FeedbackComposite.this.m_salutation == null) {
                    throw new AssertionError((Object)("Unknown salutation '" + salutationCombo.getText() + "'"));
                }
            }
        });
        Label nameLabel = new Label((Composite)this, 0);
        nameLabel.setText("Contact name:");
        ITextValidator notEmptyValidator = new ITextValidator(){

            public ValidationResult isValid(String initialInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
                if (FeedbackComposite.this.validateInputFields() && (newInput == null || newInput.trim().length() == 0)) {
                    result.addError("Must not be empty");
                }
                return result;
            }
        };
        this.m_contactNameText = new ValidatingTextWidget(this, notEmptyValidator, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                FeedbackComposite.this.m_contactName = input;
                FeedbackComposite.this.m_listener.modified();
            }
        }, this.m_contactName, 2052);
        this.m_contactNameText.setLayoutData(new GridData(4, 128, true, false));
        Label emailLabel = new Label((Composite)this, 0);
        emailLabel.setText("Email: ");
        this.m_emailText = new ValidatingTextWidget(this, notEmptyValidator, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                FeedbackComposite.this.m_email = input;
            }
        }, this.m_email, 2052);
        this.m_emailText.setLayoutData(new GridData(4, 128, true, false));
        Label phoneLabel = new Label((Composite)this, 0);
        phoneLabel.setText("Phone: ");
        this.m_phoneText = new Text((Composite)this, 2052);
        this.m_phoneText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_phoneText.setText(this.m_phone);
        this.m_phoneModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() != FeedbackComposite.this.m_phoneText) {
                    return;
                }
                FeedbackComposite.this.m_phone = FeedbackComposite.this.m_phoneText.getText().trim();
                FeedbackComposite.this.m_listener.modified();
            }
        };
        this.m_phoneText.addModifyListener(this.m_phoneModifyListener);
        if (showSubject) {
            Label subjectLabel = new Label((Composite)this, 0);
            subjectLabel.setText("Subject: ");
            this.m_subjectText = new ValidatingTextWidget(this, notEmptyValidator, new ValidatingTextOrComboWidget.IConsumer(){

                @Override
                public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                    FeedbackComposite.this.m_subject = input;
                    FeedbackComposite.this.m_listener.modified();
                }
            }, "", 2052);
            this.m_subjectText.setLayoutData(new GridData(4, 128, true, false));
        } else {
            this.m_subjectText = null;
        }
        Label contextLabel = new Label((Composite)this, 0);
        contextLabel.setText(this.getContextInfoLabel());
        contextLabel.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_contextText = new ValidatingTextWidget(this, notEmptyValidator, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                FeedbackComposite.this.m_contextInfo = input;
                FeedbackComposite.this.m_listener.modified();
            }
        }, "", true, true, 2818);
        GridData layoutDataContext = new GridData(4, 4, true, true);
        layoutDataContext.heightHint = 80;
        layoutDataContext.widthHint = 500;
        layoutDataContext.minimumWidth = 500;
        this.m_contextText.setLayoutData(layoutDataContext);
        this.m_logFile = logFile;
        this.addAdditionalWidgets();
    }

    static Feedback.Salutation initSalutationFromPreferences(IEclipsePreferences settings) {
        String salutationString = settings.get(FEEDBACK_SALUTATION, null);
        Feedback.Salutation salutation = null;
        if (salutationString != null) {
            salutation = Feedback.Salutation.fromPresentationName((String)salutationString);
        }
        if (salutation == null) {
            return Feedback.Salutation.MR;
        }
        return salutation;
    }

    private String[] getSalutations() {
        Feedback.Salutation[] values = Feedback.Salutation.values();
        String[] presentationNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            presentationNames[i] = values[i].getPresentationName();
            ++i;
        }
        return presentationNames;
    }

    public final ConnectionMode getConnectionMode() {
        return this.m_connectionMode;
    }

    protected String getContextInfoLabel() {
        return "Context info: ";
    }

    protected void addAdditionalWidgets() {
    }

    public final Feedback.Salutation getSalutation() {
        return this.m_salutation;
    }

    public final String getContactName() {
        return this.m_contactName;
    }

    public final String getEmail() {
        return this.m_email;
    }

    public final String getPhone() {
        return this.m_phone;
    }

    public final String getContextInfo() {
        return this.m_contextInfo;
    }

    public final String getSubject() {
        return this.m_subject;
    }

    public void storeSettings() {
        IEclipsePreferences settings = PreferencesUtility.getPreferences(this.m_bundleId, UiSwtDialogId.FEEDBACK_DIALOG);
        settings.put(FEEDBACK_SALUTATION, this.getSalutation().getPresentationName());
        settings.put(FEEDBACK_CONTACT_NAME, this.getContactName() == null ? "" : this.getContactName());
        settings.put(FEEDBACK_EMAIL, this.getEmail() == null ? "" : this.getEmail());
        settings.put(FEEDBACK_PHONE, this.getPhone() == null ? "" : this.getPhone());
        PreferencesUtility.save(settings);
    }

    public void setContactName(String contactName) {
        assert (contactName != null) : "Parameter 'contactName' of method 'setContactName' must not be null";
        this.m_contactName = contactName;
        this.m_contactNameText.setText(this.m_contactName);
    }

    public void setEmail(String email) {
        assert (email != null) : "Parameter 'email' of method 'setEmail' must not be null";
        this.m_email = email;
        this.m_emailText.setText(this.m_email);
    }

    public void setPhone(String phone) {
        assert (phone != null) : "Parameter 'phone' of method 'setPhone' must not be null";
        this.m_phone = phone;
        this.m_phoneText.setText(phone);
    }

    public void setSubject(String subject) {
        assert (subject != null) : "Parameter 'subject' of method 'setSubject' must not be null";
        assert (this.m_subjectText != null) : "'m_subjectText' of method 'setSubject' must not be null";
        this.m_subject = subject;
        this.m_subjectText.setText(subject);
    }

    public void setContextInfo(String contextInfo) {
        assert (contextInfo != null) : "Parameter 'contextInfo' of method 'setContextInfo' must not be null";
        this.m_contextInfo = contextInfo;
        this.m_contextText.setText(contextInfo);
    }

    protected TFile getLogFile() {
        return this.m_logFile;
    }

    protected String getBundleId() {
        return this.m_bundleId;
    }

    protected boolean validateInputFields() {
        return true;
    }

    public static interface IListener {
        public void modified();
    }
}

